/**
 * FreedomReader Admin JavaScript
 *
 * @package FreedomReader
 */

jQuery( document ).ready(
	function ($) {
		'use strict';

		// Settings form handler
		$( '#freedomreader-settings-form' ).on(
			'submit',
			function (e) {
				e.preventDefault();

				var formData = $( this ).serialize();
				formData    += '&action=freedomreader_save_settings';
				formData    += '&nonce=' + freedomreader_ajax.nonce;

				$.post(
					freedomreader_ajax.ajax_url,
					formData,
					function (response) {
						if (response.success) {
							alert( 'Settings saved successfully!' );
						} else {
							alert( 'Error saving settings: ' + response.data.message );
						}
					}
				);
			}
		);

		// Content lock type change handler
		$( '#freedomreader_lock_type' ).on(
			'change',
			function () {
				var lockType   = $( this ).val();
				var priceField = $( '#freedomreader_price' ).closest( 'p' );

				if (lockType === 'purchase') {
					priceField.show();
				} else {
					priceField.hide();
				}
			}
		).trigger( 'change' );
	}
);
