<?php
/**
 * Payment endpoint handlers
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Register REST API routes for payment callbacks
 */
function freech_register_payment_endpoints() {
    register_rest_route('freechatbots/v1', '/payment/success', [
        'methods' => 'GET',
        'callback' => 'freech_payment_success_callback',
        'permission_callback' => '__return_true', // Public endpoint
    ]);

    register_rest_route('freechatbots/v1', '/payment/cancel', [
        'methods' => 'GET',
        'callback' => 'freech_payment_cancel_callback',
        'permission_callback' => '__return_true', // Public endpoint
    ]);
}
add_action('rest_api_init', 'freech_register_payment_endpoints');

/**
 * Register and enqueue payment page styles
 */
function freech_payment_page_styles() {
    wp_register_style('wprag-payment-pages', FREECH_RAG_CHATBOT_URL . 'css/payment-pages.css', array(), '1.0.0');
    wp_enqueue_style('wprag-payment-pages');
}

/**
 * Payment success callback
 */
function freech_payment_success_callback($request) {
    // Define this as a normal WordPress page load
    define('WP_USE_THEMES', false);
    
    // This enables the WordPress environment for our page
    require_once(ABSPATH . 'wp-load.php');
    
    // Register and enqueue our styles properly
    add_action('wp_enqueue_scripts', 'freech_payment_page_styles');
    
    // Set the content type header for HTML
    header('Content-Type: text/html; charset=UTF-8');
    
    // Start output
    ?>
    <!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Payment Successful</title>
        <?php 
        // Proper WordPress way to include styles
        wp_enqueue_scripts();
        wp_print_styles();
        ?>
    </head>
    <body>
        <div class="container">
            <h1>Payment Successful!</h1>
            <p>Your tokens have been added to your account.</p>
            <p class="note"><strong>Please refresh the admin page to see your updated token balance.</strong></p>
            <p>You can close this window now.</p>
            <button onclick="window.close();" class="button">Close Window</button>
        </div>
    </body>
    </html>
    <?php
    exit;
}

/**
 * Payment cancel callback
 */
function freech_payment_cancel_callback($request) {
    // Define this as a normal WordPress page load
    define('WP_USE_THEMES', false);
    
    // This enables the WordPress environment for our page
    require_once(ABSPATH . 'wp-load.php');
    
    // Register and enqueue our styles properly
    add_action('wp_enqueue_scripts', 'freech_payment_page_styles');
    
    // Set the content type header for HTML
    header('Content-Type: text/html; charset=UTF-8');
    
    // Start output
    ?>
    <!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Payment Cancelled</title>
        <?php 
        // Proper WordPress way to include styles
        wp_enqueue_scripts();
        wp_print_styles();
        ?>
    </head>
    <body>
        <div class="container">
            <h1 class="error">Payment Cancelled</h1>
            <p>Your payment was cancelled. No tokens have been added to your account.</p>
            <p>You can close this window now.</p>
            <button onclick="window.close();" class="button">Close Window</button>
        </div>
    </body>
    </html>
    <?php
    exit;
} 