<?php
if (!defined('ABSPATH')) {
    exit;
}

// Add action to enqueue scripts and styles
add_action('wp_enqueue_scripts', 'rag_chatbot_enqueue_frontend_scripts');

// Enqueue frontend scripts
function rag_chatbot_enqueue_frontend_scripts() {
    // Enqueue marked.js from CDN
    wp_enqueue_script('marked-js', FREECH_RAG_CHATBOT_URL . 'js/marked.min.js', array(), '15.0.8', true);
    
    // Enqueue our frontend script
    wp_register_script('rag-chatbot-frontend-js', FREECH_RAG_CHATBOT_URL . 'js/frontend.js', array('jquery'), '1.0.0', true);
    
    // Pass data to the script
    wp_localize_script('rag-chatbot-frontend-js', 'ragChatbotFrontend', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('rag_chatbot_nonce')
    ));
    
    wp_enqueue_script('rag-chatbot-frontend-js');
}

add_action('wp_footer', 'freech_rag_chatbot_frontend_display');

function freech_rag_chatbot_frontend_display() {
    ?>
    <!-- Simple chat widget with forced visibility controls -->
    <div style="position: fixed; bottom: 20px; right: 20px; z-index: 9999999;">
        <!-- Chat icon -->
        <div id="chat-icon" style="width: 60px; height: 60px; background: #0084FF; border-radius: 50%; cursor: pointer; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 10px rgba(0,0,0,0.2);">
            <span style="color: white; font-size: 24px;">💬</span>
        </div>
        
        <!-- Chat window - initially hidden -->
        <div id="chat-window" style="display: none; position: fixed; bottom: 90px; right: 20px; width: 90%; max-width: 350px; height: 500px; background: #fff; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); z-index: 9999999;">
            <!-- Header -->
            <div style="padding: 15px; background: #0084FF; border-top-left-radius: 10px; border-top-right-radius: 10px; display: flex; justify-content: space-between; align-items: center;">
                <h3 style="margin: 0; padding: 0; font-size: 16px; color: white; font-weight: normal;">Chat Assistant</h3>
                <span id="chat-close" style="color: white; font-size: 24px; cursor: pointer; padding: 5px 10px; line-height: 1;">&times;</span>
            </div>
            
            <!-- Messages -->
            <div id="chat-messages" style="height: 65%; padding: 15px; overflow-y: auto; background: white;">
                <!-- Messages will be added here -->
            </div>
            
            <!-- Input -->
            <div style="padding: 10px; border-top: 1px solid #eee; display: flex; gap: 8px; align-items: center;">
                <input id="chat-input" type="text" placeholder="Type your message..." style="flex: 1; padding: 10px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
                <button id="chat-send" type="button" style="min-width: 70px; padding: 8px 16px; background: #0084FF; color: white; border: none; border-radius: 4px; cursor: pointer; white-space: nowrap; font-size: 14px;">Send</button>
            </div>
            
            <!-- Powered by footer -->
            <div style="padding: 5px; text-align: center; font-size: 11px; color: #999; border-top: 1px solid #eee;">
                <a href="https://freechatbots.ai" target="_blank" style="color: #999; text-decoration: none; opacity: 0.8;">Powered by Freechatbots.ai</a>
            </div>
        </div>
    </div>
    <?php
} 