<?php
//	prevent direct accesss
if ( ! defined( 'ABSPATH' ) )  
	die( 'Direct access to this script is not allowed!' );

//	plugin's main class
class fpwCategoryThumbnails {
	var	$fctOptions, $fptOptions;
	var $formSubmited;
	var $optionsUpdateOk;
	var $mapUpdateOk;
	var	$fctPath;
	var	$fctUrl;
	var	$fctVersion;
	var	$fctPage, $fptPage;
	var	$wpVersion;
	var $mapArray;
	var	$categoryListTable;
	var	$showRestore;
	var $javaScriptEnabled;

	//	constructor
	function __construct( $path, $version ) {
		global $wp_version;

		//	set plugin's path
		$this->fctPath = $path;

		//	set plugin's url
		$this->fctUrl = plugins_url() . '/fpw-category-thumbnails';

		//	set version
		$this->fctVersion = $version;

		//	set WP version
		$this->wpVersion = $wp_version;

		//	initialize $showRestore
		$this->showRestore = false;

		//	read plugin's options
		$this->fctOptions = $this->getOptions();

		//	actions and filters
		add_action( 'init', array( $this, 'init' ) );
        add_action( 'after_setup_theme', array( $this, 'addThemeSupportForThumbnails' ) );
		add_action( 'save_post', array( $this, 'addThumbnailToPost' ), 10, 2 );
		add_action( 'after_plugin_row_fpw-category-thumbnails/fpw-category-thumbnails.php', array( $this, 'afterPluginMeta' ), 10, 2 );
		add_action( 'admin_bar_menu', array( $this, 'pluginToAdminBar' ), 1010 );
		add_action( 'admin_menu', array( $this, 'adminMenu' ) );
		register_activation_hook( $this->fctPath . '/fpw-category-thumbnails.php', array( $this, 'uninstallMaintenance' ) );

		//	AJAX group of actions
		add_action( 'wp_ajax_fpw_fs_get_file', array( $this, 'fpw_fs_get_file_ajax' ) );
		add_action( 'wp_ajax_fpw_ct_update' , array( $this, 'fpw_ct_update_ajax' ) );
		add_action( 'wp_ajax_fpw_ct_apply', array( $this, 'fpw_ct_apply_ajax' ) );
		add_action( 'wp_ajax_fpw_ct_remove', array( $this, 'fpw_ct_remove_ajax' ) );
		add_action( 'wp_ajax_fpw_ct_restore', array( $this, 'fpw_ct_restore_ajax' ) );

		add_filter( 'plugin_action_links_fpw-category-thumbnails/fpw-category-thumbnails.php', array( $this, 'pluginLinks' ), 10, 2);
		add_filter( 'plugin_row_meta', array( $this, 'pluginMetaLinks'), 10, 2 );
		if( $this->fctOptions['ccats'] ) {
            add_filter('manage_edit-category_columns', array( $this, 'fpw_category_columns_head' ) );
            add_filter('manage_category_custom_column', array( $this, 'fpw_custom_category_column_content' ), 10, 3 );
        }
   		if( $this->fctOptions['cposts'] ) {
    		add_filter('manage_post_posts_columns', array( $this, 'fpw_posts_columns_head' ) );
            add_action('manage_post_posts_custom_column', array( $this, 'fpw_custom_posts_column_content' ), 10, 2 );
        }
	}

	//	add theme support for thumbnails if not provided by current theme already
	function addThemeSupportForThumbnails() {
		if ( !current_theme_supports( 'post-thumbnails' ) )
			add_theme_support( 'post-thumbnails' );
	}
    
    //  move key before another key
    function fpw_move_key_before( $arr, $find, $move ) {
        if ( !isset( $arr[$find], $arr[$move] ) ) {
            return $arr;
        }
        $elem = [$move=>$arr[$move]];  // cache the element to be moved
        $start = array_splice( $arr, 0, array_search( $find, array_keys( $arr ) ) );
        unset( $start[$move]);  // only important if $move is in $start
        return $start + $elem + $arr;
    }

	//	set heading for custom column 'Thumbnail' - Categories admin screen
	function fpw_category_columns_head( $defaults ) {
		$defaults[ 'fpw_thumbnail_column' ]  = __( 'Thumbnail', 'fpw-category-thumbnails' );
        $defaults = $this->fpw_move_key_before( $defaults, 'name', 'fpw_thumbnail_column' );
		return $defaults;
	}

	//	set heading for custom column 'Thumbnail' - Posts admin screen
	function fpw_posts_columns_head( $defaults ) {
        $defaults[ 'fpw_thumbnail_column' ]  = __( 'Thumbnail', 'fpw-category-thumbnails' );
        $defaults = $this->fpw_move_key_before( $defaults, 'title', 'fpw_thumbnail_column' );
		return $defaults;
	}

	//	show value of custom column 'Thumbnail' - Categories admin screen
	function fpw_custom_category_column_content( $data, $column, $id ) {
		if ( $column == 'fpw_thumbnail_column' ) {
			$map = get_option( 'fpw_category_thumb_map' );
			if ( !is_array( $map ) )
				$map = array();
			$thumbnail_id = '0';
			if ( array_key_exists( $id, $map ) ) {
    	    	$value = $map[ $id ];
				$preview_size = 'thumbnail';
				if ( 'ngg-' == substr( $value, 0, 4 ) ) {
					if ( class_exists( 'nggdb' ) ) {
						$thumbnail_id = substr( $value, 4 );
						$picture = nggdb::find_image($thumbnail_id);
						if ( !$picture ) {
							return 	'<span style="font-size: large; color: red">' .
									__( 'NextGen Gallery: picture not found!', 'fpw-category-thumbnails' ) . '</span>';
						} else {
							return '<img src="' . $picture->thumbURL . '" />';
						}
					} else {
						return 	'<span style="font-size: large; color: red">' .
								__( 'NextGen Gallery: not active!', 'fpw-category-thumbnails' ) . '</span>';
					}
				} else {
					if ( 'Author' === $value ) {
						return '[ ' . __( 'Picture', 'fpw-category-thumbnails' ) . ' ]';
					} else {
						if ( wp_attachment_is_image( $value ) ) {
							$fpwImage = wp_get_attachment_image_src( $value );
							return '<img src="' . $fpwImage[0] . '" class="attachment-thumbnail size-thumbnail" alt width="' . 64 . '">';
						} else {
							return 	'<span style="font-size: large; color: red">' .
								__( 'Media Library: picture not found!', 'fpw-category-thumbnails' ) . '</span>';
						}
					}
				}
    	    } else {
				return '';
			}
    	}
    	return $data;
	}

	//	show value of custom column 'Thumbnail' - Posts admin screen
	function fpw_custom_posts_column_content( $column, $id ) {
		if ( $column == 'fpw_thumbnail_column' ) {
            foreach((get_the_category( $id ) ) as $category) {
                $catid = $category->cat_ID;
                //$catname =$category->cat_name;
            }
			$map = get_option( 'fpw_category_thumb_map' );
			if ( !is_array( $map ) )
				$map = array();
			$thumbnail_id = '0';
			if ( array_key_exists( $catid, $map ) ) {
    	    	$value = $map[ $catid ];
				$preview_size = 'thumbnail';
				if ( 'ngg-' == substr( $value, 0, 4 ) ) {
					if ( class_exists( 'nggdb' ) ) {
						$thumbnail_id = substr( $value, 4 );
						$picture = nggdb::find_image($thumbnail_id);
						if ( !$picture ) {
							echo 	'<span style="font-size: large; color: red">' .
									__( 'NextGen Gallery: picture not found!', 'fpw-category-thumbnails' ) . '</span>';
						} else {
							echo '<img src="' . $picture->thumbURL . '" />';
						}
					} else {
						echo 	'<span style="font-size: large; color: red">' .
								__( 'NextGen Gallery: not active!', 'fpw-category-thumbnails' ) . '</span>';
					}
				} else {
					if ( 'Author' === $value ) {
						echo '[ ' . __( 'Picture', 'fpw-category-thumbnails' ) . ' ]';
					} else {
						if ( wp_attachment_is_image( $value ) ) {
							$fpwImage = wp_get_attachment_image_src( $value );
							echo '<img src="' . $fpwImage[0] . '" class="attachment-thumbnail size-thumbnail" alt width="' . 64 . '">';
						} else {
							echo 	'<span style="font-size: large; color: red">' .
								__( 'Media Library: picture not found!', 'fpw-category-thumbnails' ) . '</span>';
						}
					}
				}
    	    } else {
				echo '';
			}
    	}
	}

	//	register plugin's textdomain
	function init() {
		load_plugin_textdomain( 'fpw-category-thumbnails' );
	} 

	//	register admin menu
	function adminMenu() {
		$page_title = __( 'FPW Category Thumbnails', 'fpw-category-thumbnails' );
		$menu_title = __( 'FPW Category Thumbnails', 'fpw-category-thumbnails' );
		$this->fctPage = add_theme_page( $page_title, $menu_title, 'manage_options', 
							'fpw-category-thumbnails', array( $this, 'fctSettings' ) );
		add_action( 'load-' . $this->fctPage, array( $this, 'help' ) );
		add_action( 'load-' . $this->fctPage, array( $this, 'addScreenOptions' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueueScripts' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueuePointerScripts' ) );
	}

	//	register styles, scripts, and localize javascript
	function enqueueScripts( $hook ) {
		if ( ( $this->fctPage == $hook ) || ( 'media-upload-popup' == $hook ) ) {
			require_once $this->fctPath . '/scripts/enqueuescripts.php';
		}
	}

	//	enqueue pointer scripts
	function enqueuePointerScripts( $hook ) {
		if ( $this->fctPage == $hook )
			require_once $this->fctPath . '/scripts/enqueuepointerscripts.php';
	}

	// 	AJAX handler for pointer
	function custom_print_footer_scripts() {
		$pointer = 'fpwfct' . str_replace( '.', '', $this->fctVersion );
    	$pointerContent  = '<h3>' . __( 'What is new in this version?', 'fpw-category-thumbnails' ) . '</h3>';
    	$pointerContent .= '<ul style="list-style:disc outside;margin-left:40px;margin-top:20px;margin-right:40px">';
		$pointerContent .= '<li>' . __( 'Added category thumbnal column to list of posts', 'fpw-category-thumbnails' ) . '</li>';
		$pointerContent .= '</ul>';
    	?>
    	<script type="text/javascript">
    	// <![CDATA[
    		jQuery(document).ready( function($) {
        		$('#fct-settings-title').pointer({
        			content: '<?php echo $pointerContent; ?>',
        			position: 'top',
            		close: function() {
						jQuery.post( ajaxurl, {
							pointer: '<?php echo $pointer; ?>',
							action: 'dismiss-wp-pointer'
						});
            		}
				}).pointer('open');
			});
    	// ]]>
    	</script>
    	<?php
	}

	//	add screen options
	function addScreenOptions() {
		$option = 'per_page';
		$categories_per_page = get_user_option( 'edit_category_per_page', get_current_user_id() );
		if ( !$categories_per_page )
			$categories_per_page = 10;
		$args = array(
			'label'		=> _n( 'Category', 'Categories', $categories_per_page, 'fpw-category-thumbnails' ),
			'default'	=> 10,
			'option'	=> 'edit_category_per_page',
		);
		add_screen_option( $option, $args );
		add_filter( 'load-' . $this->fctPage, array( $this, 'setScreenOption'), 10, 3 );
	}

	//	redisplay table after change of categories per page
	function setScreenOption( $status, $option, $value ) {
		if ( 'edit_category_per_page' == $option ) {
			unset( $this->categoryListTable );
			$this->categoryListTable = new fpw_Category_Thumbnails_Table( $this->mapArray ); 
			$this->categoryListTable->prepare_items();
			$this->categoryListTable->display();
			return $value;
		}
	}

	//	contextual help
	function help() {
		require_once $this->fctPath . '/help/help.php';
	}

	// AJAX wrapper to get image HTML
	function fpw_fs_get_file_ajax() {
		if ( defined("DOING_AJAX") && DOING_AJAX ) 
			require_once $this->fctPath . '/ajax/getimageid.php';
	}

	// AJAX wrapper to perform options update
	function fpw_ct_update_ajax() {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX )
			require_once $this->fctPath . '/ajax/update.php';
	}

	// AJAX wrapper to perform apply mapping tasks
	function fpw_ct_apply_ajax() {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX )
			require_once $this->fctPath . '/ajax/apply.php';
	}

	// AJAX wrapper to perform remove thumbnails
	function fpw_ct_remove_ajax() {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX )
			require_once $this->fctPath . '/ajax/remove.php';
	}

	// AJAX wrapper to perform restore thumbnails
	function fpw_ct_restore_ajax() {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX )
			require_once $this->fctPath . '/ajax/restore.php';
	}

	// AJAX wrapper to perform translation file loading
	function fpw_ct_language_ajax() {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX )
			require_once $this->fctPath . '/ajax/language.php';
	}

	//	add update information after plugin meta
	function afterPluginMeta( $file, $plugin_data ) {
		$current = get_site_transient( 'update_plugins' );
		if ( !isset( $current -> response[ $file ] ) ) 
			return false;

		$update = str_replace( '<ul>', '<ul style="list-style:disc outside;margin-left:30px">', $plugin_data[ 'upgrade_notice' ] );
		echo '<tr class="plugin-update-tr active"><td colspan="3" class="plugin-update colspanchange"><div class="update-message notice inline notice-warning notice-alt">' . 
			'<h3 style="text-decoration:underline">Version ' . $plugin_data[ 'new_version' ] . ' - Update Info</h3>' . $update . '</div></td></tr>';
	}

	//	add link to Donation to plugins meta
	function pluginMetaLinks( $links, $file ) {
		if ( 'fpw-category-thumbnails/fpw-category-thumbnails.php' == $file ) 
			$links[] = '<a href="http://fw2s.com/payments-and-donations/" target="_blank">' . __( "Donate", "fpw-category-thumbnails" ) . '</a>';
		return $links;
	}
	//	add link to settings page in plugins list
	function pluginLinks( $links, $file ) {
   		$settings_link = '<a href="' . site_url( '/wp-admin/' ) . 'themes.php?page=fpw-category-thumbnails">' . __( 'Settings', 'fpw-category-thumbnails' ) . '</a>';
		array_unshift( $links, $settings_link );
    	return $links;
	}

	//	uninstall file maintenance
	function uninstallMaintenance() {
		if ( $this->fctOptions[ 'clean' ] ) { 
			if ( file_exists( $this->fctPath . '/uninstall.txt' ) ) 
				rename( $this->fctPath . '/uninstall.txt', $this->fctPath . '/uninstall.php' );
		} else {
			if ( file_exists( $this->fctPath . '/uninstall.php' ) ) 
				rename( $this->fctPath . '/uninstall.php', $this->fctPath . '/uninstall.txt' );
		}
	}	

	//	add plugin to admin bar	
	function pluginToAdminBar() {
		if ( current_user_can( 'manage_options' ) ) {
			global 	$wp_admin_bar;

			$main = array(
				'id' => 'fpw_plugins',
				'title' => __( 'FPW Plugins', 'fpw-category-thumbnails' ),
				'href' => '#' );

			$subm = array(
				'id' => 'fpw_bar_category_thumbnails',
				'parent' => 'fpw_plugins',
				'title' => __( 'FPW Category Thumbnails', 'fpw-category-thumbnails' ),
				'href' => get_admin_url() . 'themes.php?page=fpw-category-thumbnails' );

			$addmain = ( is_array( $wp_admin_bar->get_node( 'fpw_plugins' ) ) ) ? false : true;
			if ( $addmain )
				$wp_admin_bar->add_menu( $main );
			$wp_admin_bar->add_menu( $subm );
		}
	}

	private function doApplyMapping() {
		$map = get_option( 'fpw_category_thumb_map' );
		if ( $map )
			while ( strlen( key( $map ) ) ) {
				$catid = key($map);
				$parg = array(
					'numberofposts' => -1,
					'nopaging' => true,
					'category' => $catid,
					'post_type' => 'any' );
				$posts = get_posts( $parg );
				foreach ( $posts as $post ) {
					$post_id = $post->ID;

					//	make sure this is not a revision nor draft
					if ( 'publish' === $post->post_status ) 
						$this->addThumbnailToPost( $post_id, $post );
				}
				next($map);
			}	
	}

	private function doRemoveThumbnails() {
		$deletedThumbnails = array();

		$parg = array(
			'numberofposts' => -1,
			'nopaging' => true,
			'post_type' => 'any' );

		$posts = get_posts( $parg );

		foreach ( $posts as $post ) {
			$post_id = absint( $post->ID );

			//	make sure this is not a revision
			if ( 'publish' === $post->post_status ) {
				$value = get_post_meta( $post_id, '_thumbnail_id', true );
				if ( !empty( $value ) ) {
					$deletedThumbnails[ $post_id ] = ( string ) $value;
					delete_post_meta( $post_id, '_thumbnail_id' );
				}
			}
		}

		if ( 0 !== count( $deletedThumbnails ) ) {
			update_option( 'fpw_category_thumb_bkp', $deletedThumbnails );
			return true;
		}
		return false;
	}

	private function doRestoreThumbnails() {
		$backedupThumbnails = get_option( 'fpw_category_thumb_bkp', false );

		foreach ( $backedupThumbnails as $key => $value ) {
			$post = get_post( $key );

			//	make sure this is not a revision
			if ( 'publish' === $post->post_status )
				update_post_meta( $key, '_thumbnail_id', $value );
		}
		delete_option( 'fpw_category_thumb_bkp' );
	}

	//	plugin's Settings page
	function fctSettings() {
		$postsFound = false;
		$langMessage = '';

		//	get all categories
		$categories	= $this->getAllCategories();

		//	get assignments array
		$assignments = $this->getAssignmentsArray( $categories );
		$assignments = $this->updateMapping( $assignments );

		//	check for no JavaScript form submission
		$this->formSubmited =
			(	isset( $_POST[ 'submit-update' ] ) || isset( $_POST[ 'submit-apply' ] ) || 
				isset( $_POST[ 'submit-remove' ] ) || isset( $_POST[ 'submit-restore' ] ) || 
				isset( $_POST[ 'submit-language' ] ) );
		if ( $this->formSubmited ) {
			$this->fctOptions[ 'clean' ] = isset( $_POST[ 'cleanup' ] );
			$this->fctOptions[ 'donotover' ] = isset( $_POST[ 'donotover' ] );
			$this->fctOptions[ 'fpt'] = isset( $_POST[ 'fpt' ] );
			$this->optionsUpdateOk = update_option( 'fpw_category_thumb_opt', $this->fctOptions );

			//	NO JAVASCRIPT FORM SUBMISSION HANDLER
			if ( isset( $_POST['submit-update'] ) ) {
				if ( $this->optionsUpdateOk ) 
					$this->uninstallMaintenance();
			}

			if ( isset( $_POST['submit-apply'] ) ) {
				$this->doApplyMapping();
			}
			if ( isset( $_POST['submit-remove'] ) ) {
				$postsFound = $this->doRemoveThumbnails();
			}
			if ( isset( $_POST['submit-restore'] ) ) {
				$this->doRestoreThumbnails();
			}
			if ( isset( $_POST['submit-language'] ) ) {
				$langMessage = $this->doGetLanguage();
			}
			//	END OF NO JAVASCRIPT FORM SUBMISSION HANDLER
		}

		//	get removed thumbnails backup
		$backedupThumbnails = get_option( 'fpw_category_thumb_bkp', false );
		if ( false != $backedupThumbnails )
			$this->showRestore = true;
		if ( $this->formSubmited ) {
			if ( !isset( $_POST[ 'fpw-fct-nonce' ] ) ) 
				die( '<br />&nbsp;<br /><p style="padding-left: 20px; color: red"><strong>' . 
					 __( 'You did not send any credentials!', 'fpw-category-thumbnails' ) . '</strong></p>' );
			if ( !wp_verify_nonce( $_POST[ 'fpw-fct-nonce' ], 'fpw-fct-nonce' ) ) 
				die( '<br />&nbsp;<br /><p style="padding-left: 20px; color: red;"><strong>' . 
					 __( 'You did not send the right credentials!', 'fpw-category-thumbnails' ) . '</strong></p>' );
		} 

		/*	------------------------------
		Settings page HTML starts here
		--------------------------- */
		echo '<div class="wrap">';
		$displayAttr = ( $this->fctOptions[ 'fpt' ] ) ? '' : 'display: none';
		$lt43 = version_compare( $this->wpVersion, '4.3', '<' );
		echo '<h' . ( $lt43 ? '2' : '1' ) . 
			 ' id="fct-settings-title">' . __( 'FPW Category Thumbnails', 'fpw-category-thumbnails' ) .
			 ' <a style="' . $displayAttr . '" id="fpt-link" class="' . ( $lt43 ? 'add-new-h2' : 'page-title-action' ) . '" href="' . get_admin_url() . 
			 '?page=fpw-post-thumbnails">' . __( 'FPW Post Thumbnails', 'fpw-category-thumbnails' ) . 
			 '</a></h' . ( $lt43 ? '2' : '1' ) . '>';

		//	check if any of submit buttons was pressed
		if ( $this->formSubmited ) {
			if ( isset( $_POST['submit-update'] ) ) {
				if ( $this->optionsUpdateOk || $this->mapUpdateOk ) { 
					echo '<div id="message" class="updated fade"><p><strong>' . __( 'Changes saved successfully.', 'fpw-category-thumbnails' ) . '</strong></p></div>';
				} else {
					echo '<div id="message" class="updated fade"><p><strong>' . __( 'No changes detected.', 'fpw-category-thumbnails' ) . '</strong></p></div>';
				}
			} elseif ( isset( $_POST['submit-apply'] ) ) {
				echo '<div id="message" class="updated fade"><p><strong>' . __( 'Added thumbnails to existing posts successfully.', 'fpw-category-thumbnails' ) . '</strong></p></div>';
			} elseif ( isset( $_POST['submit-remove'] ) ) {
				echo '<div id="message" class="updated fade"><p><strong>';
				if ( $postsFound ) {
					echo __( 'Thumbnails removed from all posts successfully. Backup created.', 'fpw-category-thumbnails' );
				} else {
					echo __( 'No thumbnails to be removed found.', 'fpw-category-thumbnails' );
				}
				echo '</strong></p></div>';
			} elseif ( isset( $_POST['submit-restore'] ) ) {
				echo '<div id="message" class="updated fade"><p><strong>' . __( 'All thumbnails restored from the backup successfully.', 'fpw-category-thumbnails' ) . '</strong></p></div>';
			} elseif ( isset( $_POST['submit-language'] ) ) {
				echo '<div id="message" class="updated"><p><strong>' . $langMessage . '</strong></p></div>';
			}
		}

		//	the form starts here
		echo '<div>';
		echo '<form name="fpw_cat_thmb_form" action="?page=fpw-category-thumbnails" method="post">';
		//	protect this form with nonce
		echo '<input name="fpw-fct-nonce" type="hidden" value="' . wp_create_nonce( 'fpw-fct-nonce' ) . '" />';
		//	notification division for AJAX
		echo 	'<div id="message" class="updated" style="' . 
				'display: none;"><p>&nbsp;</p></div>';

		//	options section
		echo '<div id="fpw-fct-options" style="position: relative; margin-top: 5px;">';

		//	do not overwrite checkbox
		echo '<input type="checkbox" class="option-group" id="box-donotover" name="donotover" value="donotover"';
		if ( $this->fctOptions[ 'donotover' ] ) 
			echo ' checked';
		echo '> ' . __( 'Do not overwrite if post / page has thumbnail assigned already', 'fpw-category-thumbnails' ) . '<br />';

		//	cleanup checkbox
		echo '<input type="checkbox" class="option-group" id="box-cleanup" name="cleanup" value="cleanup"';
		if ( $this->fctOptions[ 'clean' ] ) 
			echo ' checked';
		echo '> ' . __( "Remove plugin's data from database on uninstall", 'fpw-category-thumbnails' ) . '<br />';

		//	add thumbnail column for categories list checkbox
		echo '<input type="checkbox" class="option-group" id="box-ccats" name="ccats" value="ccats"';
		if ( $this->fctOptions[ 'ccats' ] ) 
			echo ' checked';
		echo '> ' . __( "Add thumbnail column to categories list", 'fpw-category-thumbnails' ) . '<br />';

		//	add thumbnail column for posts list checkbox
		echo '<input type="checkbox" class="option-group" id="box-cposts" name="cposts" value="cposts"';
		if ( $this->fctOptions[ 'cposts' ] ) 
			echo ' checked';
		echo '> ' . __( "Add thumbnail column to posts list", 'fpw-category-thumbnails' ) . '<br />';

		//	enable FPW Post Thumbnails plugin checkbox
		echo '<input type="checkbox" class="option-group" id="box-fpt" name="fpt" value="fpt"';
		if ( $this->fctOptions[ 'fpt' ] ) 
			echo ' checked';
		echo '> ' . __( 'Enable FPW Post Thumbnails', 'fpw-category-thumbnails' ) . '<br />';
		//	end of options section
		echo '</div>';
		require_once $this->fctPath . '/code/table.php';

		//	end of form
		echo '</form>';
		echo '</div>';
		echo '</div>';
	}

	//	update mapping array
	function updateMapping( $a ) {
		$map = get_option( 'fpw_category_thumb_map' );

		foreach ( $_POST as $key => $value ) {
			if ( ( 'val-for-id-' == substr( $key, 0, 11 ) ) && !( '-field_preview-size' == substr( $key, strlen( $key ) - 19, 19 ) ) ) {
				$replace = array( 'val-for-id-', '-field' );
				$with = array( '', '' );
				$id = str_replace( $replace, $with, $key );
				$a[ $id ] = $value;
				$map[ $id ] = $value;
			} 
		}

		$map_filtered = array();
		if ( !empty( $map ) )
			foreach( $map as $key => $value ) 
   				if( $value != '0' ) 
       				$map_filtered[ $key ] = $value;
       	$this->mapUpdateOk = ( update_option( 'fpw_category_thumb_map', $map_filtered ) );
		return $a;
	}

	//	build categories' array
	function getAllCategories() {
		$categories = array();
		$cats0 = get_categories('hide_empty=0&orderby=name&parent=0');

		foreach ( $cats0 as $cats00 ) {
    		array_push( $categories, array(0,$cats00) );
    		$cats1 = get_categories('hide_empty=0&orderby=name&parent='.$cats00->cat_ID);

    		foreach ( $cats1 as $cats10 ) {
        		array_push( $categories, array(1,$cats10) );
        		$cats2 = get_categories('hide_empty=0&orderby=name&parent='.$cats10->cat_ID);

        		foreach ( $cats2 as $cats20 ) {
            		array_push( $categories, array(2,$cats20) );
            		$cats3 = get_categories('hide_empty=0&orderby=name&parent='.$cats20->cat_ID);

            		foreach ( $cats3 as $cats30 ) {
                		array_push( $categories, array(3,$cats30) );
                		$cats4 = get_categories('hide_empty=0&orderby=name&parent='.$cats30->cat_ID);

                		foreach ( $cats4 as $cats40 ) {
                    		array_push( $categories, array(4,$cats40) );
                    		$cats5 = get_categories('hide_empty=0&orderby=name&parent='.$cats40->cat_ID);

                    		foreach ( $cats5 as $cats50 ) {
                        		array_push( $categories, array(5,$cats50) );
                    		}

                		}

            		}

        		}

    		}

		}

		reset( $categories );
		return $categories;	
	}

	//	build assignments array
	function getAssignmentsArray( $c ) {
		$assignments	= array();

		foreach ( $c as $category ) {
			$assignments[ $category[1] -> cat_ID ] = 0;
		}

		//	get assignments from database
		$opt = get_option( 'fpw_category_thumb_map' );

		// update $assignments array with values from database
		if ( $opt ) {
	    	reset( $assignments );

			while ( strlen( key( $assignments ) ) ) {
				if ( array_key_exists( key( $assignments ), $opt ) ) {
					$assignments[ key( $assignments ) ] = $opt[ key( $assignments ) ];	
				}
				next( $assignments );
			}
		}
		reset( $assignments );
		return $assignments;	
	}

	//	get plugin's options ( build if does not exist )
	function getOptions() {
		$needs_update = FALSE;
		$opt = get_option( 'fpw_category_thumb_opt' );
		if ( !is_array( $opt ) ) {
			$needs_update = TRUE;

			$opt = array( 
				'clean'		=> FALSE,
				'donotover' => FALSE,
                'ccats'     => FALSE,
                'cposts'    => FALSE,
				'fpt'		=> FALSE );

		} else {
			if ( !array_key_exists( 'clean', $opt ) || !is_bool( $opt[ 'clean' ] ) ) { 
				$needs_update = TRUE;
				$opt[ 'clean' ] = FALSE;
			}
			if ( !array_key_exists( 'donotover', $opt ) || !is_bool( $opt[ 'donotover' ] ) ) { 
				$needs_update = TRUE;
				$opt[ 'donotover' ] = FALSE;
			}
			if ( !array_key_exists( 'ccats', $opt ) || !is_bool( $opt[ 'ccats' ] ) ) { 
				$needs_update = TRUE;
				$opt[ 'ccats' ] = FALSE;
			}
			if ( !array_key_exists( 'cposts', $opt ) || !is_bool( $opt[ 'cposts' ] ) ) { 
				$needs_update = TRUE;
				$opt[ 'cposts' ] = FALSE;
			}
			if ( !array_key_exists( 'fpt', $opt ) || !is_bool( $opt[ 'fpt' ] ) ) { 
				$needs_update = TRUE;
				$opt[ 'fpt' ] = FALSE;
			}
			if ( $needs_update ) 
				update_option( 'fpw_category_thumb_opt', $opt );
		}
		return $opt;
	}

	/*	------------------------------------------------------------------
	Main action - sets the value of post's _thumbnail_id based on category
	assignments
	------------------------------------------------------------------- */
	function addThumbnailToPost( $post_id, $post = NULL ) {
		if ( NULL === $post ) 
			return;

		//	we don't want to apply changes to post's revision or drafts
		if ( ( 'revision' == $post->post_type ) || ( 'draft' == $post->post_status ) || ( 'auto-draft' == $post->post_status ) ) 
			return;

		$catThumbnails = array();

		//	this is actual post
		$thumb_id = get_post_meta( $post_id, '_thumbnail_id', TRUE );
		$map = get_option( 'fpw_category_thumb_map' );
		if ( $map ) {
			$cat = get_the_category( $post_id );

			foreach ( $cat as $c ) {
				if ( array_key_exists( $c->cat_ID, $map ) ) {
					$catThumbnails[ $c->cat_ID ] = $map[ $c->cat_ID ]; 
					if ( !$this->fctOptions[ 'donotover' ] ) {
						if ( $map[ $c->cat_ID ] === 'Author' ) {
							$auth_pic_id = self::getAuthorsPictureID( $post->post_author );
							if ( '0' != $auth_pic_id )
								 update_post_meta( $post_id, '_thumbnail_id', $auth_pic_id );
						} else {
							update_post_meta( $post_id, '_thumbnail_id', $map[ $c->cat_ID ] );
						}
					} else {
						if ( '' == $thumb_id ) {
							if ( $map[ $c->cat_ID ] === 'Author' ) {
								 $auth_pic_id = self::getAuthorsPictureID( $post->post_author );
								 if ( '0' != $auth_pic_id )
								 	update_post_meta( $post_id, '_thumbnail_id', $auth_pic_id );
							} else {
								update_post_meta( $post_id, '_thumbnail_id', $map[ $c->cat_ID ] );
							}
						}
					}
				} else {
					if ( !$this->fctOptions[ 'donotover' ] )
						update_post_meta( $post_id, '_thumbnail_id', '' );
				}
  			}

  			update_post_meta( $post_id, 'fpw_cat_thumbnails_ids', $catThumbnails );
		}
	}

	//	get author's picture id - helper function
	private static function getAuthorsPictureID( $author_id ) {
		global $wpdb;

		$pic_id = 0;
		$all_media = $wpdb->get_results( "SELECT DISTINCT * FROM " . $wpdb->prefix . "posts " .
			"WHERE post_type = 'attachment' AND guid LIKE '%author_" . $author_id . ".jpg%' ORDER " .
			"BY post_date DESC" );

		if ( 0 < count( $all_media ) ) {
			$obj = $all_media[0];
			$pic_id	= $obj->ID;
		} else {
			$active_plugins = get_option( 'active_plugins' );
			$length = count( $active_plugins );
			$nextGenActive = FALSE;
			$i = 0;

			while ( $i < $length ) {
				if ( 0 < strpos( $active_plugins[ $i ], 'nggallery.php' ) ) {
					$nextGenActive = TRUE;
					$i = $length;
				}
				$i++;
			}

			if ( $nextGenActive ) {
				$tmp = $wpdb->get_results( "SELECT DISTINCT * FROM " . $wpdb->prefix . "ngg_gallery WHERE slug = 'authors'" );
				if ( 0 < count( $tmp ) ) {
					$obj = $tmp[0];
					$galleryID = $obj->gid;
					$tmp = $wpdb->get_results( "SELECT DISTINCT * FROM " . $wpdb->prefix . "ngg_pictures " .
						"WHERE galleryid = " . $galleryID . " AND filename LIKE '%" . $author_id . ".jpg%'" );
					if ( 0 < count( $tmp ) ) {
						$obj = $tmp[0];
						$pic_id = 'ngg-' . $obj->pid;
					}
				}
			}
		}	
		return $pic_id;
	}
}
