<?php
/**
 * Hot Lead Alert Email Template
 *
 * @package FormRankLS
 *
 * Available variables:
 * - $lead: Lead data array
 * - $score_result: Score result array with score, label, reasoning
 */

if (!defined('ABSPATH')) {
    exit;
}

$view_url = admin_url("admin.php?page=formrank-lead-scoring-lead&id={$lead['id']}");
$form_data = json_decode($lead['form_data'], true) ?: [];

$colors = [
    'hot' => '#ef4444',
    'warm' => '#f59e0b',
    'neutral' => '#10b981',
    'cool' => '#3b82f6',
    'cold' => '#6b7280'
];
$score_color = $colors[$score_result['label']] ?? '#6b7280';
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php esc_html_e('Hot Lead Alert', 'formrank-lead-scoring'); ?></title>
</head>
<body style="margin: 0; padding: 0; background-color: #f3f4f6; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f3f4f6; padding: 40px 20px;">
        <tr>
            <td align="center">
                <table width="100%" cellpadding="0" cellspacing="0" style="max-width: 600px; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                    <!-- Header -->
                    <tr>
                        <td style="background-color: <?php echo esc_attr($score_color); ?>; padding: 30px; text-align: center;">
                            <h1 style="margin: 0; color: #ffffff; font-size: 24px; font-weight: 600;">
                                &#128293; <?php esc_html_e('Hot Lead Alert!', 'formrank-lead-scoring'); ?>
                            </h1>
                        </td>
                    </tr>

                    <!-- Score -->
                    <tr>
                        <td style="padding: 30px; text-align: center; border-bottom: 1px solid #e5e7eb;">
                            <div style="font-size: 64px; font-weight: 700; color: <?php echo esc_attr($score_color); ?>; line-height: 1;">
                                <?php echo esc_html($score_result['score']); ?>
                            </div>
                            <div style="font-size: 18px; color: <?php echo esc_attr($score_color); ?>; text-transform: uppercase; font-weight: 600; margin-top: 5px;">
                                <?php echo esc_html(ucfirst($score_result['label'])); ?> <?php esc_html_e('Lead', 'formrank-lead-scoring'); ?>
                            </div>
                        </td>
                    </tr>

                    <!-- AI Reasoning -->
                    <tr>
                        <td style="padding: 25px 30px; background-color: #f9fafb; border-bottom: 1px solid #e5e7eb;">
                            <div style="font-size: 12px; text-transform: uppercase; color: #6b7280; font-weight: 600; margin-bottom: 8px;">
                                <?php esc_html_e('AI Assessment', 'formrank-lead-scoring'); ?>
                            </div>
                            <div style="font-size: 15px; color: #374151; line-height: 1.5;">
                                <?php echo esc_html($score_result['reasoning']); ?>
                            </div>
                        </td>
                    </tr>

                    <!-- Contact Info -->
                    <tr>
                        <td style="padding: 30px;">
                            <h2 style="margin: 0 0 20px 0; font-size: 18px; color: #111827; font-weight: 600;">
                                <?php esc_html_e('Contact Information', 'formrank-lead-scoring'); ?>
                            </h2>

                            <table width="100%" cellpadding="0" cellspacing="0" style="font-size: 15px;">
                                <?php if ($lead['name']) : ?>
                                <tr>
                                    <td style="padding: 8px 0; color: #6b7280; width: 100px;"><?php esc_html_e('Name', 'formrank-lead-scoring'); ?></td>
                                    <td style="padding: 8px 0; color: #111827; font-weight: 500;"><?php echo esc_html($lead['name']); ?></td>
                                </tr>
                                <?php endif; ?>

                                <?php if ($lead['email']) : ?>
                                <tr>
                                    <td style="padding: 8px 0; color: #6b7280;"><?php esc_html_e('Email', 'formrank-lead-scoring'); ?></td>
                                    <td style="padding: 8px 0;">
                                        <a href="mailto:<?php echo esc_attr($lead['email']); ?>" style="color: #2563eb; text-decoration: none;">
                                            <?php echo esc_html($lead['email']); ?>
                                        </a>
                                    </td>
                                </tr>
                                <?php endif; ?>

                                <?php if ($lead['company']) : ?>
                                <tr>
                                    <td style="padding: 8px 0; color: #6b7280;"><?php esc_html_e('Company', 'formrank-lead-scoring'); ?></td>
                                    <td style="padding: 8px 0; color: #111827;"><?php echo esc_html($lead['company']); ?></td>
                                </tr>
                                <?php endif; ?>

                                <?php if ($lead['phone']) : ?>
                                <tr>
                                    <td style="padding: 8px 0; color: #6b7280;"><?php esc_html_e('Phone', 'formrank-lead-scoring'); ?></td>
                                    <td style="padding: 8px 0;">
                                        <a href="tel:<?php echo esc_attr($lead['phone']); ?>" style="color: #2563eb; text-decoration: none;">
                                            <?php echo esc_html($lead['phone']); ?>
                                        </a>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </td>
                    </tr>

                    <!-- CTA Button -->
                    <tr>
                        <td style="padding: 0 30px 30px 30px; text-align: center;">
                            <a href="<?php echo esc_url($view_url); ?>" style="display: inline-block; background-color: #2563eb; color: #ffffff; padding: 14px 28px; font-size: 16px; font-weight: 600; text-decoration: none; border-radius: 6px;">
                                <?php esc_html_e('View Lead Details', 'formrank-lead-scoring'); ?> &rarr;
                            </a>
                        </td>
                    </tr>

                    <!-- Footer -->
                    <tr>
                        <td style="padding: 20px 30px; background-color: #f9fafb; text-align: center; border-top: 1px solid #e5e7eb;">
                            <div style="font-size: 13px; color: #6b7280;">
                                <?php
                                printf(
                                    /* translators: %1$s: FormRank Lead Scoring link, %2$s: Site name */
                                    esc_html__('This email was sent by %1$s from %2$s', 'formrank-lead-scoring'),
                                    '<a href="https://formrankwp.com" style="color: #6b7280; text-decoration: underline;">FormRank</a>',
                                    esc_html(get_bloginfo('name'))
                                );
                                ?>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
