<?php
/**
 * Setup Wizard Template — Full page, multi-step, no WP admin chrome
 *
 * Rendered by Setup_Wizard::render() which calls exit after including
 * this file, so no standard WP admin footer is output.
 *
 * @package FormRankLS
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once FORMRANK_LS_PATH . 'includes/data/demo-leads.php';
$industries = formrank_get_demo_industries();
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php esc_html_e( 'FormRank Setup', 'formrank-lead-scoring' ); ?></title>
    <?php wp_print_styles( [ 'dashicons', 'formrank-setup-wizard' ] ); ?>
</head>
<body class="formrank-wizard-body">
    <div class="formrank-wizard-container">

        <!-- Header with logo -->
        <div class="formrank-wizard-header">
            <div class="formrank-wizard-logo">
                <?php
                $logo_path = FORMRANK_LS_PATH . 'assets/images/logo.png';
                if ( file_exists( $logo_path ) ) :
                    ?>
                    <img
                        src="<?php echo esc_url( FORMRANK_LS_URL . 'assets/images/logo.png' ); ?>"
                        alt="<?php esc_attr_e( 'FormRank', 'formrank-lead-scoring' ); ?>"
                        class="formrank-wizard-logo-img"
                        width="32"
                        height="32"
                    >
                <?php else : ?>
                    <span class="dashicons dashicons-chart-line formrank-wizard-logo-icon"></span>
                <?php endif; ?>
                <span class="formrank-wizard-brand"><?php esc_html_e( 'FormRank', 'formrank-lead-scoring' ); ?></span>
            </div>
            <!-- Step indicator -->
            <div class="formrank-wizard-steps" id="formrank-wizard-steps">
                <span class="formrank-step-dot active" data-step="1"></span>
                <span class="formrank-step-dot" data-step="2"></span>
                <span class="formrank-step-dot" data-step="3"></span>
            </div>
        </div>

        <!-- Step 1: Welcome -->
        <div class="formrank-wizard-content formrank-wizard-step" id="formrank-wizard-step-1">
            <span class="dashicons dashicons-chart-line formrank-wizard-hero-icon"></span>
            <h1><?php esc_html_e( 'Welcome to FormRank!', 'formrank-lead-scoring' ); ?></h1>
            <p class="formrank-wizard-subtitle">
                <?php esc_html_e( 'FormRank uses AI to automatically score and prioritize your WordPress form submissions so you can focus on the leads that matter most.', 'formrank-lead-scoring' ); ?>
            </p>

            <div class="formrank-wizard-features">
                <div class="formrank-wizard-feature">
                    <span class="dashicons dashicons-database"></span>
                    <div>
                        <strong><?php esc_html_e( 'Sample data included', 'formrank-lead-scoring' ); ?></strong>
                        <p><?php esc_html_e( "We'll generate realistic demo leads so you can explore all the features right away.", 'formrank-lead-scoring' ); ?></p>
                    </div>
                </div>
                <div class="formrank-wizard-feature">
                    <span class="dashicons dashicons-visibility"></span>
                    <div>
                        <strong><?php esc_html_e( 'Explore at your own pace', 'formrank-lead-scoring' ); ?></strong>
                        <p><?php esc_html_e( 'Browse the dashboard, lead scores, and reports. The demo data stays until you remove it.', 'formrank-lead-scoring' ); ?></p>
                    </div>
                </div>
                <div class="formrank-wizard-feature">
                    <span class="dashicons dashicons-trash"></span>
                    <div>
                        <strong><?php esc_html_e( 'Easy cleanup', 'formrank-lead-scoring' ); ?></strong>
                        <p><?php esc_html_e( 'When you start getting real submissions, remove the demo data with one click from the dashboard.', 'formrank-lead-scoring' ); ?></p>
                    </div>
                </div>
            </div>

            <div class="formrank-wizard-actions">
                <button type="button" class="formrank-wizard-btn-primary" id="formrank-wizard-next-1">
                    <?php esc_html_e( 'Get Started', 'formrank-lead-scoring' ); ?>
                    <span class="dashicons dashicons-arrow-right-alt2"></span>
                </button>
            </div>
        </div>

        <!-- Step 2: Industry Selection -->
        <div class="formrank-wizard-content formrank-wizard-step" id="formrank-wizard-step-2" style="display: none;">
            <h1><?php esc_html_e( 'Select your industry', 'formrank-lead-scoring' ); ?></h1>
            <p class="formrank-wizard-subtitle">
                <?php esc_html_e( "We'll tailor the demo leads to match your business type so everything feels familiar.", 'formrank-lead-scoring' ); ?>
            </p>

            <div class="formrank-wizard-grid">
                <?php foreach ( $industries as $slug => $industry ) : ?>
                    <button
                        type="button"
                        class="formrank-wizard-card"
                        data-industry="<?php echo esc_attr( $slug ); ?>"
                    >
                        <span class="dashicons dashicons-<?php echo esc_attr( $industry['icon'] ); ?>"></span>
                        <span class="formrank-wizard-card-label"><?php echo esc_html( $industry['label'] ); ?></span>
                        <span class="formrank-wizard-card-desc"><?php echo esc_html( $industry['desc'] ); ?></span>
                    </button>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Loading State (hidden by default) -->
        <div class="formrank-wizard-content formrank-wizard-step" id="formrank-wizard-loading" style="display: none;">
            <div class="formrank-wizard-spinner"></div>
            <h2><?php esc_html_e( 'Generating your demo leads...', 'formrank-lead-scoring' ); ?></h2>
            <p><?php esc_html_e( 'This will only take a moment.', 'formrank-lead-scoring' ); ?></p>
        </div>

        <!-- Step 3: Success -->
        <div class="formrank-wizard-content formrank-wizard-step" id="formrank-wizard-step-3" style="display: none;">
            <span class="dashicons dashicons-yes-alt formrank-wizard-success-icon"></span>
            <h2><?php esc_html_e( 'Demo data is ready!', 'formrank-lead-scoring' ); ?></h2>
            <p class="formrank-wizard-success-desc">
                <?php esc_html_e( 'Your dashboard is now populated with sample leads. Take your time exploring the scores, reports, and lead details. When you start receiving real form submissions, you can remove the demo data from the dashboard banner.', 'formrank-lead-scoring' ); ?>
            </p>
            <div class="formrank-wizard-actions">
                <button type="button" class="formrank-wizard-btn-primary" id="formrank-wizard-explore">
                    <span class="dashicons dashicons-visibility"></span>
                    <?php esc_html_e( 'Explore Dashboard', 'formrank-lead-scoring' ); ?>
                </button>
            </div>
        </div>

        <!-- Footer -->
        <div class="formrank-wizard-footer" id="formrank-wizard-footer">
            <a
                href="<?php echo esc_url( admin_url( 'admin.php?page=formrank-lead-scoring-dashboard' ) ); ?>"
                class="formrank-wizard-skip"
                id="formrank-wizard-skip"
            >
                <?php esc_html_e( 'Skip Setup', 'formrank-lead-scoring' ); ?> &rarr;
            </a>
        </div>

    </div>

    <?php wp_print_scripts( [ 'jquery', 'formrank-setup-wizard' ] ); ?>
</body>
</html>
