<?php
/**
 * Settings Template
 *
 * @package FormRankLS
 */

if (!defined('ABSPATH')) {
    exit;
}

use FormRankLS\Admin\Upgrade_Notice;
?>
<div class="wrap formrank-wrap">
    <h1><?php esc_html_e('FormRank Settings', 'formrank-lead-scoring'); ?></h1>

    <?php settings_errors('formrank_settings_group'); ?>

    <div class="formrank-settings-layout">
        <div class="formrank-settings-main">
            <form method="post" action="options.php">
                <?php
                settings_fields('formrank_settings_group');
                do_settings_sections('formrank-lead-scoring-settings');
                submit_button();
                ?>
            </form>
        </div>

    </div>

    <?php
    $settings_obj = new \FormRankLS\Admin\Settings();
    $settings_obj->render_license_section();
    ?>

    <p style="text-align: center; color: #9ca3af; font-size: 12px; margin-top: 24px;">
        <?php
        printf(
            /* translators: %1$s: Documentation link, %2$s: FormRank Lead Scoring link */
            esc_html__('Need help? Visit %1$s | %2$s', 'formrank-lead-scoring'),
            '<a href="https://formrankwp.com/docs" style="color: #9ca3af; text-decoration: underline;">' . esc_html__('Documentation', 'formrank-lead-scoring') . '</a>',
            '<a href="https://formrankwp.com" style="color: #9ca3af; text-decoration: underline;">FormRank</a>'
        );
        ?>
    </p>
</div>
