<?php
/**
 * Scoring Accuracy Metrics Partial
 *
 * @package FormRankLS
 */

defined( 'ABSPATH' ) || exit;

// Determine accuracy color
$accuracy_color = '#10b981'; // green
if ( $accuracy['accuracy'] < 50 ) {
    $accuracy_color = '#ef4444'; // red
} elseif ( $accuracy['accuracy'] < 70 ) {
    $accuracy_color = '#f59e0b'; // orange
}
?>

<div class="formrank-accuracy-display">
    <?php if ( $accuracy['total_evaluated'] === 0 ) : ?>
    <div class="formrank-empty-state formrank-accuracy-empty">
        <span class="dashicons dashicons-chart-area"></span>
        <p><?php esc_html_e( 'Not enough data to calculate accuracy. Mark more leads as converted, lost, or disqualified to see scoring accuracy metrics.', 'formrank-lead-scoring' ); ?></p>
    </div>
    <?php else : ?>

    <!-- Main Accuracy Score -->
    <div class="formrank-accuracy-main">
        <div class="formrank-accuracy-circle" style="background: linear-gradient(135deg, <?php echo esc_attr( $accuracy_color ); ?> 0%, <?php echo esc_attr( $accuracy_color ); ?>cc 100%);">
            <span class="formrank-accuracy-value"><?php echo esc_html( $accuracy['accuracy'] ); ?>%</span>
            <span class="formrank-accuracy-label"><?php esc_html_e( 'Accuracy', 'formrank-lead-scoring' ); ?></span>
        </div>
    </div>

    <!-- Detailed Metrics -->
    <div class="formrank-accuracy-details">
        <div class="formrank-accuracy-metric">
            <span class="formrank-metric-label"><?php esc_html_e( 'Precision', 'formrank-lead-scoring' ); ?></span>
            <span class="formrank-metric-value"><?php echo esc_html( $accuracy['precision'] ); ?>%</span>
            <span class="formrank-metric-hint"><?php esc_html_e( 'High-score leads that converted', 'formrank-lead-scoring' ); ?></span>
        </div>

        <div class="formrank-accuracy-metric">
            <span class="formrank-metric-label"><?php esc_html_e( 'Recall', 'formrank-lead-scoring' ); ?></span>
            <span class="formrank-metric-value"><?php echo esc_html( $accuracy['recall'] ); ?>%</span>
            <span class="formrank-metric-hint"><?php esc_html_e( 'Conversions that were high-score', 'formrank-lead-scoring' ); ?></span>
        </div>
    </div>

    <!-- Confusion Matrix Summary -->
    <div class="formrank-confusion-summary">
        <div class="formrank-confusion-row">
            <span class="formrank-confusion-cell formrank-tp" title="<?php esc_attr_e( 'True Positives: High score leads that converted', 'formrank-lead-scoring' ); ?>">
                <span class="formrank-confusion-icon">&#10003;</span>
                <?php echo esc_html( $accuracy['true_positives'] ); ?>
            </span>
            <span class="formrank-confusion-cell formrank-fp" title="<?php esc_attr_e( 'False Positives: High score leads that did not convert', 'formrank-lead-scoring' ); ?>">
                <span class="formrank-confusion-icon">&#10007;</span>
                <?php echo esc_html( $accuracy['false_positives'] ); ?>
            </span>
        </div>
        <div class="formrank-confusion-labels">
            <span><?php esc_html_e( 'Correctly Predicted', 'formrank-lead-scoring' ); ?></span>
            <span><?php esc_html_e( 'Overestimated', 'formrank-lead-scoring' ); ?></span>
        </div>
    </div>

    <p class="formrank-accuracy-note">
        <?php
        printf(
            /* translators: 1: threshold score, 2: threshold score */
            esc_html__( 'Based on threshold score of %1$d. Leads scoring %2$d+ are predicted to convert.', 'formrank-lead-scoring' ),
            absint( $accuracy['threshold'] ),
            absint( $accuracy['threshold'] )
        );
        ?>
    </p>

    <?php endif; ?>
</div>
