<?php
/**
 * Recent Conversions Timeline Partial
 *
 * @package FormRankLS
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="formrank-recent-conversions">
    <?php if ( empty( $recent ) ) : ?>
    <div class="formrank-empty-state">
        <span class="dashicons dashicons-chart-line"></span>
        <p><?php esc_html_e( 'No conversions yet. Mark leads as converted to track your success!', 'formrank-lead-scoring' ); ?></p>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=formrank-lead-scoring' ) ); ?>" class="button">
            <?php esc_html_e( 'View Leads', 'formrank-lead-scoring' ); ?>
        </a>
    </div>
    <?php else : ?>

    <ul class="formrank-conversion-timeline">
        <?php foreach ( $recent as $conversion ) : ?>
        <li class="formrank-conversion-item">
            <div class="formrank-conversion-icon formrank-segment-<?php echo esc_attr( $conversion['segment'] ); ?>">
                <span class="dashicons dashicons-yes-alt"></span>
            </div>
            <div class="formrank-conversion-details">
                <a href="<?php echo esc_url( admin_url( 'admin.php?page=formrank-lead-scoring-lead&id=' . $conversion['id'] ) ); ?>"
                   class="formrank-conversion-name">
                    <?php echo esc_html( $conversion['name'] ); ?>
                </a>
                <span class="formrank-conversion-meta">
                    <?php
                    printf(
                        /* translators: 1: score, 2: time ago */
                        esc_html__( 'Score: %1$d &bull; %2$s', 'formrank-lead-scoring' ),
                        esc_html( $conversion['score'] ),
                        esc_html( $conversion['time_ago'] )
                    );
                    ?>
                </span>
            </div>
            <span class="formrank-method-badge formrank-<?php echo esc_attr( $conversion['segment'] ); ?>">
                <?php echo esc_html( ucfirst( $conversion['segment'] ) ); ?>
            </span>
        </li>
        <?php endforeach; ?>
    </ul>

    <a href="<?php echo esc_url( admin_url( 'admin.php?page=formrank-lead-scoring&status=converted' ) ); ?>"
       class="formrank-view-all-link">
        <?php esc_html_e( 'View all conversions', 'formrank-lead-scoring' ); ?> &rarr;
    </a>

    <?php endif; ?>
</div>
