<?php
/**
 * Learning Status Card Partial
 *
 * @package FormRankLS
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="formrank-card formrank-learning-status-card">
    <div class="formrank-learning-header">
        <h3 class="formrank-card-title">
            <span class="dashicons dashicons-welcome-learn-more"></span>
            <?php esc_html_e( 'Learning System Status', 'formrank-lead-scoring' ); ?>
        </h3>
        <span class="formrank-mode-badge formrank-mode-<?php echo esc_attr( $learning['mode'] ); ?>">
            <?php echo esc_html( $learning['mode_icon'] . ' ' . $learning['mode_label'] ); ?>
        </span>
    </div>

    <div class="formrank-learning-grid">
        <!-- Mode Description -->
        <div class="formrank-stat-card">
            <div class="formrank-stat-icon" style="background: <?php echo esc_attr( $learning['mode_color'] ); ?>20; color: <?php echo esc_attr( $learning['mode_color'] ); ?>">
                <span class="dashicons dashicons-admin-generic"></span>
            </div>
            <div class="formrank-stat-content">
                <div class="formrank-stat-value"><?php echo esc_html( $learning['mode_label'] ); ?></div>
                <div class="formrank-stat-label"><?php echo esc_html( $learning['mode_description'] ); ?></div>
            </div>
        </div>

        <!-- Leads Count -->
        <div class="formrank-stat-card">
            <div class="formrank-stat-icon formrank-icon-info">
                <span class="dashicons dashicons-groups"></span>
            </div>
            <div class="formrank-stat-content">
                <div class="formrank-stat-value"><?php echo esc_html( number_format( $learning['total_leads'] ) ); ?></div>
                <div class="formrank-stat-label"><?php esc_html_e( 'Total Leads', 'formrank-lead-scoring' ); ?></div>
            </div>
        </div>

        <!-- Conversions Count -->
        <div class="formrank-stat-card">
            <div class="formrank-stat-icon formrank-icon-success">
                <span class="dashicons dashicons-yes-alt"></span>
            </div>
            <div class="formrank-stat-content">
                <div class="formrank-stat-value"><?php echo esc_html( number_format( $learning['total_conversions'] ) ); ?></div>
                <div class="formrank-stat-label"><?php esc_html_e( 'Conversions', 'formrank-lead-scoring' ); ?></div>
            </div>
        </div>

        <!-- Conversion Rate -->
        <div class="formrank-stat-card">
            <div class="formrank-stat-icon formrank-icon-hot">
                <span class="dashicons dashicons-chart-line"></span>
            </div>
            <div class="formrank-stat-content">
                <div class="formrank-stat-value"><?php echo esc_html( $learning['conversion_rate'] ); ?>%</div>
                <div class="formrank-stat-label"><?php esc_html_e( 'Conversion Rate', 'formrank-lead-scoring' ); ?></div>
            </div>
        </div>
    </div>

    <?php if ( $learning['progress']['target'] ) : ?>
    <!-- Progress Section -->
    <div class="formrank-learning-progress">
        <div class="formrank-progress-header">
            <span class="formrank-progress-text">
                <?php
                printf(
                    /* translators: %s: next mode name */
                    esc_html__( 'Progress to %s', 'formrank-lead-scoring' ),
                    esc_html( $learning['progress']['next_mode'] )
                );
                ?>
            </span>
            <span class="formrank-progress-count">
                <?php
                printf(
                    /* translators: 1: current count, 2: target count, 3: type (leads/conversions) */
                    esc_html__( '%1$d / %2$d %3$s', 'formrank-lead-scoring' ),
                    intval( $learning['progress']['current'] ),
                    intval( $learning['progress']['target'] ),
                    esc_html( $learning['progress']['type'] )
                );
                ?>
            </span>
        </div>
        <div class="formrank-usage-meter">
            <div class="formrank-usage-fill"
                 style="width: <?php echo esc_attr( min( 100, $learning['progress']['percent'] ) ); ?>%;
                        background: linear-gradient(90deg, <?php echo esc_attr( $learning['mode_color'] ); ?>, <?php echo esc_attr( $learning['mode_color'] ); ?>dd);">
            </div>
        </div>
        <p class="formrank-progress-hint">
            <?php
            if ( $learning['progress']['remaining'] > 0 ) {
                printf(
                    /* translators: 1: remaining count, 2: type (leads/conversions), 3: next mode name */
                    esc_html__( '%1$d more %2$s needed to unlock %3$s', 'formrank-lead-scoring' ),
                    esc_html( $learning['progress']['remaining'] ),
                    esc_html( $learning['progress']['type'] ),
                    esc_html( $learning['progress']['next_mode'] )
                );
            }
            ?>
        </p>
    </div>
    <?php endif; ?>

    <!-- CTA Message -->
    <div class="formrank-learning-cta">
        <span class="dashicons dashicons-lightbulb"></span>
        <p>
            <?php
            if ( $learning['mode'] === 'cold_start' ) {
                esc_html_e( 'Your scoring system needs data to learn. Mark conversions to help the AI understand which lead behaviors predict success.', 'formrank-lead-scoring' );
            } elseif ( $learning['mode'] === 'enhanced_rules' ) {
                esc_html_e( 'Pattern detection is active! The system is analyzing your high-scoring leads to identify common traits. Mark more conversions to unlock full Learning Mode.', 'formrank-lead-scoring' );
            } else {
                esc_html_e( 'Full learning active! Every conversion you mark helps fine-tune scoring weights. The more feedback you provide, the smarter your scoring becomes.', 'formrank-lead-scoring' );
            }
            ?>
        </p>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=formrank-lead-scoring&status=qualified' ) ); ?>" class="button button-primary">
            <?php esc_html_e( 'Mark Conversions', 'formrank-lead-scoring' ); ?>
        </a>
    </div>
</div>
