<?php
/**
 * Lead Intelligence (Enrichment) Card Partial
 *
 * Expected variables (set by the including template):
 *   $enrichment_data         array|null  Decoded enrichment payload from get_enrichment_data()
 *   $enrichment_availability array       From Enrichment_Engine::check_enrichment_availability()
 *   $is_pro                  bool        True when current user is on PRO/Agency plan
 *   $lead                    array       Full lead row from wp_formrank_leads
 *   $lead_detail             Lead_Detail Lead_Detail instance (used for timestamp helper)
 *
 * @package FormRankLS
 */

defined('ABSPATH') || exit;

// Free-tier: show locked card with upgrade CTA instead of enrichment data.
if ( ! $is_pro ) : ?>
<div id="formrank-enrichment-section" class="formrank-enrichment-inline" style="text-align:center;padding:24px 16px;border:2px dashed #c3c4c7;border-radius:4px;margin-top:16px;">
    <span class="dashicons dashicons-lock" style="font-size:36px;width:36px;height:36px;color:#9ca3af;margin-bottom:12px;display:block;margin-left:auto;margin-right:auto;"></span>
    <h3 style="margin:8px 0 12px;color:#1d2327;">
        <?php esc_html_e( 'Unlock Lead Intelligence', 'formrank-lead-scoring' ); ?>
    </h3>
    <p style="color:#50575e;max-width:400px;margin:0 auto 20px;">
        <?php esc_html_e( 'Get instant access to AI-powered lead enrichment — see job titles, company details, LinkedIn profiles, and more for every lead.', 'formrank-lead-scoring' ); ?>
    </p>
    <a href="<?php echo esc_url( \FormRankLS\Admin\Upgrade_Notice::get_upgrade_url() ); ?>" class="button button-primary" style="font-size:14px;padding:6px 24px;">
        <span class="dashicons dashicons-star-filled" style="margin-top:3px;margin-right:4px;"></span>
        <?php esc_html_e( 'Upgrade to PRO', 'formrank-lead-scoring' ); ?>
    </a>
</div>
<?php return; endif;

// Confidence badge configuration.
$confidence_config = [
    'high'      => ['label' => __('High Confidence', 'formrank-lead-scoring'),      'bg' => '#22c55e', 'color' => '#fff'],
    'medium'    => ['label' => __('Medium Confidence', 'formrank-lead-scoring'),    'bg' => '#eab308', 'color' => '#000'],
    'low'       => ['label' => __('Low Confidence', 'formrank-lead-scoring'),       'bg' => '#f97316', 'color' => '#fff'],
    'not_found' => ['label' => __('Not Found', 'formrank-lead-scoring'),            'bg' => '#9ca3af', 'color' => '#fff'],
];

$confidence      = $enrichment_data ? ($enrichment_data['confidence'] ?? 'not_found') : null;
$badge_cfg       = $confidence ? ($confidence_config[$confidence] ?? $confidence_config['not_found']) : null;
$lead_id         = absint($lead['id']);
$show_more_label = esc_html__('Show more', 'formrank-lead-scoring');
$show_less_label = esc_html__('Show less', 'formrank-lead-scoring');
?>

<div id="formrank-enrichment-section" class="formrank-enrichment-inline" style="margin-top:20px;padding-top:16px;border-top:1px solid #e0e0e0;">

    <!-- Card Header -->
    <div class="formrank-enrichment-header">
        <h3 style="display:inline-block;margin:0;">
            <?php esc_html_e('Lead Intelligence', 'formrank-lead-scoring'); ?>
            <?php if ($enrichment_data && $badge_cfg) : ?>
                <span class="formrank-confidence-badge" style="background:<?php echo esc_attr($badge_cfg['bg']); ?>;color:<?php echo esc_attr($badge_cfg['color']); ?>;padding:2px 10px;border-radius:12px;font-size:12px;font-weight:500;margin-left:8px;vertical-align:middle;">
                    <?php echo esc_html($badge_cfg['label']); ?>
                </span>
            <?php endif; ?>
        </h3>

        <?php if ($enrichment_data && !empty($enrichment_data['row']['enriched_at'])) : ?>
            <p class="formrank-enrichment-timestamp" style="color:#6b7280;font-size:13px;margin-top:4px;">
                <?php echo esc_html($lead_detail->get_enrichment_timestamp($enrichment_data['row']['enriched_at'])); ?>
            </p>
        <?php endif; ?>
    </div>

    <!-- Usage Counter (server-side populated, updated by JS after AJAX enrichment) -->
    <?php
    $enrich_stats = get_transient('formrank_enrich_stats');
    $enrich_usage = $enrich_stats ? absint($enrich_stats['usage']) : 0;
    $enrich_limit = $enrich_stats ? absint($enrich_stats['limit']) : 0;
    ?>
    <div id="formrank-enrich-usage" class="formrank-enrich-usage" style="margin:8px 0;padding:8px 12px;background:#f0f0f1;border-radius:4px;font-size:13px;color:#50575e;display:inline-block;">
        <span class="dashicons dashicons-search" style="font-size:16px;width:16px;height:16px;vertical-align:text-bottom;margin-right:4px;"></span>
        <?php if ($enrich_limit > 0) : ?>
            <?php printf(
                esc_html__('%1$d of %2$d enrichments used this month', 'formrank-lead-scoring'),
                $enrich_usage,
                $enrich_limit
            ); ?>
        <?php else : ?>
            <?php esc_html_e('Enrichment usage will appear after your first enrichment', 'formrank-lead-scoring'); ?>
        <?php endif; ?>
    </div>

    <?php if ($enrichment_data) : ?>

        <?php
        $person  = $enrichment_data['person']  ?? [];
        $company = $enrichment_data['company'] ?? [];

        // ----------------------------------------------------------------
        // Person section
        // ----------------------------------------------------------------

        // Build person rows: [field_key => [label, value, is_url]]
        $other_profiles = $person['other_profiles'] ?? null;
        if (is_array($other_profiles)) {
            $other_profiles = implode(', ', $other_profiles);
        }

        $person_fields = [
            'full_name'    => [__('Name',     'formrank-lead-scoring'), $person['full_name']    ?? null, false],
            'job_title'    => [__('Title',    'formrank-lead-scoring'), $person['job_title']    ?? null, false],
            'company'      => [__('Company',  'formrank-lead-scoring'), $person['company']      ?? null, false],
            'seniority_level' => [__('Seniority', 'formrank-lead-scoring'), $person['seniority_level'] ?? null, false],
            'linkedin_url' => [__('LinkedIn', 'formrank-lead-scoring'), $person['linkedin_url'] ?? null, true],
            'twitter_url'  => [__('Twitter',  'formrank-lead-scoring'), $person['twitter_url']  ?? null, true],
            'github_url'   => [__('GitHub',   'formrank-lead-scoring'), $person['github_url']   ?? null, true],
            'personal_site'=> [__('Website',  'formrank-lead-scoring'), $person['personal_site'] ?? null, true],
            'other_profiles'=> [__('Other',   'formrank-lead-scoring'), $other_profiles,                false],
        ];

        // Filter to non-empty fields only.
        $person_rows = array_filter($person_fields, function ($row) {
            $value = $row[1];
            return $value !== null && $value !== '' && $value !== [];
        });
        ?>

        <h3><?php esc_html_e('Person', 'formrank-lead-scoring'); ?></h3>

        <?php if (!empty($person_rows)) : ?>
            <table class="formrank-info-table formrank-enrichment-fields">
                <?php foreach ($person_rows as $key => $field) :
                    list($label, $value, $is_url) = $field;
                    ?>
                    <tr>
                        <th><?php echo esc_html($label); ?></th>
                        <td>
                            <span class="formrank-enrichment-field-value" data-copy-value="<?php echo esc_attr($value); ?>">
                                <?php if ($is_url) : ?>
                                    <a href="<?php echo esc_url($value); ?>" target="_blank" rel="noopener"><?php echo esc_html($value); ?></a>
                                <?php else : ?>
                                    <?php echo esc_html($value); ?>
                                <?php endif; ?>
                                <span class="formrank-copy-btn dashicons dashicons-clipboard" title="<?php esc_attr_e('Copy', 'formrank-lead-scoring'); ?>"></span>
                            </span>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
        <?php else : ?>
            <p class="formrank-section-empty" style="color:#6b7280;font-style:italic;">
                <?php esc_html_e('No person data found', 'formrank-lead-scoring'); ?>
            </p>
        <?php endif; ?>

        <?php
        // ----------------------------------------------------------------
        // Company section
        // ----------------------------------------------------------------

        $company_fields = [
            'name'     => [__('Name',     'formrank-lead-scoring'), $company['name']     ?? null, false],
            'industry' => [__('Industry', 'formrank-lead-scoring'), $company['industry'] ?? null, false],
            'size'     => [__('Size',     'formrank-lead-scoring'), $company['size']     ?? null, false],
            'website'  => [__('Website',  'formrank-lead-scoring'), $company['website']  ?? null, true],
            'location' => [__('Location', 'formrank-lead-scoring'), $company['location'] ?? null, false],
        ];

        // Description is handled separately (needs show-more toggle).
        $company_description = $company['description'] ?? null;

        // Filter to non-empty fields only.
        $company_rows = array_filter($company_fields, function ($row) {
            $value = $row[1];
            return $value !== null && $value !== '' && $value !== [];
        });

        $has_company_data = !empty($company_rows) || !empty($company_description);
        ?>

        <h3><?php esc_html_e('Company', 'formrank-lead-scoring'); ?></h3>

        <?php if ($has_company_data) : ?>
            <table class="formrank-info-table formrank-enrichment-fields">
                <?php foreach ($company_rows as $key => $field) :
                    list($label, $value, $is_url) = $field;
                    ?>
                    <tr>
                        <th><?php echo esc_html($label); ?></th>
                        <td>
                            <span class="formrank-enrichment-field-value" data-copy-value="<?php echo esc_attr($value); ?>">
                                <?php if ($is_url) : ?>
                                    <a href="<?php echo esc_url($value); ?>" target="_blank" rel="noopener"><?php echo esc_html($value); ?></a>
                                <?php else : ?>
                                    <?php echo esc_html($value); ?>
                                <?php endif; ?>
                                <span class="formrank-copy-btn dashicons dashicons-clipboard" title="<?php esc_attr_e('Copy', 'formrank-lead-scoring'); ?>"></span>
                            </span>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (!empty($company_description)) : ?>
                    <tr>
                        <th><?php esc_html_e('Description', 'formrank-lead-scoring'); ?></th>
                        <td>
                            <div class="formrank-company-description">
                                <p><?php echo esc_html($company_description); ?></p>
                            </div>
                            <button type="button" class="formrank-show-more-btn button-link" style="display:none;">
                                <?php echo esc_html($show_more_label); ?>
                            </button>
                        </td>
                    </tr>
                <?php endif; ?>
            </table>
        <?php else : ?>
            <p class="formrank-section-empty" style="color:#6b7280;font-style:italic;">
                <?php esc_html_e('No company data found', 'formrank-lead-scoring'); ?>
            </p>
        <?php endif; ?>

    <?php endif; // enrichment_data ?>

    <!-- Enrich / Re-enrich Button Area -->
    <div class="formrank-enrich-actions" style="margin-top:16px;">
        <?php if ($enrichment_data) : ?>
            <!-- Re-enrich button (enrichment already exists) -->
            <button type="button" class="button button-small formrank-enrich-btn" data-id="<?php echo esc_attr($lead_id); ?>">
                <?php esc_html_e('Re-enrich', 'formrank-lead-scoring'); ?>
            </button>
        <?php elseif ($enrichment_availability['available']) : ?>
            <!-- Primary Enrich button -->
            <button type="button" class="button button-primary formrank-enrich-btn" data-id="<?php echo esc_attr($lead_id); ?>">
                <span class="dashicons dashicons-search" style="margin-top:3px;"></span>
                <?php esc_html_e('Enrich', 'formrank-lead-scoring'); ?>
            </button>
        <?php elseif (!empty($enrichment_availability['reason']) && strpos($enrichment_availability['reason'], 'name and email') !== false) : ?>
            <!-- Disabled — missing required lead data -->
            <button type="button" class="button button-primary" disabled title="<?php echo esc_attr($enrichment_availability['reason']); ?>">
                <?php esc_html_e('Enrich', 'formrank-lead-scoring'); ?>
            </button>
        <?php elseif (!empty($enrichment_availability['reason']) && strpos($enrichment_availability['reason'], '30 seconds') !== false) : ?>
            <!-- Disabled — cooldown active -->
            <button type="button" class="button" disabled>
                <?php esc_html_e('Please wait before re-enriching', 'formrank-lead-scoring'); ?>
            </button>
        <?php else : ?>
            <!-- Disabled — generic unavailable state -->
            <button type="button" class="button button-primary" disabled title="<?php echo esc_attr($enrichment_availability['reason'] ?? ''); ?>">
                <?php esc_html_e('Enrich', 'formrank-lead-scoring'); ?>
            </button>
        <?php endif; ?>
    </div>

    <p class="formrank-enrichment-disclaimer" style="color:#9ca3af;font-size:11px;margin-top:12px;margin-bottom:0;font-style:italic;">
        <?php esc_html_e('Data sourced from public profiles. Verify before acting.', 'formrank-lead-scoring'); ?>
    </p>

</div><!-- #formrank-enrichment-section -->
