<?php
/**
 * Conversion by Segment Chart Partial
 *
 * @package FormRankLS
 */

defined( 'ABSPATH' ) || exit;

$segment_labels = [
    'hot'     => __( 'Hot', 'formrank-lead-scoring' ),
    'warm'    => __( 'Warm', 'formrank-lead-scoring' ),
    'neutral' => __( 'Neutral', 'formrank-lead-scoring' ),
    'cool'    => __( 'Cool', 'formrank-lead-scoring' ),
    'cold'    => __( 'Cold', 'formrank-lead-scoring' ),
];
?>

<div class="formrank-segment-chart">
    <?php foreach ( $segments as $key => $segment ) : ?>
    <div class="formrank-dist-row">
        <div class="formrank-dist-label">
            <span class="formrank-segment-name"><?php echo esc_html( $segment_labels[ $key ] ); ?></span>
            <span class="formrank-segment-range">(<?php echo esc_html( $segment['range'] ); ?>)</span>
        </div>
        <div class="formrank-dist-bar-container">
            <div class="formrank-dist-bar"
                 style="width: <?php echo esc_attr( $segment['rate'] ); ?>%;
                        background-color: <?php echo esc_attr( $segment['color'] ); ?>;">
            </div>
        </div>
        <div class="formrank-dist-stats">
            <span class="formrank-dist-rate"><?php echo esc_html( $segment['rate'] ); ?>%</span>
            <span class="formrank-dist-count">
                (<?php echo esc_html( $segment['converted'] ); ?>/<?php echo esc_html( $segment['total'] ); ?>)
            </span>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?php if ( $has_anomaly ) : ?>
<div class="formrank-segment-warning">
    <span class="dashicons dashicons-warning"></span>
    <?php esc_html_e( 'Scoring anomaly detected: Lower segments have higher conversion rates. Consider adjusting your scoring rules.', 'formrank-lead-scoring' ); ?>
</div>
<?php endif; ?>

<p class="formrank-chart-hint">
    <?php esc_html_e( 'A healthy scoring system shows higher conversion rates for higher-scored leads.', 'formrank-lead-scoring' ); ?>
</p>
