<?php
/**
 * Conversion Funnel Visualization Partial
 *
 * @package FormRankLS
 */

defined( 'ABSPATH' ) || exit;

$stages = [
    'new'       => [
        'label' => __( 'New Leads', 'formrank-lead-scoring' ),
        'icon'  => 'admin-users',
        'color' => '#93c5fd',
    ],
    'contacted' => [
        'label' => __( 'Contacted', 'formrank-lead-scoring' ),
        'icon'  => 'email',
        'color' => '#a5b4fc',
    ],
    'qualified' => [
        'label' => __( 'Qualified', 'formrank-lead-scoring' ),
        'icon'  => 'star-filled',
        'color' => '#fcd34d',
    ],
    'converted' => [
        'label' => __( 'Converted', 'formrank-lead-scoring' ),
        'icon'  => 'yes-alt',
        'color' => '#6ee7b7',
    ],
];

$max_count = max( array_column( $funnel, 'count' ) );
?>

<div class="formrank-funnel">
    <?php
    $prev_count = null;
    foreach ( $stages as $key => $stage ) :
        $data   = $funnel[ $key ];
        $width  = $max_count > 0 ? ( $data['count'] / $max_count ) * 100 : 0;
        $dropoff = ( $prev_count !== null && $prev_count > 0 )
            ? round( ( ( $prev_count - $data['count'] ) / $prev_count ) * 100 )
            : null;
    ?>

    <?php if ( $dropoff !== null && $dropoff > 0 ) : ?>
    <div class="formrank-funnel-dropoff">
        <span class="formrank-dropoff-arrow">&darr;</span>
        <span class="formrank-dropoff-value"><?php echo esc_html( $dropoff ); ?>% <?php esc_html_e( 'drop', 'formrank-lead-scoring' ); ?></span>
    </div>
    <?php endif; ?>

    <div class="formrank-funnel-stage">
        <div class="formrank-funnel-label">
            <span class="dashicons dashicons-<?php echo esc_attr( $stage['icon'] ); ?>"></span>
            <?php echo esc_html( $stage['label'] ); ?>
        </div>
        <div class="formrank-funnel-bar-container">
            <div class="formrank-funnel-bar formrank-funnel-<?php echo esc_attr( $key ); ?>"
                 style="width: <?php echo esc_attr( $width ); ?>%;">
            </div>
        </div>
        <div class="formrank-funnel-stats">
            <span class="formrank-funnel-count"><?php echo esc_html( number_format( $data['count'] ) ); ?></span>
            <span class="formrank-funnel-percent">(<?php echo esc_html( $data['percent'] ); ?>%)</span>
        </div>
    </div>

    <?php
        $prev_count = $data['count'];
    endforeach;
    ?>
</div>

<?php if ( $funnel['new']['count'] > 0 && $funnel['converted']['count'] === 0 ) : ?>
<p class="formrank-funnel-hint">
    <?php esc_html_e( 'No conversions yet. Mark leads as converted to see your full funnel.', 'formrank-lead-scoring' ); ?>
</p>
<?php endif; ?>
