<?php
/**
 * Lead List Template
 *
 * @package FormRankLS
 */

if (!defined('ABSPATH')) {
    exit;
}

use FormRankLS\Admin\Upgrade_Notice;
?>
<div class="wrap formrank-wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('All Leads', 'formrank-lead-scoring'); ?></h1>

    <?php
    // Build export URL with current filters
    $export_url = admin_url('admin.php?page=formrank-lead-scoring&action=export_csv');
    $export_url = wp_nonce_url($export_url, 'formrank_export_csv');

    // Build JSON export URL with current filters
    $export_json_url = admin_url('admin.php?page=formrank-lead-scoring&action=export_json');
    $export_json_url = wp_nonce_url($export_json_url, 'formrank_export_json');

    // Preserve current filters in export URLs
    if (!empty($_GET['label'])) {
        $export_url      = add_query_arg('label', sanitize_text_field(wp_unslash($_GET['label'])), $export_url);
        $export_json_url = add_query_arg('label', sanitize_text_field(wp_unslash($_GET['label'])), $export_json_url);
    }
    if (!empty($_GET['status'])) {
        $export_url      = add_query_arg('status', sanitize_text_field(wp_unslash($_GET['status'])), $export_url);
        $export_json_url = add_query_arg('status', sanitize_text_field(wp_unslash($_GET['status'])), $export_json_url);
    }
    if (!empty($_GET['s'])) {
        $export_url      = add_query_arg('s', sanitize_text_field(wp_unslash($_GET['s'])), $export_url);
        $export_json_url = add_query_arg('s', sanitize_text_field(wp_unslash($_GET['s'])), $export_json_url);
    }
    ?>
    <a href="<?php echo esc_url($export_url); ?>" class="page-title-action">
        <span class="dashicons dashicons-download" style="vertical-align: middle; margin-right: 3px;"></span>
        <?php esc_html_e('Export CSV', 'formrank-lead-scoring'); ?>
    </a>
    <a href="<?php echo esc_url($export_json_url); ?>" class="page-title-action">
        <span class="dashicons dashicons-download" style="vertical-align: middle; margin-right: 3px;"></span>
        <?php esc_html_e('Export JSON', 'formrank-lead-scoring'); ?>
    </a>

    <hr class="wp-header-end">

    <?php Upgrade_Notice::render_top_banner('leads'); ?>

    <?php
    // Enrichment usage counter (visible on list view for PRO users per locked decision)
    $is_pro_user = !\FormRankLS\Admin\Upgrade_Notice::is_free_user();
    if ($is_pro_user) :
        // Read cached enrichment stats from transient (set by successful enrich calls in plan 03-03)
        $enrich_stats = get_transient('formrank_enrich_stats');
        $enrich_usage = $enrich_stats ? absint($enrich_stats['usage']) : 0;
        $enrich_limit = $enrich_stats ? absint($enrich_stats['limit']) : 0;
    ?>
        <div id="formrank-enrich-usage" class="formrank-enrich-usage" style="margin: 8px 0; padding: 8px 12px; background: #f0f0f1; border-radius: 4px; font-size: 13px; color: #50575e; display: inline-block;">
            <span class="dashicons dashicons-search" style="font-size: 16px; width: 16px; height: 16px; vertical-align: text-bottom; margin-right: 4px;"></span>
            <?php if ($enrich_limit > 0) : ?>
                <?php
                printf(
                    /* translators: 1: usage count, 2: limit */
                    esc_html__('%1$d of %2$d enrichments used this month', 'formrank-lead-scoring'),
                    $enrich_usage,
                    $enrich_limit
                );
                ?>
            <?php else : ?>
                <?php esc_html_e('Enrichment usage will appear after your first enrichment', 'formrank-lead-scoring'); ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php
    // Display any notices
    if (isset($_GET['archived']) && '1' === sanitize_text_field(wp_unslash($_GET['archived']))) {
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Lead archived successfully.', 'formrank-lead-scoring') . '</p></div>';
    }

    // Bulk action notices
    if (isset($_GET['bulk_archived'])) {
        $count = absint(wp_unslash($_GET['bulk_archived']));
        printf(
            '<div class="notice notice-success is-dismissible"><p>%s</p></div>',
            sprintf(
                /* translators: %d: number of leads archived */
                esc_html(_n('%d lead archived.', '%d leads archived.', $count, 'formrank-lead-scoring')),
                absint($count)
            )
        );
    }

    if (isset($_GET['bulk_deleted'])) {
        $count = absint(wp_unslash($_GET['bulk_deleted']));
        printf(
            '<div class="notice notice-success is-dismissible"><p>%s</p></div>',
            sprintf(
                /* translators: %d: number of leads deleted */
                esc_html(_n('%d lead permanently deleted.', '%d leads permanently deleted.', $count, 'formrank-lead-scoring')),
                absint($count)
            )
        );
    }

    if (isset($_GET['bulk_rescored'])) {
        $count = absint(wp_unslash($_GET['bulk_rescored']));
        printf(
            '<div class="notice notice-success is-dismissible"><p>%s</p></div>',
            sprintf(
                /* translators: %d: number of leads rescored */
                esc_html(_n('%d lead rescored.', '%d leads rescored.', $count, 'formrank-lead-scoring')),
                absint($count)
            )
        );
    }

    if (isset($_GET['bulk_converted'])) {
        $count = absint(wp_unslash($_GET['bulk_converted']));
        printf(
            '<div class="notice notice-success is-dismissible"><p>%s</p></div>',
            sprintf(
                /* translators: %d: number of leads marked as converted */
                esc_html(_n('%d lead marked as converted.', '%d leads marked as converted.', $count, 'formrank-lead-scoring')),
                absint($count)
            )
        );
    }

    if (isset($_GET['bulk_ai_rescored'])) {
        $count = absint(wp_unslash($_GET['bulk_ai_rescored']));
        $skipped = isset($_GET['bulk_ai_skipped']) ? absint(wp_unslash($_GET['bulk_ai_skipped'])) : 0;
        printf(
            '<div class="notice notice-success is-dismissible"><p>%s</p></div>',
            sprintf(
                /* translators: %d: number of leads scored with AI */
                esc_html(_n('%d lead scored with AI.', '%d leads scored with AI.', $count, 'formrank-lead-scoring')),
                absint($count)
            )
        );
        if ($skipped > 0) {
            printf(
                '<div class="notice notice-warning is-dismissible"><p>%s</p></div>',
                sprintf(
                    /* translators: %d: number of leads skipped */
                    esc_html(_n('%d lead skipped (AI quota exceeded or error).', '%d leads skipped (AI quota exceeded or error).', $skipped, 'formrank-lead-scoring')),
                    absint($skipped)
                )
            );
        }
    }
    ?>

    <?php $lead_list->views(); ?>

    <!-- Search form uses GET so results can be bookmarked and paginated -->
    <form method="get" id="formrank-search-form">
        <input type="hidden" name="page" value="formrank-lead-scoring">
        <?php
        // Preserve current filters when searching
        if (!empty($_GET['label'])) {
            echo '<input type="hidden" name="label" value="' . esc_attr(sanitize_text_field(wp_unslash($_GET['label']))) . '">';
        }
        if (!empty($_GET['status'])) {
            echo '<input type="hidden" name="status" value="' . esc_attr(sanitize_text_field(wp_unslash($_GET['status']))) . '">';
        }
        if (!empty($_GET['orderby'])) {
            echo '<input type="hidden" name="orderby" value="' . esc_attr(sanitize_text_field(wp_unslash($_GET['orderby']))) . '">';
        }
        if (!empty($_GET['order'])) {
            echo '<input type="hidden" name="order" value="' . esc_attr(sanitize_text_field(wp_unslash($_GET['order']))) . '">';
        }

        $lead_list->search_box(__('Search Leads', 'formrank-lead-scoring'), 'formrank-search');
        ?>
    </form>

    <?php
    // Show active search indicator
    $current_search = isset($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';
    if (!empty($current_search)) :
        // Build clear URL preserving other filters
        $clear_url = admin_url('admin.php?page=formrank-lead-scoring');
        if (!empty($_GET['label'])) {
            $clear_url = add_query_arg('label', sanitize_text_field(wp_unslash($_GET['label'])), $clear_url);
        }
        if (!empty($_GET['status'])) {
            $clear_url = add_query_arg('status', sanitize_text_field(wp_unslash($_GET['status'])), $clear_url);
        }
    ?>
    <div class="formrank-search-indicator">
        <span class="dashicons dashicons-search"></span>
        <?php
        printf(
            /* translators: %s: search term */
            esc_html__('Showing results for: "%s"', 'formrank-lead-scoring'),
            esc_html($current_search)
        );
        ?>
        <a href="<?php echo esc_url($clear_url); ?>" class="formrank-clear-search">
            <span class="dashicons dashicons-no-alt"></span>
            <?php esc_html_e('Clear', 'formrank-lead-scoring'); ?>
        </a>
    </div>
    <?php endif; ?>

    <!-- Bulk actions form uses POST for security -->
    <form method="post" id="formrank-leads-form">
        <?php
        $lead_list->display();
        ?>
    </form>
    <p style="text-align: center; color: #9ca3af; font-size: 12px; margin-top: 24px;">
        <?php
        printf(
            /* translators: %s: FormRank Lead Scoring link */
            esc_html__('Powered by %s', 'formrank-lead-scoring'),
            '<a href="https://formrankwp.com" style="color: #9ca3af; text-decoration: underline;">FormRank</a>'
        );
        ?>
    </p>
</div>
