<?php
/**
 * Lead Detail Template
 *
 * @package FormRankLS
 */

if (!defined('ABSPATH')) {
    exit;
}

$form_data = $lead_detail->get_form_data();
$score_factors = $lead_detail->get_score_factors();
$score_color = $lead_detail->get_score_color();
$score_icon = $lead_detail->get_score_icon();
$tags = $lead_detail->get_tags_array();
$scoring_method = $lead['scoring_method'] ?? 'local';
$is_ai_scored = ($scoring_method === 'ai');

// Get AI stats for display
$scoring_engine = new \FormRankLS\Core\Scoring_Engine();
$ai_stats = $scoring_engine->get_ai_stats();
$ai_availability = $scoring_engine->check_ai_availability();
?>
<div class="wrap formrank-wrap">
    <h1>
        <a href="<?php echo esc_url(admin_url('admin.php?page=formrank-lead-scoring')); ?>" class="page-title-action" style="margin-right: 10px;">
            &larr; <?php esc_html_e('Back to Leads', 'formrank-lead-scoring'); ?>
        </a>
        <?php echo esc_html($lead['name'] ?: __('Lead Details', 'formrank-lead-scoring')); ?>
    </h1>

    <div class="formrank-detail-grid">
        <!-- Score Card -->
        <div class="formrank-card formrank-score-card">
            <div class="formrank-big-score" style="color: <?php echo esc_attr($score_color); ?>;">
                <span class="formrank-score-icon"><?php echo wp_kses_post($score_icon); ?></span>
                <span class="formrank-score-value"><?php echo esc_html($lead['score'] ?? '-'); ?></span>
            </div>
            <div class="formrank-score-label" style="color: <?php echo esc_attr($score_color); ?>;">
                <?php echo esc_html(ucfirst($lead['score_label'] ?? 'Unknown')); ?>
            </div>

            <!-- Scoring Method Badge -->
            <div class="formrank-scoring-method">
                <?php if ($is_ai_scored) : ?>
                    <span class="formrank-method-badge formrank-method-ai" title="<?php esc_attr_e('Scored using Claude AI', 'formrank-lead-scoring'); ?>">
                        <span class="dashicons dashicons-cloud"></span>
                        <?php esc_html_e('AI Scored', 'formrank-lead-scoring'); ?>
                    </span>
                <?php else : ?>
                    <span class="formrank-method-badge formrank-method-local" title="<?php esc_attr_e('Scored using rule-based engine', 'formrank-lead-scoring'); ?>">
                        <span class="dashicons dashicons-laptop"></span>
                        <?php esc_html_e('Rule-based', 'formrank-lead-scoring'); ?>
                    </span>
                <?php endif; ?>
            </div>

            <?php if (!empty($lead['score_reasoning'])) : ?>
                <div class="formrank-reasoning">
                    <h4><?php echo $is_ai_scored ? esc_html__('AI Assessment', 'formrank-lead-scoring') : esc_html__('Assessment', 'formrank-lead-scoring'); ?></h4>
                    <p><?php echo esc_html($lead['score_reasoning']); ?></p>
                </div>
            <?php endif; ?>

            <?php if (!empty($score_factors)) : ?>
                <div class="formrank-factors">
                    <h4><?php esc_html_e('Score Breakdown', 'formrank-lead-scoring'); ?></h4>
                    <?php
                    $factor_labels = [
                        'intent' => ['name' => __('Intent', 'formrank-lead-scoring'), 'max' => 40],
                        'fit' => ['name' => __('Fit', 'formrank-lead-scoring'), 'max' => 30],
                        'quality' => ['name' => __('Quality', 'formrank-lead-scoring'), 'max' => 20],
                        'engagement' => ['name' => __('Engagement', 'formrank-lead-scoring'), 'max' => 10]
                    ];

                    foreach ($factor_labels as $key => $label) :
                        $factor = $score_factors[$key] ?? null;
                        if (!$factor) continue;
                        $score = $factor['score'] ?? 0;
                        $max = $factor['max'] ?? $label['max'];
                        $pct = $max > 0 ? ($score / $max) * 100 : 0;
                    ?>
                        <div class="formrank-factor-row">
                            <div class="formrank-factor-header">
                                <span class="formrank-factor-name"><?php echo esc_html($label['name']); ?></span>
                                <span class="formrank-factor-score"><?php echo esc_html($score); ?>/<?php echo esc_html($max); ?></span>
                            </div>
                            <div class="formrank-factor-bar">
                                <div class="formrank-factor-fill" style="width: <?php echo esc_attr($pct); ?>%;"></div>
                            </div>
                            <?php if (!empty($factor['notes'])) : ?>
                                <div class="formrank-factor-notes"><?php echo esc_html($factor['notes']); ?></div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <!-- AI Rescore Section -->
            <div class="formrank-ai-rescore-section">
                <h4>
                    <span class="dashicons dashicons-cloud"></span>
                    <?php esc_html_e('AI Scoring', 'formrank-lead-scoring'); ?>
                </h4>

                <!-- AI Usage Stats -->
                <div class="formrank-ai-usage">
                    <?php if ($ai_stats['is_pro']) : ?>
                        <span class="formrank-ai-pro-badge">
                            <span class="dashicons dashicons-star-filled"></span>
                            <?php esc_html_e('Pro - Unlimited', 'formrank-lead-scoring'); ?>
                        </span>
                    <?php else : ?>
                        <div class="formrank-ai-usage-bar">
                            <div class="formrank-ai-usage-fill" style="width: <?php echo esc_attr($ai_stats['percentage']); ?>%;"></div>
                        </div>
                        <span class="formrank-ai-usage-text">
                            <?php
                            printf(
                                /* translators: 1: usage count, 2: limit */
                                esc_html__('%1$d / %2$d AI rescores used this month', 'formrank-lead-scoring'),
                                absint($ai_stats['usage']),
                                absint($ai_stats['limit'])
                            );
                            ?>
                        </span>
                    <?php endif; ?>
                </div>

                <div class="formrank-actions">
                    <?php if ($ai_availability['available']) : ?>
                        <button type="button" class="button button-primary formrank-ai-rescore" data-id="<?php echo esc_attr($lead['id']); ?>">
                            <span class="dashicons dashicons-cloud" style="margin-top: 3px;"></span>
                            <?php
                            if ($is_ai_scored) {
                                esc_html_e('Re-score with AI', 'formrank-lead-scoring');
                            } else {
                                esc_html_e('Score with AI', 'formrank-lead-scoring');
                            }
                            ?>
                        </button>
                        <?php if (!$ai_stats['is_pro'] && $ai_stats['remaining'] <= 3) : ?>
                            <p class="formrank-ai-warning">
                                <?php
                                printf(
                                    /* translators: %d: remaining AI rescores */
                                    esc_html__('Only %d AI rescores remaining this month.', 'formrank-lead-scoring'),
                                    absint($ai_stats['remaining'])
                                );
                                ?>
                            </p>
                        <?php endif; ?>
                    <?php else : ?>
                        <button type="button" class="button" disabled>
                            <span class="dashicons dashicons-lock"></span>
                            <?php esc_html_e('AI Limit Reached', 'formrank-lead-scoring'); ?>
                        </button>
                        <p class="formrank-ai-limit-reached">
                            <?php esc_html_e('Upgrade to Pro for unlimited AI scoring.', 'formrank-lead-scoring'); ?>
                            <a href="<?php echo esc_url(\FormRankLS\Admin\Upgrade_Notice::get_upgrade_url()); ?>" class="button button-small">
                                <?php esc_html_e('Upgrade', 'formrank-lead-scoring'); ?>
                            </a>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php
        // Lead Intelligence (Enrichment) — data prepared here, rendered inside Contact Information card.
        $enrichment_engine = new \FormRankLS\Core\Enrichment_Engine();
        $enrichment_data = null;
        $enrichment_row = $enrichment_engine->get_enrichment_by_lead(absint($lead['id']));
        if ($enrichment_row && !empty($enrichment_row['enrichment_data'])) {
            $decoded = json_decode($enrichment_row['enrichment_data'], true);
            $enrichment_data = [
                'row'        => $enrichment_row,
                'person'     => $decoded['person']     ?? [],
                'company'    => $decoded['company']    ?? [],
                'confidence' => $decoded['confidence'] ?? 'not_found',
                'email_type' => $decoded['email_type'] ?? 'personal',
            ];
        }
        $enrichment_availability = $enrichment_engine->check_enrichment_availability(absint($lead['id']));
        $is_pro = !\FormRankLS\Admin\Upgrade_Notice::is_free_user();
        ?>

        <!-- Lead Info -->
        <div class="formrank-card">
            <h2><?php esc_html_e('Contact Information', 'formrank-lead-scoring'); ?></h2>

            <table class="formrank-info-table">
                <tr>
                    <th><?php esc_html_e('Name', 'formrank-lead-scoring'); ?></th>
                    <td><?php echo esc_html($lead['name'] ?: '-'); ?></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Email', 'formrank-lead-scoring'); ?></th>
                    <td>
                        <?php if ($lead['email']) : ?>
                            <a href="mailto:<?php echo esc_attr($lead['email']); ?>"><?php echo esc_html($lead['email']); ?></a>
                        <?php else : ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Company', 'formrank-lead-scoring'); ?></th>
                    <td><?php echo esc_html($lead['company'] ?: '-'); ?></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Phone', 'formrank-lead-scoring'); ?></th>
                    <td>
                        <?php if ($lead['phone']) : ?>
                            <a href="tel:<?php echo esc_attr($lead['phone']); ?>"><?php echo esc_html($lead['phone']); ?></a>
                        <?php else : ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
            </table>

            <h3><?php esc_html_e('Status', 'formrank-lead-scoring'); ?></h3>
            <select id="formrank-status" class="formrank-status-select" data-id="<?php echo esc_attr($lead['id']); ?>">
                <option value="new" <?php selected($lead['status'], 'new'); ?>><?php esc_html_e('New', 'formrank-lead-scoring'); ?></option>
                <option value="contacted" <?php selected($lead['status'], 'contacted'); ?>><?php esc_html_e('Contacted', 'formrank-lead-scoring'); ?></option>
                <option value="qualified" <?php selected($lead['status'], 'qualified'); ?>><?php esc_html_e('Qualified', 'formrank-lead-scoring'); ?></option>
                <option value="converted" <?php selected($lead['status'], 'converted'); ?>><?php esc_html_e('Converted ✓', 'formrank-lead-scoring'); ?></option>
                <option value="archived" <?php selected($lead['status'], 'archived'); ?>><?php esc_html_e('Archived', 'formrank-lead-scoring'); ?></option>
            </select>

            <?php // Lead Intelligence (Enrichment) — rendered inline within Contact Information card. ?>
            <?php include FORMRANK_LS_PATH . 'templates/admin/partials/enrichment-card.php'; ?>

            <?php if ($lead['status'] !== 'converted') : ?>
                <!-- Conversion Tracking -->
                <div class="formrank-conversion-section" style="margin-top: 15px; padding: 12px; background: #f0fdf4; border: 1px solid #bbf7d0; border-radius: 4px;">
                    <p style="margin: 0 0 10px 0; font-size: 13px; color: #166534;">
                        <strong><?php esc_html_e('Did this lead convert?', 'formrank-lead-scoring'); ?></strong><br>
                        <?php esc_html_e('Mark leads as converted to help improve AI scoring accuracy.', 'formrank-lead-scoring'); ?>
                    </p>
                    <button type="button" class="button button-primary formrank-mark-converted" data-id="<?php echo esc_attr($lead['id']); ?>" style="background: #059669; border-color: #047857;">
                        <span class="dashicons dashicons-yes-alt" style="margin-top: 3px;"></span>
                        <?php esc_html_e('Mark as Converted', 'formrank-lead-scoring'); ?>
                    </button>
                </div>
            <?php else : ?>
                <!-- Already converted badge -->
                <div class="formrank-converted-badge" style="margin-top: 15px; padding: 12px; background: #ecfdf5; border: 1px solid #a7f3d0; border-radius: 4px; text-align: center;">
                    <span style="color: #059669; font-weight: 600; font-size: 14px;">
                        <span class="dashicons dashicons-yes-alt" style="color: #059669;"></span>
                        <?php esc_html_e('This lead has been converted!', 'formrank-lead-scoring'); ?>
                    </span>
                </div>
            <?php endif; ?>

            <h3><?php esc_html_e('Tags', 'formrank-lead-scoring'); ?></h3>
            <div class="formrank-tags">
                <?php foreach ($tags as $tag) : ?>
                    <span class="formrank-tag"><?php echo esc_html($tag); ?></span>
                <?php endforeach; ?>
                <?php if (empty($tags)) : ?>
                    <span class="formrank-no-tags"><?php esc_html_e('No tags', 'formrank-lead-scoring'); ?></span>
                <?php endif; ?>
            </div>

            <h3><?php esc_html_e('Metadata', 'formrank-lead-scoring'); ?></h3>
            <table class="formrank-info-table">
                <tr>
                    <th><?php esc_html_e('Source', 'formrank-lead-scoring'); ?></th>
                    <td>
                        <?php if ($lead['source_url']) : ?>
                            <a href="<?php echo esc_url($lead['source_url']); ?>" target="_blank">
                                <?php echo esc_html(wp_parse_url($lead['source_url'], PHP_URL_PATH) ?: $lead['source_url']); ?>
                            </a>
                        <?php else : ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Form', 'formrank-lead-scoring'); ?></th>
                    <td><?php echo esc_html(ucfirst($lead['form_plugin']) . ' #' . $lead['form_id']); ?></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Submitted', 'formrank-lead-scoring'); ?></th>
                    <td>
                        <?php
                        echo esc_html(wp_date(
                            get_option('date_format') . ' ' . get_option('time_format'),
                            strtotime($lead['created_at'])
                        ));
                        ?>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Scored', 'formrank-lead-scoring'); ?></th>
                    <td>
                        <?php
                        if ($lead['scored_at']) {
                            echo esc_html(wp_date(
                                get_option('date_format') . ' ' . get_option('time_format'),
                                strtotime($lead['scored_at'])
                            ));
                        } else {
                            esc_html_e('Not scored', 'formrank-lead-scoring');
                        }
                        ?>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Form Data -->
        <div class="formrank-card formrank-form-data">
            <h2><?php esc_html_e('Form Submission', 'formrank-lead-scoring'); ?></h2>

            <?php if (!empty($form_data)) : ?>
                <table class="formrank-info-table">
                    <?php foreach ($form_data as $field_name => $field_value) : ?>
                        <tr>
                            <th><?php echo esc_html($field_name); ?></th>
                            <td>
                                <?php
                                if (is_array($field_value)) {
                                    echo esc_html(implode(', ', $field_value));
                                } else {
                                    echo nl2br(esc_html($field_value));
                                }
                                ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            <?php else : ?>
                <p><?php esc_html_e('No form data available.', 'formrank-lead-scoring'); ?></p>
            <?php endif; ?>
        </div>

        <!-- Notes -->
        <div class="formrank-card">
            <h2><?php esc_html_e('Notes', 'formrank-lead-scoring'); ?></h2>
            <textarea id="formrank-notes" class="large-text" rows="4" data-id="<?php echo esc_attr($lead['id']); ?>"><?php echo esc_textarea($lead['notes'] ?? ''); ?></textarea>
            <button type="button" class="button" id="formrank-save-notes" style="margin-top: 10px;">
                <?php esc_html_e('Save Notes', 'formrank-lead-scoring'); ?>
            </button>
        </div>
    </div>
</div>
