<?php
/**
 * Conversions Analytics Page Template
 *
 * @package FormRankLS
 */

defined( 'ABSPATH' ) || exit;

$learning = $analytics['learning_status'];
$segments = $analytics['segments'];
$accuracy = $analytics['accuracy'];
$funnel   = $analytics['funnel'];
$recent   = $analytics['recent_conversions'];

$scoring_engine = new \FormRankLS\Core\Local_Scoring_Engine();
$has_anomaly    = $scoring_engine->has_segment_anomaly( $segments );
?>

<div class="wrap formrank-wrap">
    <h1 class="wp-heading-inline">
        <span class="dashicons dashicons-chart-pie"></span>
        <?php esc_html_e( 'Conversion Analytics', 'formrank-lead-scoring' ); ?>
    </h1>

    <!-- Learning Status Section -->
    <div class="formrank-section formrank-learning-section">
        <?php include FORMRANK_LS_PATH . 'templates/admin/partials/learning-status.php'; ?>
    </div>

    <!-- Analytics Grid -->
    <div class="formrank-analytics-grid">
        <!-- Conversion by Segment -->
        <div class="formrank-card">
            <h3 class="formrank-card-title">
                <span class="dashicons dashicons-chart-bar"></span>
                <?php esc_html_e( 'Conversion Rate by Score Segment', 'formrank-lead-scoring' ); ?>
            </h3>
            <?php include FORMRANK_LS_PATH . 'templates/admin/partials/conversion-segments.php'; ?>
        </div>

        <!-- Scoring Accuracy -->
        <div class="formrank-card">
            <h3 class="formrank-card-title">
                <span class="dashicons dashicons-yes-alt"></span>
                <?php esc_html_e( 'Scoring Accuracy', 'formrank-lead-scoring' ); ?>
            </h3>
            <?php include FORMRANK_LS_PATH . 'templates/admin/partials/scoring-accuracy.php'; ?>
        </div>

        <!-- Conversion Funnel -->
        <div class="formrank-card">
            <h3 class="formrank-card-title">
                <span class="dashicons dashicons-filter"></span>
                <?php esc_html_e( 'Conversion Funnel', 'formrank-lead-scoring' ); ?>
            </h3>
            <?php include FORMRANK_LS_PATH . 'templates/admin/partials/conversion-funnel.php'; ?>
        </div>

        <!-- Recent Conversions -->
        <div class="formrank-card">
            <h3 class="formrank-card-title">
                <span class="dashicons dashicons-backup"></span>
                <?php esc_html_e( 'Recent Conversions', 'formrank-lead-scoring' ); ?>
            </h3>
            <?php include FORMRANK_LS_PATH . 'templates/admin/partials/recent-conversions.php'; ?>
        </div>
    </div>

    <!-- CTA Section -->
    <?php if ( $learning['mode'] !== 'learning_mode' ) : ?>
    <div class="formrank-cta-banner">
        <div class="formrank-cta-content">
            <h3><?php esc_html_e( 'Unlock Full Learning Mode', 'formrank-lead-scoring' ); ?></h3>
            <p>
                <?php
                if ( $learning['mode'] === 'cold_start' ) {
                    printf(
                        /* translators: %d: number of leads needed */
                        esc_html__( 'You need %d more leads before pattern detection activates. Keep generating leads!', 'formrank-lead-scoring' ),
                        esc_html( $learning['progress']['remaining'] )
                    );
                } else {
                    printf(
                        /* translators: %d: number of conversions needed */
                        esc_html__( 'Mark %d more leads as converted to unlock ML-style scoring adjustments.', 'formrank-lead-scoring' ),
                        esc_html( $learning['progress']['remaining'] )
                    );
                }
                ?>
            </p>
        </div>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=formrank-lead-scoring' ) ); ?>" class="button button-primary">
            <?php esc_html_e( 'View Leads', 'formrank-lead-scoring' ); ?>
        </a>
    </div>
    <?php endif; ?>
</div>
