<?php
/**
 * Plugin deactivation handler
 *
 * @package FormRankLS
 */

namespace FormRankLS;

if (!defined('ABSPATH')) {
    exit;
}

class Deactivator {

    public static function deactivate() {
        // Clear scheduled cron events
        wp_clear_scheduled_hook('formrank_cleanup_old_cache');
        wp_clear_scheduled_hook('formrank_data_retention_cleanup');

        // Clear transients
        delete_transient('formrank_ls_activated');

        // Note: We don't delete tables or options on deactivation
        // That happens only on uninstall via uninstall.php
    }
}
