<?php
/**
 * Plugin Name: FormRank Lead Scoring
 * Plugin URI: https://formrankwp.com
 * Description: Intelligent lead scoring for WordPress forms. Automatically score and qualify leads from WPForms, Gravity Forms, Contact Form 7, Fluent Forms, and Formidable Forms.
 * Version: 1.1.4
 * Author: Eliecer Vera
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: formrank-lead-scoring
 * Domain Path: /languages
 * Requires at least: 5.8
 * Tested up to: 6.9.1
 * Requires PHP: 7.4
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('FORMRANK_LS_VERSION', '1.1.4');
define('FORMRANK_LS_PATH', plugin_dir_path(__FILE__));
define('FORMRANK_LS_URL', plugin_dir_url(__FILE__));
define('FORMRANK_LS_BASENAME', plugin_basename(__FILE__));

// Proxy URL for API calls (your Cloudflare Worker)
// Override in wp-config.php if needed: define('FORMRANK_PROXY_URL', 'https://your-worker.workers.dev');
if (!defined('FORMRANK_PROXY_URL')) {
    define('FORMRANK_PROXY_URL', 'https://formrank-proxy.eliecervera.workers.dev');
}

/**
 * Initialize Freemius SDK (must be loaded first)
 */
if (file_exists(FORMRANK_LS_PATH . 'vendor/freemius/start.php')) {
    require_once FORMRANK_LS_PATH . 'includes/class-freemius.php';
}

/**
 * Activation hook
 */
function formrank_ls_activate() {
    require_once FORMRANK_LS_PATH . 'includes/class-activator.php';
    FormRankLS\Activator::activate();
}
register_activation_hook(__FILE__, 'formrank_ls_activate');

/**
 * Deactivation hook
 */
function formrank_ls_deactivate() {
    require_once FORMRANK_LS_PATH . 'includes/class-deactivator.php';
    FormRankLS\Deactivator::deactivate();
}
register_deactivation_hook(__FILE__, 'formrank_ls_deactivate');

/**
 * Initialize the plugin
 */
function formrank_ls_init() {
    require_once FORMRANK_LS_PATH . 'includes/class-formrank-lead-scoring.php';
    $plugin = new FormRankLS\FormRank_Lead_Scoring();
    $plugin->run();
}
add_action('plugins_loaded', 'formrank_ls_init', 20);

/**
 * Check if Pro license is active
 */
function formrank_ls_is_pro() {
    if (function_exists('FormRankLS\fr_fs')) {
        return \FormRankLS\formrank_is_premium();
    }
    return apply_filters('formrank_ls_is_pro', false);
}

/**
 * Get current plan name
 */
function formrank_ls_get_plan() {
    if (function_exists('FormRankLS\fr_fs')) {
        return \FormRankLS\formrank_get_plan();
    }
    return 'free';
}
