/**
 * FormRank Setup Wizard — Multi-step flow
 *
 * @package FormRankLS
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        var $steps = $('#formrank-wizard-steps');
        var $step1 = $('#formrank-wizard-step-1');
        var $step2 = $('#formrank-wizard-step-2');
        var $step3 = $('#formrank-wizard-step-3');
        var $loading = $('#formrank-wizard-loading');
        var $footer = $('#formrank-wizard-footer');
        var redirectUrl = '';

        function setActiveStep(num) {
            $steps.find('.formrank-step-dot').removeClass('active completed');
            $steps.find('.formrank-step-dot').each(function() {
                var step = parseInt($(this).data('step'), 10);
                if (step < num) {
                    $(this).addClass('completed');
                } else if (step === num) {
                    $(this).addClass('active');
                }
            });
        }

        function transition($from, $to, callback) {
            $from.fadeOut(200, function() {
                $to.fadeIn(200, callback);
            });
        }

        // Step 1 → Step 2
        $('#formrank-wizard-next-1').on('click', function() {
            setActiveStep(2);
            transition($step1, $step2);
        });

        // Step 2: Industry card click → Loading → Step 3
        $('.formrank-wizard-card').on('click', function() {
            var industry = $(this).data('industry');

            // Visual feedback
            $('.formrank-wizard-card').removeClass('selected');
            $(this).addClass('selected');

            // Show loading, hide footer and step indicator
            $footer.fadeOut(200);
            $steps.fadeOut(200);
            transition($step2, $loading);

            // Insert demo data via AJAX
            $.ajax({
                url: formrankWizard.ajax_url,
                type: 'POST',
                data: {
                    action: 'formrank_setup_wizard_insert',
                    nonce: formrankWizard.nonce,
                    industry: industry
                },
                success: function(response) {
                    if (response.success) {
                        redirectUrl = response.data.redirect_url;
                        // Show step indicator on step 3, hide footer
                        $steps.fadeIn(200);
                        setActiveStep(3);
                        transition($loading, $step3);
                    } else {
                        alert(response.data.message || 'Something went wrong.');
                        $steps.fadeIn(200);
                        setActiveStep(2);
                        transition($loading, $step2);
                        $footer.fadeIn(200);
                    }
                },
                error: function() {
                    alert('Connection error. Please try again.');
                    $steps.fadeIn(200);
                    setActiveStep(2);
                    transition($loading, $step2);
                    $footer.fadeIn(200);
                }
            });
        });

        // Step 3: Explore Dashboard
        $('#formrank-wizard-explore').on('click', function() {
            window.location.href = redirectUrl || formrankWizard.dashboard_url;
        });

        // Skip button — mark onboarding complete without demo data
        $('#formrank-wizard-skip').on('click', function(e) {
            e.preventDefault();
            var skipUrl = formrankWizard.skip_url;

            $.ajax({
                url: formrankWizard.ajax_url,
                type: 'POST',
                data: {
                    action: 'formrank_setup_wizard_insert',
                    nonce: formrankWizard.nonce,
                    industry: '__skip__'
                },
                complete: function() {
                    window.location.href = skipUrl;
                }
            });
        });
    });
})(jQuery);
