/**
 * FormRank Onboarding Handlers
 *
 * @package FormRankLS
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        var nonce = formrankOnboarding.nonce;

        // Skip to fresh start
        $('.formrank-skip-to-fresh').on('click', function() {
            $.ajax({
                url: formrankOnboarding.ajax_url,
                type: 'POST',
                data: {
                    action: 'formrank_complete_onboarding',
                    nonce: nonce,
                    scenario: 'cold_start'
                },
                success: function() {
                    $('.formrank-onboarding-notice').slideUp();
                }
            });
        });

        // Dismiss onboarding
        $('.formrank-dismiss-onboarding').on('click', function() {
            $.ajax({
                url: formrankOnboarding.ajax_url,
                type: 'POST',
                data: {
                    action: 'formrank_skip_onboarding',
                    nonce: nonce
                },
                success: function() {
                    $('.formrank-onboarding-notice').slideUp();
                }
            });
        });
    });
})(jQuery);
