/**
 * FormRank Import Page Controller
 *
 * @package FormRankLS
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        var nonce = formrankImport.nonce;
        var currentPlugin = '';

        // Grant permission click
        $('.formrank-grant-permission').on('click', function() {
            currentPlugin = $(this).data('plugin');
            var pluginName = $(this).closest('tr').find('td:first strong').text();
            $('#permission-modal .plugin-name').text(pluginName);
            $('#permission-modal').css('display', 'flex');
        });

        // Confirm permission
        $('#confirm-permission').on('click', function() {
            $.ajax({
                url: formrankImport.ajax_url,
                type: 'POST',
                data: {
                    action: 'formrank_grant_permission',
                    nonce: nonce,
                    plugin: currentPlugin
                },
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert(response.data.message || formrankImport.strings.grant_failed);
                    }
                }
            });
        });

        // Cancel permission
        $('#cancel-permission').on('click', function() {
            $('#permission-modal').hide();
            currentPlugin = '';
        });

        // Revoke permission
        $('.formrank-revoke-permission').on('click', function() {
            if (!confirm(formrankImport.strings.confirm_revoke)) {
                return;
            }

            var plugin = $(this).data('plugin');

            $.ajax({
                url: formrankImport.ajax_url,
                type: 'POST',
                data: {
                    action: 'formrank_revoke_permission',
                    nonce: nonce,
                    plugin: plugin
                },
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert(response.data.message || formrankImport.strings.revoke_failed);
                    }
                }
            });
        });

        // Import plugin data
        $('.formrank-import-plugin').on('click', function() {
            var plugin = $(this).data('plugin');
            var totalCount = parseInt($(this).data('count'));

            if (!confirm(formrankImport.strings.confirm_import)) {
                return;
            }

            // Show progress
            $('.formrank-import-progress').show();
            $('.total-count').text(totalCount);
            $('.imported-count').text(0);
            $('.formrank-progress-fill').css('width', '0%');
            $('.formrank-progress-status').text(formrankImport.strings.starting);

            // Disable import buttons
            $('.formrank-import-plugin').prop('disabled', true);

            // Start batch import
            importBatch(plugin, 0, totalCount);
        });

        function importBatch(plugin, offset, totalCount) {
            var batchSize = 50;

            $.ajax({
                url: formrankImport.ajax_url,
                type: 'POST',
                data: {
                    action: 'formrank_import_entries',
                    nonce: nonce,
                    plugin: plugin,
                    batch_size: batchSize,
                    offset: offset
                },
                success: function(response) {
                    if (response.success) {
                        var imported = offset + response.data.imported + response.data.skipped;
                        var percent = Math.min(100, (imported / totalCount) * 100);

                        $('.imported-count').text(imported);
                        $('.formrank-progress-fill').css('width', percent + '%');
                        $('.formrank-progress-status').text(
                            formrankImport.strings.imported + ' ' + response.data.imported +
                            ' | ' + formrankImport.strings.skipped + ' ' + response.data.skipped
                        );

                        // Continue if more to import
                        if (response.data.total >= batchSize) {
                            importBatch(plugin, offset + batchSize, totalCount);
                        } else {
                            // Done
                            $('.formrank-progress-status').text(formrankImport.strings.complete);
                            $('.formrank-import-plugin').prop('disabled', false);

                            // Reload after 2 seconds
                            setTimeout(function() {
                                location.reload();
                            }, 2000);
                        }
                    } else {
                        $('.formrank-progress-status').text(formrankImport.strings.error + ' ' + response.data.error);
                        $('.formrank-import-plugin').prop('disabled', false);
                    }
                },
                error: function() {
                    $('.formrank-progress-status').text(formrankImport.strings.connection_error);
                    $('.formrank-import-plugin').prop('disabled', false);
                }
            });
        }
    });
})(jQuery);
