<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class FormLift_Settings_Page {

	static $admin_page;

	/**
	 * adds the settings page to the menu
	 */
	public static function add_this_page() {
		static::$admin_page = add_submenu_page(
			'edit.php?post_type=infusion_form',
			'Settings',
			'Settings',
			'manage_options',
			'formlift_settings_page',
			array( 'FormLift_Settings_Page', 'create_page' )
		);
	}

	/**
	 * displays the setting HTML and a notice if FormLift is not licensed
	 */
	public static function create_page() {
		?>
		<form method="post" action="">
			<div class="wrap">
				<h1 class="wp-header-inline">FormLift Settings</h1>
				<?php wp_nonce_field( 'update', 'formlift_options' ); ?>
				<?php wp_nonce_field( 'formlift_delete_sessions', 'delete_sessions_nonce' ); ?>
				<div class="right-bar">
					<img id="groundhogg-connect"
					     src="<?php echo plugins_url( 'assets/images/groundhogg-formlift-ad.png', __FILE__ ); ?>">
				</div>
				<div class="options-container">
					<div class="formlift-settings-wrap">
						<?php $settings = new FormLift_Options_Skin( "settings_page", 'form_settings' );
						$settings->add_section( 'formlift_infusionsoft_settings', 'Infusionsoft API', FormLift_Settings::infusionsoft_settings() );
						//$settings->add_section( 'formlift_captcha_settings', 'Spam Protection', formlift_Form_Settings::get_captcha_settings());
						$settings->add_section( 'formlift_error_settings', 'Messages', FormLift_Settings::error_settings() );
						$settings->add_section( 'formlift_tracking_settings', 'Tracking Defaults', FormLift_Settings::tracking_settings() );
						$settings->add_section( 'formlift_admin_settings', 'Admin Settings', FormLift_Settings::admin_settings() );
						$settings->add_section( 'formlift_import_export', 'Import/Export', FormLift_Settings::import_export() );
						$settings = apply_filters( 'formlift_form_settings_options_panel_tabs', $settings );
						echo $settings; ?>
					</div>
					<div class="formlift-settings-wrap">
						<?php $page = new FormLift_Options_Skin( "settings_page", 'style_settings' );
						$page->add_section( 'formlift_button_css', 'Button CSS', FormLift_Style_Settings::get_button_css() );
						$page->add_section( 'formlift_input_css', 'Input CSS', FormLift_Style_Settings::get_input_css() );
						$page->add_section( 'formlift_radio_css', 'Radio & Checkbox CSS', FormLift_Style_Settings::get_radio_checkbox_css() );
						$page->add_section( 'formlift_label_css', 'Label CSS', FormLift_Style_Settings::get_label_css() );
						$page->add_section( 'formlift_form_css', 'Form CSS', FormLift_Style_Settings::get_form_css() );
						$page->add_section( 'formlift_field_css', 'Field CSS', FormLift_Style_Settings::get_field_css() );
						$page->add_section( 'formlift_advanced_css', 'Advanced CSS', FormLift_Style_Settings::get_advanced_css() );
						$page->add_section( 'formlift_error_css', 'Error CSS', FormLift_Style_Settings::get_error_css() );
						$page = apply_filters( 'formlift_form_style_settings_options_panel_tabs', $page );
						echo $page; ?>
					</div>
				</div>

			</div>
		</form>
		<?php

		\FormLift\Groundhogg::instance()->output_js();
	}

	public static function add_scripts() {
		$screen = get_current_screen();

		if ( $screen->id != static::$admin_page ) {
			return;
		}

		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style( 'formlift-admin' );
		wp_enqueue_style( 'formlift-settings' );
		wp_enqueue_script( 'jQuery' );
		wp_enqueue_script( 'wp-color-picker-alpha' );
		wp_enqueue_script( 'formlift-admin' );
		wp_enqueue_script( 'formlift-leaderboard' );
	}

	public static function register_scripts() {
		wp_register_script( 'wp-color-picker-alpha', plugins_url( 'assets/js/wp-color-picker-alpha.min.js', __FILE__ ), array(
			'wp-color-picker',
			'jquery-color'
		), FORMLIFT_JS_VERSION );
		wp_register_script( 'formlift-admin', plugins_url( 'assets/js/admin.js', __FILE__ ), array(), FORMLIFT_JS_VERSION );
		wp_register_script( 'formlift-leaderboard', plugins_url( 'assets/js/leaderboard.js', __FILE__ ), array(), FORMLIFT_JS_VERSION );
		wp_register_style( 'formlift-admin', plugins_url( 'assets/css/admin.css', __FILE__ ), array(), FORMLIFT_CSS_VERSION );
		wp_register_style( 'formlift-settings', plugins_url( 'assets/css/settings-page.css', __FILE__ ), array(), FORMLIFT_CSS_VERSION );
	}
}

add_action( 'admin_menu', array( 'FormLift_Settings_Page', 'add_this_page' ) );
add_action( 'admin_enqueue_scripts', array( 'FormLift_Settings_Page', 'register_scripts' ) );
add_action( 'admin_enqueue_scripts', array( 'FormLift_Settings_Page', 'add_scripts' ) );