<div class="wrap card">
    <h1><?= __('Plugin_name', OFSSLS_TEXT_DOMAIN) ?></h1>
    <p><?php esc_html_e('Plugin_description', OFSSLS_TEXT_DOMAIN) ?></p>

    <form method="post" name="my_options" action="options.php">
        <?php
        $options = get_option(OFSSLS_PLUGIN_NAME);
        $move_to = $options['move_to'];
        $move_from = $options['move_from'];
        $enable = $options['enable'];
        $replace_first = $options['replace_first'];

        settings_fields(OFSSLS_PLUGIN_NAME);
        do_settings_sections(OFSSLS_PLUGIN_NAME);
        ?>

        <table class="form-table" role="presentation">
            <tbody>
            <tr>
                <th scope="row">
                    <label for="<?= OFSSLS_PLUGIN_NAME; ?>-enable">
                        <span> <?php esc_html_e('Activate rewriting', OFSSLS_TEXT_DOMAIN) ?></span>
                    </label>
                </th>
                <td>
                    <input type="checkbox"
                           class="regular-text" id="<?= OFSSLS_PLUGIN_NAME; ?>-enable"
                           name="<?= OFSSLS_PLUGIN_NAME; ?>[enable]"
                           value="<?= $enable; ?>"
                           onchange='changeCheckBoxValue("<?= OFSSLS_PLUGIN_NAME; ?>-enable")'
                        <?php if ($enable == "1") echo "checked"; ?>
                    />
                </td>
            </tr>
            <tr>
                <th scope="row" colspan="2" class="">
                    <a href="#" class="button button-primary toggle-advanced"><?php esc_html_e('Show advanced Option', OFSSLS_TEXT_DOMAIN) ?></a>
                </th>
            </tr>
            <tr class="advanced hidden">
                <th scope="row">
                    <label for="<?= OFSSLS_PLUGIN_NAME; ?>-move_to">
                        <span><?php esc_html_e('Change to', OFSSLS_TEXT_DOMAIN) ?></span>
                    </label>
                </th>
                <td>
                    <input type="text"
                           class="regular-text" id="<?= OFSSLS_PLUGIN_NAME; ?>-move_to"
                           name="<?= OFSSLS_PLUGIN_NAME; ?>[move_to]"
                           value="<?php echo empty($move_to) ? 'https://' : esc_attr($move_to, OFSSLS_TEXT_DOMAIN); ?>"
                           placeholder="<?php esc_html_e('url part', OFSSLS_TEXT_DOMAIN) ?>"
                    />
                </td>
            </tr>
            <tr class="advanced hidden">
                <th scope="row">
                    <label for="<?= OFSSLS_PLUGIN_NAME; ?>-move_from">
                        <span><?php esc_html_e('Change from', OFSSLS_TEXT_DOMAIN) ?></span>
                    </label>
                </th>
                <td>
                    <input type="text"
                           class="regular-text" id="<?= OFSSLS_PLUGIN_NAME; ?>-move_from"
                           name="<?= OFSSLS_PLUGIN_NAME; ?>[move_from]"
                           value="<?php echo empty($move_from) ? 'http://' : esc_attr_e($move_from, OFSSLS_TEXT_DOMAIN); ?>"
                           placeholder="<?php esc_html_e('url part', OFSSLS_TEXT_DOMAIN) ?>"
                    />
                </td>
            </tr>
            <tr class="advanced hidden">
                <th scope="row">
                    <label for="<?= OFSSLS_PLUGIN_NAME; ?>-replace_first">
                        <span><?php esc_html_e('Replace only frist', OFSSLS_TEXT_DOMAIN) ?></span>
                    </label>
                </th>
                <td>
                    <input type="checkbox"
                           class="regular-text" id="<?= OFSSLS_PLUGIN_NAME; ?>-replace_first"
                           name="<?= OFSSLS_PLUGIN_NAME; ?>[replace_first]"
                           value="<?= $replace_first; ?>"
                           onchange='changeCheckBoxValue("<?= OFSSLS_PLUGIN_NAME; ?>-replace_first")'
                        <?php if ($replace_first == "1") echo "checked"; ?>
                    />
                </td>
            </tr>
            </tbody>
            <script>
                function changeCheckBoxValue(id) {
                    var checkBox = window.document.getElementById(id);
                    var checked = checkBox.checked;
                    checkBox.value = checked ? 1 : 0;
                }
            </script>
        </table>

        <?php submit_button(__('Save all changes', OFSSLS_TEXT_DOMAIN), 'primary', 'submit', TRUE); ?>
    </form>

</div>
<script type="text/javascript">

    document.getElementsByClassName("toggle-advanced")[0].onclick = function (e) {
        e.preventDefault();
        Array.prototype.forEach.call(document.getElementsByClassName("advanced"),
            e => {
                console.log(e.classList.toggle("hidden"));
            }
        );
        $(".advanced").classList.remove("mystyle")("hidden");
    };
</script>
