<?php

namespace ForceSSLSwitcher;

// Block direct access to file
defined('ABSPATH') or die('Not Authorized!');

class OporaForceSSLSwitcher
{

    public function __construct()
    {
        add_action('admin_menu', array($this, 'plugin_admin_menu_function'));

        include_once("fix-resource-hooks.php");
        OFSSLS_Plugin_Register();
    }

    public function plugin_admin_menu_function()
    {
        //create main top-level menu with empty content
        add_menu_page(__('Plugin_name', OFSSLS_TEXT_DOMAIN),
            __('Plugin_name', OFSSLS_TEXT_DOMAIN),
            'administrator',
            'wps-general', null, 'dashicons-admin-generic', 300);
        // create top level submenu page which point to main menu page
        add_submenu_page('wps-general', __('General', OFSSLS_TEXT_DOMAIN),
            __('General', OFSSLS_TEXT_DOMAIN), 'manage_options',
            'wps-general', array($this, 'plugin_settings_page'));
        // add the support page
        add_submenu_page('wps-general',
            __('Plugin support page', OFSSLS_TEXT_DOMAIN),
            __('Support', OFSSLS_TEXT_DOMAIN),
            'manage_options', 'wps-support', array($this, 'plugin_support_page'));
        //call register settings function
        add_action('admin_init', array($this, 'plugin_register_settings'));
    }

    /**
     * Register the main Plugin Settings
     * @method plugin_register_settings
     */
    public function plugin_register_settings()
    {
        register_setting(OFSSLS_PLUGIN_NAME, OFSSLS_PLUGIN_NAME, array($this, 'validate'));
    }

    public function validate($input)
    {
        $valid = [];
        $valid['move_to'] = (isset($input['move_to']) && !empty($input['move_to'])) ? $input['move_to'] : "https://";
        $valid['move_from'] = (isset($input['move_from']) && !empty($input['move_from'])) ? $input['move_from'] : 'http://';

        if (isset($input['replace_first'])) {
            $valid['replace_first'] = $input['replace_first'] === "1" ? 1 : 0;
        } else {
            $valid['replace_first'] = 1;
        }

        $valid['enable'] = isset($input['enable']) && $input['enable'] === "1" ? 1 : 0;
        return $valid;
    }

    /**
     * Add settings action link to the plugins page.
     */
    public function add_action_links($links)
    {
        $settings_link = array(
            '<a href="' . admin_url('options-general.php?page=' . $this->plugin_name) . '">' . __('Settings', 'OporaForceSSLSwitcher') . '</a>',
        );

        return array_merge($settings_link, $links);
    }

    /**
     * Plugin main settings page
     * @method plugin_settings_page
     */
    public function plugin_settings_page()
    {
        include_once("templates/settings_general.php");
    }

    /**
     * Plugin support page
     * in this page there are listed some useful debug informations
     * and a quick link to write a mail to the plugin author
     * @method plugin_support_page
     */
    public function plugin_support_page()
    {
        global $wpdb, $wp_version;
        $plugin = get_plugin_data(OFSSLS_FILE, true, true);
        $wptheme = wp_get_theme();
        $current_user = wp_get_current_user();
        include_once("templates/settings_support.php");
    }
}

new OporaForceSSLSwitcher;
