<?php

if (!function_exists('wpt_food_recipe_cat_init')) {
    function wpt_food_recipe_cat_init()
    {
        register_taxonomy('wpt-food-recipe-cat', ['wpt-food-recipe'], [
            'hierarchical'          => false,
            'public'                => true,
            'show_in_nav_menus'     => true,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'query_var'             => true,
            'rewrite'               => [
                'slug' => 'recipe-categories',
            ],
            'capabilities'          => [
                'manage_terms' => 'edit_posts',
                'edit_terms'   => 'edit_posts',
                'delete_terms' => 'edit_posts',
                'assign_terms' => 'edit_posts',
            ],
            'labels'                => [
                'name'                       => __('Food Categories', 'food-recipes'),
                'singular_name'              => _x('Food Category', 'taxonomy general name', 'food-recipes'),
                'search_items'               => __('Search Food Categories', 'food-recipes'),
                'popular_items'              => __('Popular Food Categories', 'food-recipes'),
                'all_items'                  => __('All Food Categories', 'food-recipes'),
                'parent_item'                => __('Parent Food Category', 'food-recipes'),
                'parent_item_colon'          => __('Parent Food Category:', 'food-recipes'),
                'edit_item'                  => __('Edit Food Category', 'food-recipes'),
                'update_item'                => __('Update Food Category', 'food-recipes'),
                'view_item'                  => __('View Food Category', 'food-recipes'),
                'add_new_item'               => __('Add New Food Category', 'food-recipes'),
                'new_item_name'              => __('New Food Category', 'food-recipes'),
                'separate_items_with_commas' => __('Separate Food Categories with commas', 'food-recipes'),
                'add_or_remove_items'        => __('Add or remove Food Categories', 'food-recipes'),
                'choose_from_most_used'      => __('Choose from the most used Food Categories', 'food-recipes'),
                'not_found'                  => __('No Food Categories found.', 'food-recipes'),
                'no_terms'                   => __('No Food Categories', 'food-recipes'),
                'menu_name'                  => __('Food Categories', 'food-recipes'),
                'items_list_navigation'      => __('Food Categories list navigation', 'food-recipes'),
                'items_list'                 => __('Food Categories list', 'food-recipes'),
                'most_used'                  => _x('Most Used', 'wpt-food-recipe-cat', 'food-recipes'),
                'back_to_items'              => __('&larr; Back to Food Categories', 'food-recipes'),
            ],
            'show_in_rest'          => true,
            'rest_base'             => 'wpt-food-recipe-cat',
            'rest_controller_class' => 'WP_REST_Terms_Controller',
        ]);

    }
}

add_action('init', 'wpt_food_recipe_cat_init');

if (!function_exists('wpt_food_recipe_cat_updated_messages')) {
    function wpt_food_recipe_cat_updated_messages($messages)
    {

        $messages['wpt-food-recipe-cat'] = [
            0 => '', // Unused. Messages start at index 1.
            1 => __('Food Category added.', 'food-recipes'),
            2 => __('Food Category deleted.', 'food-recipes'),
            3 => __('Food Category updated.', 'food-recipes'),
            4 => __('Food Category not added.', 'food-recipes'),
            5 => __('Food Category not updated.', 'food-recipes'),
            6 => __('Food Categories deleted.', 'food-recipes'),
        ];

        return $messages;
    }
}

add_filter('term_updated_messages', 'wpt_food_recipe_cat_updated_messages');
