<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <title><?php echo $recipe->get_title(); ?></title>
  <link rel="stylesheet" href="<?php echo $this->container['plugin_url'] . '/css/print/normalize.min.css'; ?>">
  <link rel="stylesheet" href="<?php echo $this->container['plugin_url'] . '/css/print/paper.min.css'; ?>">
  <link rel="stylesheet" href="<?php echo $this->container['plugin_url'] . '/css/print/custom.css'; ?>">

  <style type="text/css">
    #filters {
      border: 1px dashed grey;
      background: rgb(241, 243, 244);
      padding:10px;
      margin-bottom:10px;
    }

    .filter {
      display:flex;
      gap:13px;
      flex-wrap:wrap;
      margin-bottom:10px;
    }

    .toggle-content {
      display: flex;
    }

    .toggle-content-checkbox {
      margin-right:5px;
    }

    @media print {
     .noprint {
      display: none;
    }
  }
</style>

<script type="text/javascript">

  function updateServings(event){
    let el = event.currentTarget;
    let serving = parseFloat(el.value);

    if(isNaN(serving)){
      return;
    }
    let originalServing = parseFloat(el.dataset.serving);

    document.getElementById('quantity').innerHTML = serving;

    let ingredientItems = document.getElementsByClassName('ingredient-quantity');
    for (var i = ingredientItems.length - 1; i >= 0; i--) {
      let item = ingredientItems[i];
      item.dataset.quantity = item.dataset.quantity.trim()
      if('' === item.dataset.quantity)
        continue

      let itemQuantity = parseFloat(item.dataset.quantity);
      let newQuantity = serving / originalServing * itemQuantity;
      item.innerHTML = Math.round(newQuantity * 100) / 100;
    }
  }

  function updatePageSize(event){
    let el = event.currentTarget;
    let pageSize = el.value;
    let body = document.getElementById('body');

    body.classList.remove('A3', 'A4', 'A5');
    body.classList.add(pageSize);

    let style = document.createElement('style');
    style.innerHTML = '@page {size: ' + pageSize + '}';
    document.head.appendChild(style);
  }

  function toggleContent(e){
    let el = e.currentTarget;
    let targetElement = document.getElementById(el.dataset.selector);

    if(targetElement) {
      if(el.checked) {
        // hide the content
        targetElement.style.setProperty('display', 'none');
      } else {
        // show the content;
        targetElement.style.removeProperty('display');
      }
    } else {
      if(el.dataset.selector === 'instruction-media') {
        let images = document.getElementsByClassName('media-container');
        for (var i = images.length - 1; i >= 0; i--) {
          let image = images[i];
          if(el.checked){
            image.style.setProperty('display', 'none');
          } else {
            image.style.removeProperty('display');
          }
        }
      }
    }
  }
</script>
</head>

<!-- Set "A5", "A4" or "A3" for class name -->
<!-- Set also "landscape" if you need -->
<body id='body' class="A4">
  <?php
      $props = [
          'show_image_lightbox'       => 'off',
          'use_image_overlay'         => 'off',
          'image_overlay_icon_color'  => 'off',
          'image_hover_overlay_color' => 'off',
          'image_hover_icon'          => 'off',
      ];
      $image       = $recipe->get_image_src();
      $prep_time   = $recipe->get_prep_time();
      $cook_time   = $recipe->get_cook_time();
      $total_time  = $recipe->get_total_time();
      $yield       = $recipe->get_yield();
      $cuisines    = $recipe->get_cuisines();
      $courses     = $recipe->get_categories();
      $ingredients = $recipe->get_ingredients();
      $equipments  = $recipe->get_equipments__premium_only();

      $instruction_type = $recipe->get_instruction_type();

      if ( $instruction_type == 'simple' ) {
          $instructions = $recipe->get_simple_instructions();
      } else {
          $instructions = $recipe->get_grouped_instructions();
      }

      $nutrition = $recipe->get_nutrition_formatted__premium_only();
      $notes     = $recipe->get_notes();

  ?>

  <!-- Each sheet element should have the class "sheet" -->
  <!-- "padding-**mm" is optional: you can set 10, 15, 20 or 25 -->
  <section class="sheet padding-10mm">
    <section class="noprint" id='filters'>
     <div class='filter'>
      <strong style=''><?php echo __( 'Page Size', 'food-recipes' ); ?> : </strong>
      <div>
        <select style="width:50px" id='page-size' onchange='updatePageSize(event)'>
          <option value='A3'><?php echo __( 'A3', 'food-recipes' ); ?></option>
          <option value='A4' selected><?php echo __( 'A4', 'food-recipes' ); ?></option>
          <option value='A5'><?php echo __( 'A5', 'food-recipes' ); ?></option>
        </select>
      </div>
    </div>

    <div class='filter'>
        <strong style=''><?php echo __( 'Servings', 'food-recipes' ); ?> : </strong>
        <div style="display:flex; align-items: center;">
          <input type="number" name="serving" data-serving='<?php echo $yield['quantity']; ?>'  value='<?php echo $yield['quantity']; ?>' style='width:50px;' min='1' onchange="updateServings(event)">
          <span>&nbsp;<?php echo $yield['unit']; ?></span>
        </div>
    </div>


    <div class='filter'>
      <strong style=''><?php echo __( 'Hide Content', 'food-recipes' ); ?> : </strong>
      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="title" data-selector='title'><label><?php echo __( 'Title', 'food-recipes' ); ?></label>
      </div>


      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="image" data-selector='image'><label><?php echo __( 'Image', 'food-recipes' ); ?></label>
      </div>


      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="time" data-selector='time'><label><?php echo __( 'Time', 'food-recipes' ); ?></label>
      </div>


      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="info" data-selector='info'><label><?php echo __( 'Info', 'food-recipes' ); ?></label>
      </div>



      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="description" data-selector='description'><label><?php echo __( 'Description', 'food-recipes' ); ?></label>
      </div>

      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="ingredients" data-selector='ingredients'><label><?php echo __( 'Ingredients', 'food-recipes' ); ?></label>
      </div>

      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="equipment" data-selector='equipment'><label><?php echo __( 'Equipment', 'food-recipes' ); ?></label>
      </div>


      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="instructions" data-selector='instructions'><label><?php echo __( 'Instructions', 'food-recipes' ); ?></label>
      </div>

      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="instruction-media" data-selector='instruction-media'><label><?php echo __( 'Instruction Media', 'food-recipes' ); ?></label>
      </div>



      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="nutritional-facts" data-selector='nutritional-facts'><label><?php echo __( 'Nutritional Facts', 'food-recipes' ); ?></label>
      </div>



      <div class='toggle-content'>
        <input onclick="toggleContent(event)" class='toggle-content-checkbox' type="checkbox" name="notes" data-selector='notes'><label><?php echo __( 'Notes', 'food-recipes' ); ?></label>
      </div>

    </div>
  </section>
  <article>
   <h1 id='title'><?php echo $recipe->get_title(); ?></h1>
   <?php if ( $image ): ?>
    <img id='image' src="<?php echo $image; ?>" class='full'>
  <?php endif?>

  <section id="time" class='grid'>
    <div>
      <span><strong><?php echo __( 'Prep Time', 'food-recipes' ); ?>: </strong></span>
      <span><?php echo isset( $prep_time['raw'] ) ? $recipe->get_human_time( $prep_time['raw'] ) : ''; ?></span>
    </div>

    <div>
      <span><strong><?php echo __( 'Cook Time', 'food-recipes' ); ?>: </strong></span>
      <span><?php echo isset( $cook_time['raw'] ) ? $recipe->get_human_time( $cook_time['raw'] ) : ''; ?></span>
    </div>

    <div>
      <span><strong><?php echo __( 'Total Time', 'food-recipes' ); ?>: </strong></span>
      <span><?php echo isset( $total_time['raw'] ) ? $recipe->get_human_time( $total_time['raw'] ) : ''; ?></span>
    </div>
  </section>

  <section id="info" class='grid'>
    <div>
      <span><strong><?php echo __( 'Servings', 'food-recipes' ); ?>: </strong></span>
      <span><span id='quantity'><?php echo isset( $yield['quantity'] ) ? $yield['quantity'] : ''; ?></span><span id='unit'><?php echo isset( $yield['unit'] ) ? ' ' . $yield['unit'] : ''; ?></span></span>
    </div>

    <div>
      <span><strong><?php echo __( 'Cuisine', 'food-recipes' ); ?>: </strong></span>
      <span><?php echo isset( $cuisines['formatted'] ) ? $cuisines['formatted'] : ''; ?></span>
    </div>

    <div>
      <span><strong><?php echo __( 'Course', 'food-recipes' ); ?>: </strong></span>
      <span><?php echo isset( $courses['formatted'] ) ? $courses['formatted'] : ''; ?></span>
    </div>

  </section>

  <section id="description">
   <h2><?php echo __( 'Description', 'food-recipes' ); ?></h2>
   <p><?php echo $recipe->get_description(); ?></p>
 </section>

 <section id='ingredients'>
  <h2><?php echo __( 'Ingredients', 'food-recipes' ); ?></h2>

  <?php foreach ( $ingredients['raw'] as $group ): ?>

    <h4><?php echo $group['group_name']; ?></h4>
    <ul>
      <?php foreach ( $group['ingredients'] as $ingredient ): ?>

        <?php
            $ingredient_id    = $ingredient['ingredient'][0]['id'];
            $ingredient_title = get_the_title( $ingredient_id );
            $ingredient_note  = trim( $ingredient['notes'] );
            if ( $ingredient_note ) {
                $ingredient_title = sprintf( '%s, %s', $ingredient_title, $ingredient_note );
            }
        ?>

        <li>
          <span class='ingredient-quantity' data-quantity='<?php echo $ingredient['quantity']; ?>'><?php echo $ingredient['quantity']; ?></span><span> </span>
          <?php if ( $ingredient['unit'] ): ?>
            <span><?php echo $ingredient['unit']; ?></span><span> </span>
            <?php echo __( 'of', 'food-recipes' ); ?><span> </span>
          <?php endif?>
          <span><?php echo $ingredient_title; ?></span>

        </li>

      <?php endforeach;?>
    </ul>


  <?php endforeach;?>
</section>

<section id='equipment'>
 <h2><?php echo __( 'Equipment', 'food-recipes' ); ?></h2>

 <ul>
  <?php foreach ( $equipments['raw'] as $equipment ): ?>
    <li><?php echo $equipment['name']; ?></li>
  <?php endforeach;?>
</ul>
</section>


<section id='instructions'>
  <h2><?php echo __( 'Instructions', 'food-recipes' ); ?></h2>

  <?php if ( $instruction_type == 'simple' ): ?>
    <ul class='instructions_container'>
      <?php foreach ( $instructions['raw'] as $iter => $instruction ): ?>

        <?php
            // phpcs:ignore
        echo $this->container['recipe_view']->instruction_step( $instruction, $recipe, $props, $iter, '' ); ?>

      <?php endforeach?>
    </ul>
  <?php endif?>



  <?php if ( $instruction_type == 'grouped' ): ?>
    <ul class='instructions_container'>
      <?php foreach ( $instructions['raw'] as $instruction_group ): ?>
        <h4><?php echo $instruction_group['name']; ?></h4>
        <ul class='instructions_container'>
          <?php foreach ( $instruction_group['steps'] as $iter => $instruction ): ?>
<?php
    // phpcs:ignore
echo $this->container['recipe_view']->instruction_step( $instruction, $recipe, $props, $iter, $instruction_group['name'] ); ?>
<?php endforeach?>
        </ul>
      <?php endforeach?>
    </ul>
  <?php endif?>
</section>

<?php if ( !empty( $nutrition ) ): ?>
  <section id='nutritional-facts'>
    <h2><?php echo __( 'Nutritional Facts', 'food-recipes' ); ?></h2>
    <div id="nutritional-facts-items" class="grid">
      <?php foreach ( $nutrition as $nutrition_label => $nutrition_value ): ?>
        <div>
          <span><strong><?php echo $nutrition_label; ?></strong>: </span><span><?php echo $nutrition_value; ?></span>
        </div>

      <?php endforeach;?>
    </div>
  </section>
<?php endif?>

<?php if ( $notes ): ?>
  <section id='notes'>
    <h2><?php echo __( 'Notes', 'food-recipes' ); ?></h2>
    <?php echo $notes; ?>
  </section>
<?php endif?>

</article>

</section>
</body>

</html>
