<?php

/**
 * Registers the `wpt_food_recipe` post type.
 */
if (!function_exists('wpt_food_recipe_init')) {
    function wpt_food_recipe_init()
    {
        register_post_type('wpt-food-recipe', [
            'labels'                => [
                'name'                  => __('Food Recipes', 'food-recipes'),
                'singular_name'         => __('Food Recipe', 'food-recipes'),
                'all_items'             => __('Food Recipes', 'food-recipes'),
                'archives'              => __('Food Recipe Archives', 'food-recipes'),
                'attributes'            => __('Food Recipe Attributes', 'food-recipes'),
                'insert_into_item'      => __('Insert into Food Recipe', 'food-recipes'),
                'uploaded_to_this_item' => __('Uploaded to this Food Recipe', 'food-recipes'),
                'featured_image'        => _x('Featured Image', 'wpt-food-recipe', 'food-recipes'),
                'set_featured_image'    => _x('Set featured image', 'wpt-food-recipe', 'food-recipes'),
                'remove_featured_image' => _x('Remove featured image', 'wpt-food-recipe', 'food-recipes'),
                'use_featured_image'    => _x('Use as featured image', 'wpt-food-recipe', 'food-recipes'),
                'filter_items_list'     => __('Filter Food Recipes list', 'food-recipes'),
                'items_list_navigation' => __('Food Recipes list navigation', 'food-recipes'),
                'items_list'            => __('Food Recipes list', 'food-recipes'),
                'new_item'              => __('New Food Recipe', 'food-recipes'),
                'add_new'               => __('Add Food Recipe', 'food-recipes'),
                'add_new_item'          => __('Add New Food Recipe', 'food-recipes'),
                'edit_item'             => __('Edit Food Recipe', 'food-recipes'),
                'view_item'             => __('View Food Recipe', 'food-recipes'),
                'view_items'            => __('View Food Recipes', 'food-recipes'),
                'search_items'          => __('Search Food Recipes', 'food-recipes'),
                'not_found'             => __('No Food Recipes found', 'food-recipes'),
                'not_found_in_trash'    => __('No Food Recipes found in trash', 'food-recipes'),
                'parent_item_colon'     => __('Parent Food Recipe:', 'food-recipes'),
                'menu_name'             => __('Food Recipes', 'food-recipes'),
            ],
            'public'                => true,
            'hierarchical'          => false,
            'show_ui'               => true,
            'show_in_nav_menus'     => true,
            'supports'              => ['title', 'editor', 'thumbnail', 'author'],
            'has_archive'           => true,
            'rewrite'               => [
                'slug' => 'recipes',
            ],
            'query_var'             => true,
            'menu_position'         => null,
            'menu_icon'             => 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iOTYiIGhlaWdodD0iOTYiIHZlcnNpb249IjEuMSIgdmlld0JveD0iMCAwIDk2IDk2IiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgogPHN3aXRjaCB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtMS45OTkzIC0xLjk5MjYpIj4KICA8Zm9yZWlnbk9iamVjdCB3aWR0aD0iMSIgaGVpZ2h0PSIxIiByZXF1aXJlZEV4dGVuc2lvbnM9Imh0dHA6Ly9ucy5hZG9iZS5jb20vQWRvYmVJbGx1c3RyYXRvci8xMC4wLyIvPgogIDxnPgogICA8cGF0aCBmaWxsPSJjdXJyZW50Q29sb3IiIGQ9Im05MS4xIDMuN2MtMS4xLTEuMS0zLTEtMy45IDAuM2wtMjQgMzIuOS0xMC44IDE0LjQtOC0xMC43YzMuNS0zLjMgNC4xLTguOCAxLjItMTIuOGwtMTcuNS0yNC4xYy0wLjktMS4zLTIuOC0xLjYtNC4xLTAuNi0xLjMgMC45LTEuNiAyLjgtMC42IDQuMWwxNC40IDE5LjhjMC40IDAuNiAwLjMgMS40LTAuMyAxLjlsLTIuNSAxLjhjLTAuNiAwLjQtMS40IDAuMy0xLjktMC4zbC0xNC40LTE5LjljLTAuOS0xLjMtMi44LTEuNi00LjEtMC42LTEuMyAwLjktMS42IDIuOC0wLjYgNC4xbDE0LjQgMTkuOGMwLjQgMC42IDAuMyAxLjQtMC4zIDEuOWwtMi41IDEuOGMtMC42IDAuNC0xLjQgMC4zLTEuOS0wLjNsLTE0LjQtMTkuOGMtMC45LTEuMy0yLjgtMS42LTQuMS0wLjYtMS4zIDAuOS0xLjYgMi44LTAuNiA0LjFsMTcuNCAyNGMzIDQuMSA4LjYgNS4yIDEyLjkgMi42bDkuOCAxNC0xOC45IDI1LjJjLTIuMyAzLTEuNiA3LjMgMS40IDkuNXM3LjMgMS41IDkuNS0xLjZsMTUuNy0yMi4zIDE1LjcgMjIuM2MyLjIgMy4xIDYuNCAzLjggOS41IDEuNiAzLTIuMiAzLjctNi41IDEuNC05LjVsLTE5LTI1LjIgNi40LTkuMSAyLjIgMS42YzMuOCAyLjcgOS4xIDEuNyAxMS42LTIuMmw1LjMtOC4zYzQuNi03LjIgNy45LTE1IDkuOS0yMy4yIDEuNi02LTAuMS0xMi4zLTQuMy0xNi42eiIvPgogIDwvZz4KIDwvc3dpdGNoPgo8L3N2Zz4K',
            'show_in_rest'          => true,
            'rest_base'             => 'wpt-food-recipe',
            'rest_controller_class' => 'WP_REST_Posts_Controller',
        ]);

    }
}

add_action('init', 'wpt_food_recipe_init');

if (!function_exists('wpt_food_recipe_updated_messages')) {
    function wpt_food_recipe_updated_messages($messages)
    {
        global $post;

        $permalink = get_permalink($post);

        $messages['wpt-food-recipe'] = [
            0  => '', // Unused. Messages start at index 1.
            /* translators: %s: post permalink */
            1  => sprintf(__('Food Recipe updated. <a target="_blank" href="%s">View Food Recipe</a>', 'food-recipes'), esc_url($permalink)),
            2  => __('Custom field updated.', 'food-recipes'),
            3  => __('Custom field deleted.', 'food-recipes'),
            4  => __('Food Recipe updated.', 'food-recipes'),
            /* translators: %s: date and time of the revision */
            // phpcs:ignore
            5  => isset($_GET['revision']) ? sprintf(__('Food Recipe restored to revision from %s', 'food-recipes'), wp_post_revision_title((int) $_GET['revision'], false)) : false,
            /* translators: %s: post permalink */
            6  => sprintf(__('Food Recipe published. <a href="%s">View Food Recipe</a>', 'food-recipes'), esc_url($permalink)),
            7  => __('Food Recipe saved.', 'food-recipes'),
            /* translators: %s: post permalink */
            8  => sprintf(__('Food Recipe submitted. <a target="_blank" href="%s">Preview Food Recipe</a>', 'food-recipes'), esc_url(add_query_arg('preview', 'true', $permalink))),
            /* translators: 1: Publish box date format, see https://secure.php.net/date 2: Post permalink */
            9  => sprintf(__('Food Recipe scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview Food Recipe</a>', 'food-recipes'),
                date_i18n(__('M j, Y @ G:i', 'food-recipes'), strtotime($post->post_date)), esc_url($permalink)),
            /* translators: %s: post permalink */
            10 => sprintf(__('Food Recipe draft updated. <a target="_blank" href="%s">Preview Food Recipe</a>', 'food-recipes'), esc_url(add_query_arg('preview', 'true', $permalink))),
        ];

        return $messages;
    }
}

add_filter('post_updated_messages', 'wpt_food_recipe_updated_messages');
