<?php

if (!function_exists('wpt_food_ingredients_init')) {
    function wpt_food_ingredients_init()
    {
        register_post_type('wpt-food-ingredients', [
            'labels'                => [
                'name'                  => __('Ingredients', 'food-recipes'),
                'singular_name'         => __('Ingredients', 'food-recipes'),
                'all_items'             => __('Ingredients', 'food-recipes'),
                'archives'              => __('Ingredients Archives', 'food-recipes'),
                'attributes'            => __('Ingredients Attributes', 'food-recipes'),
                'insert_into_item'      => __('Insert into Ingredients', 'food-recipes'),
                'uploaded_to_this_item' => __('Uploaded to this Ingredients', 'food-recipes'),
                'featured_image'        => _x('Featured Image', 'wpt-food-ingredients', 'food-recipes'),
                'set_featured_image'    => _x('Set featured image', 'wpt-food-ingredients', 'food-recipes'),
                'remove_featured_image' => _x('Remove featured image', 'wpt-food-ingredients', 'food-recipes'),
                'use_featured_image'    => _x('Use as featured image', 'wpt-food-ingredients', 'food-recipes'),
                'filter_items_list'     => __('Filter Ingredients list', 'food-recipes'),
                'items_list_navigation' => __('Ingredients list navigation', 'food-recipes'),
                'items_list'            => __('Ingredients list', 'food-recipes'),
                'new_item'              => __('New Ingredients', 'food-recipes'),
                'add_new'               => __('Add New', 'food-recipes'),
                'add_new_item'          => __('Add New Ingredients', 'food-recipes'),
                'edit_item'             => __('Edit Ingredients', 'food-recipes'),
                'view_item'             => __('View Ingredients', 'food-recipes'),
                'view_items'            => __('View Ingredients', 'food-recipes'),
                'search_items'          => __('Search Ingredients', 'food-recipes'),
                'not_found'             => __('No Ingredients found', 'food-recipes'),
                'not_found_in_trash'    => __('No Ingredients found in trash', 'food-recipes'),
                'parent_item_colon'     => __('Parent Ingredients:', 'food-recipes'),
                'menu_name'             => __('Ingredients', 'food-recipes'),
            ],
            'public'                => false,
            'hierarchical'          => false,
            'show_ui'               => true,
            'show_in_nav_menus'     => false,
            'show_in_menu'          => 'edit.php?post_type=wpt-food-recipe',
            'supports'              => ['title', 'author'],
            'has_archive'           => false,
            'rewrite'               => false,
            'query_var'             => false,
            'menu_position'         => null,
            'menu_icon'             => 'dashicons-',
            'show_in_rest'          => false,
            'rest_base'             => 'wpt-food-ingredients',
            'rest_controller_class' => 'WP_REST_Posts_Controller',
        ]);

    }
}
add_action('init', 'wpt_food_ingredients_init');

if (!function_exists('wpt_food_ingredients_updated_messages')) {

    function wpt_food_ingredients_updated_messages($messages)
    {
        global $post;

        $permalink = get_permalink($post);

        $messages['wpt-food-ingredients'] = [
            0  => '', // Unused. Messages start at index 1.
            /* translators: %s: post permalink */
            1  => sprintf(__('Ingredients updated. <a target="_blank" href="%s">View Ingredients</a>', 'food-recipes'), esc_url($permalink)),
            2  => __('Custom field updated.', 'food-recipes'),
            3  => __('Custom field deleted.', 'food-recipes'),
            4  => __('Ingredients updated.', 'food-recipes'),
            /* translators: %s: date and time of the revision */
            // phpcs:ignore
            5  => isset($_GET['revision']) ? sprintf(__('Ingredients restored to revision from %s', 'food-recipes'), wp_post_revision_title((int) $_GET['revision'], false)) : false,
            /* translators: %s: post permalink */
            6  => sprintf(__('Ingredients published. <a href="%s">View Ingredients</a>', 'food-recipes'), esc_url($permalink)),
            7  => __('Ingredients saved.', 'food-recipes'),
            /* translators: %s: post permalink */
            8  => sprintf(__('Ingredients submitted. <a target="_blank" href="%s">Preview Ingredients</a>', 'food-recipes'), esc_url(add_query_arg('preview', 'true', $permalink))),
            /* translators: 1: Publish box date format, see https://secure.php.net/date 2: Post permalink */
            9  => sprintf(__('Ingredients scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview Ingredients</a>', 'food-recipes'),
                date_i18n(__('M j, Y @ G:i', 'food-recipes'), strtotime($post->post_date)), esc_url($permalink)),
            /* translators: %s: post permalink */
            10 => sprintf(__('Ingredients draft updated. <a target="_blank" href="%s">Preview Ingredients</a>', 'food-recipes'), esc_url(add_query_arg('preview', 'true', $permalink))),
        ];

        return $messages;
    }
}

add_filter('post_updated_messages', 'wpt_food_ingredients_updated_messages');
