<?php

namespace WPT_Recipe_Divi_Modules\FoodRecipeNotesModule;

use ET_Builder_Module;
use ET_Builder_Element;
/**
 * FoodRecipeTitle.
 */
class FoodRecipeNotesModule extends ET_Builder_Module {
    public $main_css_element = 'section%%order_class%%';

    public $name = 'Recipe Notes';

    public $slug = 'et_pb_wpt_recipe_notes';

    public $vb_support = 'on';

    protected $container;

    protected $module_credits = [
        'module_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
        'author'     => 'WP Tools → Get 7 day FREE Trial',
        'author_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
    ];

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
        parent::__construct();
        $this->name = __( 'Recipe Notes', 'food-recipes' );
    }

    public function init() {
    }

    /**
     * Advanced fields.
     */
    public function get_advanced_fields_config() {
        return [
            'borders'        => [
                'default' => [
                    'css' => [
                        'main' => [
                            'border_styles' => "{$this->main_css_element}",
                            'border_radii'  => "{$this->main_css_element}",
                        ],
                    ],
                ],
            ],
            'text'           => false,
            'box_shadow'     => [
                'default' => [
                    'css' => [
                        'main'      => "{$this->main_css_element}",
                        'important' => 'all',
                    ],
                ],
            ],
            'filters'        => [
                'css' => [
                    'main' => '%%order_class%%',
                ],
            ],
            'animation'      => false,
            'text_shadow'    => false,
            'max_width'      => false,
            'fonts'          => [
                'description' => [
                    'css' => [
                        'main' => "{$this->main_css_element} .recipe-notes",
                    ],
                ],
            ],
            'margin_padding' => [
                'css' => [
                    'main'      => 'section%%order_class%%',
                    'important' => 'all',
                ],
            ],
            'link_options'   => false,
        ];
    }

    /**
     * Custom css fields.
     */
    public function get_custom_css_fields_config() {
        return [
            'blog_container' => [
                'label'    => esc_html__( '', '' ),
                'selector' => '%%order_class%%',
            ],
        ];
    }

    /**
     * Divi module fields.
     *
     * @return [type] [description]
     */
    public function get_fields() {
        return $this->container['divi_notes_fields']->get_fields();
    }

    /**
     * Settings modal toggle
     *
     * @return [type] [description]
     */
    public function get_settings_modal_toggles() {
        $toggles['general']['toggles']['main_content'] = esc_html__( 'Food Recipe', 'food-recipes' );
        $toggles['advanced'] = [
            'toggles' => [
                'description' => esc_html__( 'Recipe Notes', 'food-recipes' ),
            ],
        ];
        return $toggles;
    }

    /**
     * Render function
     *
     * @param  [type] $unprocessed_props [description]
     * @param  [type] $content           [description]
     * @param  [type] $render_slug       [description]
     * @return [type] [description]
     */
    public function render( $unprocessed_props, $content = null, $render_slug ) {
        $module_classes = $this->module_classname( $render_slug );
        $module_class = trim( ET_Builder_Element::add_module_order_class( '', $render_slug ) );
        $defaults = wp_parse_args( $unprocessed_props, $this->container['divi_notes_fields']->get_defaults() );
        foreach ( $defaults as $key => $value ) {
            if ( isset( $this->props[$key] ) and empty( $this->props[$key] ) ) {
                $this->props[$key] = $value;
            }
        }
        $props = wp_parse_args( $this->props, $defaults );
        $recipe_post = $this->container['divi_modules']->get_post_from_props( $props );
        $notes = '';
        if ( $recipe_post && $recipe_post->post_type == 'wpt-food-recipe' ) {
            $recipe = $this->container['recipes']->get( $recipe_post->ID );
            $notes = $recipe->get_notes();
        } else {
            $notes = $this->container['dummy_recipe']->get_notes();
        }
        $main_selector = 'section.' . $module_class;
        ob_start();
        require $this->container['plugin_dir'] . '/resources/views/divi/notes.php';
        return ob_get_clean();
    }

}
