<?php
namespace WPT_Recipe_Divi_Modules\FoodRecipeNotesModule;

/**
 * .
 */
class Fields
{
    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    /**
     * Get default for given keys
     */
    public function get_default($key)
    {
        $defaults = $this->get_defaults();

        return isset($defaults[$key]) ? $defaults[$key] : '';
    }

    /**
     * Get defaults
     */
    public function get_defaults()
    {
        $defaults = [
            'post_id' => 'recipe--1',
        ];

        return $defaults;
    }

    /**
     * Get module fields
     */
    public function get_fields()
    {
        $fields = [];

        $fields['post_id'] = $this->container['divi_modules']->recipe_post_select_field();

        $fields['admin_label'] = [
            'label'       => __('Admin Label', 'food-recipes'),
            'type'        => 'text',
            'description' => __('This will change the label of the module in the builder for easy identification.', 'food-recipes'),
        ];

        return $fields;

    }

}
