<?php

namespace WPT_Recipe_Divi_Modules\FoodRecipeInstructionsModule;

use ET_Builder_Module;
use ET_Builder_Element;
/**
 * FoodRecipeTitle.
 */
class FoodRecipeInstructionsModule extends ET_Builder_Module {
    public $main_css_element = 'section%%order_class%%';

    public $name = 'Recipe Instructions';

    public $slug = 'et_pb_wpt_recipe_instructions';

    public $vb_support = 'on';

    protected $container;

    protected $module_credits = [
        'module_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
        'author'     => 'WP Tools → Get 7 day FREE Trial',
        'author_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
    ];

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
        parent::__construct();
        $this->name = __( 'Recipe Instructions', 'food-recipes' );
    }

    public function init() {
        $this->container['divi_instruction_fields']->set_module( $this );
    }

    public function helper() {
        return $this->container['divi_instruction_fields'];
    }

    /**
     * Advanced fields.
     */
    public function get_advanced_fields_config() {
        $config = [
            'borders'        => [
                'default'          => [
                    'css' => [
                        'main' => [
                            'border_styles' => "{$this->main_css_element}",
                            'border_radii'  => "{$this->main_css_element}",
                        ],
                    ],
                ],
                'instruction_item' => [
                    'css'         => [
                        'main' => [
                            'border_styles' => $this->get_selector( 'instruction_item' ),
                            'border_radii'  => $this->get_selector( 'instruction_item' ),
                        ],
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'instruction_item',
                ],
            ],
            'text'           => false,
            'box_shadow'     => [
                'default' => [
                    'css' => [
                        'main'      => "{$this->main_css_element}",
                        'important' => 'all',
                    ],
                ],
            ],
            'filters'        => [
                'css' => [
                    'main' => '%%order_class%%',
                ],
            ],
            'margin_padding' => [
                'css' => [
                    'main'      => 'section%%order_class%%',
                    'important' => 'all',
                ],
            ],
            'animation'      => false,
            'text_shadow'    => false,
            'max_width'      => false,
            'fonts'          => [
                'instruction_group_name' => [
                    'css'          => [
                        'main'      => "{$this->main_css_element} .instruction-group-name",
                        'important' => 'all',
                    ],
                    'header_level' => [
                        'default' => 'h4',
                    ],
                ],
            ],
            'link_options'   => false,
        ];
        $this->container['divi_instruction_fields']->set_instruction_title_font( $config );
        $this->container['divi_instruction_fields']->set_instruction_step_count_font( $config );
        $this->container['divi_instruction_fields']->set_advanced_font_definition( $config, 'instruction_text' );
        return $config;
    }

    /**
     * Custom css fields.
     */
    public function get_custom_css_fields_config() {
        return $this->container['divi_instruction_fields']->get_css_fields();
    }

    /**
     * Divi module fields.
     *
     * @return [type] [description]
     */
    public function get_fields() {
        return $this->container['divi_instruction_fields']->get_fields();
    }

    public function get_default( $key ) {
        return $this->container['divi_instruction_fields']->get_default( $key );
    }

    public function get_selector( $key ) {
        return $this->container['divi_instruction_fields']->get_selector( $key );
    }

    /**
     * Settings modal toggle
     *
     * @return [type] [description]
     */
    public function get_settings_modal_toggles() {
        $toggles['general']['toggles']['main_content'] = esc_html__( 'Recipe Ingredient', 'food-recipes' );
        $this->container['divi_instruction_fields']->set_advanced_toggles( $toggles );
        return $toggles;
    }

    /**
     * Render function
     *
     * @param  [type] $unprocessed_props [description]
     * @param  [type] $content           [description]
     * @param  [type] $render_slug       [description]
     * @return [type] [description]
     */
    public function render( $unprocessed_props, $content = null, $render_slug ) {
        $module_classes = $this->module_classname( $render_slug );
        $module_class = trim( ET_Builder_Element::add_module_order_class( '', $render_slug ) );
        $defaults = $this->container['divi_instruction_fields']->get_defaults();
        foreach ( $defaults as $key => $value ) {
            if ( isset( $this->props[$key] ) and empty( $this->props[$key] ) ) {
                $this->props[$key] = $value;
            }
        }
        $props = wp_parse_args( $this->props, $defaults );
        $recipe_post = $this->container['divi_modules']->get_post_from_props( $props );
        $instructions = [];
        $type = 'simple';
        $recipe = null;
        if ( $recipe_post && $recipe_post->post_type == 'wpt-food-recipe' ) {
            $recipe = $this->container['recipes']->get( $recipe_post->ID );
            $type = $recipe->get_instruction_type();
            if ( $type == 'simple' ) {
                $instructions = $recipe->get_simple_instructions();
            } else {
                $instructions = $recipe->get_grouped_instructions();
            }
        } else {
            $instructions = $this->container['dummy_recipe']->get_instructions();
        }
        $main_selector = 'section.' . $module_class;
        //instruction_item
        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'instruction_item',
            $this->get_selector( 'instruction_item' ),
            $render_slug
        );
        //instruction_text_container
        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'instruction_text_container',
            $this->get_selector( 'instruction_text_container' ),
            $render_slug
        );
        //instructions_container
        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'instructions_container',
            $this->get_selector( 'instructions_container' ),
            $render_slug
        );
        $text_container_width = $props['text_container_width'];
        if ( $text_container_width == '100' ) {
            $text_template_columns = '100fr';
        } else {
            $text_template_columns = sprintf( '%sfr %sfr', $text_container_width, 100 - $text_container_width );
        }
        $this->set_divi_style( $render_slug, 'instruction_item', sprintf( 'grid-template-columns:%s !important;', $text_template_columns ) );
        $this->set_divi_style( $render_slug, 'instruction_media', sprintf( 'width:%s', $props['media_width'] ) );
        ob_start();
        require $this->container['plugin_dir'] . '/resources/views/divi/instructions.php';
        return ob_get_clean();
    }

    /**
     * Set divi style
     */
    public function set_divi_style( $render_slug, $key, $declaration ) {
        $selector = $this->get_selector( $key );
        \ET_Builder_Element::set_style( $render_slug, [
            'selector'    => $selector,
            'declaration' => $declaration,
        ] );
    }

    protected function _render_module_wrapper( $output = '', $render_slug = '' ) {
        return $output;
    }

}
