<?php

namespace WPT_Recipe_Divi_Modules\FoodRecipeInstructionsModule;

/**
 * .
 */
class Fields {
    protected $container;

    protected $module;

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
    }

    /**
     * Get default for given keys
     */
    public function get_default( $key ) {
        $defaults = $this->get_defaults();
        return ( isset( $defaults[$key] ) ? $defaults[$key] : '' );
    }

    /**
     * Get defaults
     */
    public function get_defaults() {
        $defaults = [
            'post_id'                                   => 'recipe--1',
            'create_recipe_schema'                      => 'on',
            'instruction_item_padding'                  => '0|0|0|20px',
            'instruction_item_padding_tablet'           => '0|0|0|20px',
            'instruction_item_padding_phone'            => '0|0|0|20px',
            'instruction_item_margin'                   => '0|0|10px|0',
            'instruction_item_margin_tablet'            => '0|0|10px|0',
            'instruction_item_margin_phone'             => '0|0|10px|0',
            'text_container_width'                      => '100',
            'media_width'                               => '40%',
            'show_image_lightbox'                       => 'on',
            'use_image_overlay'                         => 'on',
            'image_overlay_icon_color'                  => '#edf000',
            'hover_overlay_color'                       => '#8300e9',
            'hover_icon'                                => '%%36%%',
            'instruction_group_name_level'              => 'h4',
            'instruction_text_container_padding'        => '0|0|0|0',
            'instruction_text_container_padding_tablet' => '0|0|0|0',
            'instruction_text_container_padding_phone'  => '0|0|0|0',
            'instruction_text_container_margin'         => '0|0|0|0',
            'instruction_text_container_margin_tablet'  => '0|0|0|0',
            'instruction_text_container_margin_phone'   => '0|0|0|0',
            'instructions_container_padding'            => '0|0|0|0',
            'instructions_container_padding_tablet'     => '0|0|0|0',
            'instructions_container_padding_phone'      => '0|0|0|0',
            'instructions_container_margin'             => '0|0|30px|0',
            'instructions_container_margin_tablet'      => '0|0|30px|0',
            'instructions_container_margin_phone'       => '0|0|30px|0',
            'title_level'                               => 'h2',
        ];
        return $defaults;
    }

    /**
     * Get module fields
     */
    public function get_fields() {
        $fields = [];
        $fields['post_id'] = $this->container['divi_modules']->recipe_post_select_field();
        //instruction_item
        $fields += $this->container['margin_padding']->get_margin_padding_field(
            'instruction_item',
            'advanced',
            'instruction_item',
            '0|0|10px|0',
            //margin default
            '0|0|0|20px'
        );
        $fields = $fields + $this->text_container_fields();
        $fields = $fields + $this->instruction_media_fields();
        $fields = array_merge( $fields, $this->get_instruction_image_fields() );
        $fields['admin_label'] = [
            'label'       => __( 'Admin Label', 'food-recipes' ),
            'type'        => 'text',
            'description' => __( 'This will change the label of the module in the builder for easy identification.', 'food-recipes' ),
        ];
        $fields = array_merge( $fields, $this->get_instructions_container_fields() );
        return $fields;
    }

    public function get_instructions_container_fields() {
        $fields = [];
        //instructions_container
        $fields += $this->container['margin_padding']->get_margin_padding_field(
            'instructions_container',
            'advanced',
            'instructions_container',
            '0|0|30px|0',
            //margin default
            '0|0|0|0'
        );
        return $fields;
    }

    public function get_instruction_image_fields() {
        $fields = [];
        $fields['show_image_lightbox'] = [
            'label'       => esc_html__( 'Show In Lightbox', 'food-recipes' ),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__( 'Off', 'food-recipes' ),
                'on'  => esc_html__( 'On', 'food-recipes' ),
            ],
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'instruction_image',
            'description' => esc_html__( 'Show the image in lightbox', 'food-recipes' ),
            'show_if'     => [],
            'default'     => $this->get_default( 'show_image_lightbox' ),
        ];
        $fields['use_image_overlay'] = [
            'label'       => esc_html__( 'Image Overlay', 'food-recipes' ),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__( 'Off', 'food-recipes' ),
                'on'  => esc_html__( 'On', 'food-recipes' ),
            ],
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'instruction_image',
            'description' => esc_html__( 'Show image overlay', 'food-recipes' ),
            'show_if'     => [],
            'default'     => $this->get_default( 'use_image_overlay' ),
        ];
        $fields['image_overlay_icon_color'] = [
            'label'       => esc_html__( 'Icon Color', 'food-recipes' ),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'instruction_image',
            'description' => esc_html__( '', 'food-recipes' ),
            'show_if'     => [
                'use_image_overlay' => 'on',
            ],
            'default'     => $this->get_default( 'image_overlay_icon_color' ),
        ];
        $fields['image_hover_overlay_color'] = [
            'label'       => esc_html__( 'Overlay Color', 'food-recipes' ),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'instruction_image',
            'description' => esc_html__( '', 'food-recipes' ),
            'show_if'     => [
                'use_image_overlay' => 'on',
            ],
            'default'     => $this->get_default( 'image_hover_overlay_color' ),
        ];
        $fields['image_hover_icon'] = [
            'label'           => esc_html__( 'Icon', 'food-recipes' ),
            'type'            => 'select_icon',
            'option_category' => 'basic_option',
            'class'           => ['et-pb-font-icon'],
            'tab_slug'        => 'advanced',
            'toggle_slug'     => 'instruction_image',
            'description'     => esc_html__( 'Choose an icon for hover overlay.', 'food-recipes' ),
            'hover'           => 'tabs',
            'default'         => $this->get_default( 'image_hover_icon' ),
            'show_if'         => [
                'use_image_overlay' => 'on',
            ],
        ];
        return $fields;
    }

    /**
     * Instruction media fields
     */
    public function instruction_media_fields() {
        $fields = [];
        $fields['media_width'] = [
            'label'          => esc_html__( 'Width', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'instruction_media',
            'description'    => esc_html__( 'Width of the media', 'food-recipes' ),
            'show_if'        => [],
            'allowed_units'  => ['%'],
            'default_unit'   => '%',
            'default'        => $this->get_default( 'media_width' ),
        ];
        return $fields;
    }

    /**
     * Text container fields
     */
    public function text_container_fields() {
        $fields = [];
        $fields['text_container_width'] = [
            'label'          => esc_html__( 'Width', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'instruction_text_container',
            'description'    => esc_html__( 'Width of the text container', 'food-recipes' ),
            'show_if'        => [],
            'allowed_units'  => [''],
            'default_unit'   => '',
            'validate_unit'  => false,
            'default'        => $this->get_default( 'text_container_width' ),
        ];
        //instruction_text_container
        $fields += $this->container['margin_padding']->get_margin_padding_field(
            'instruction_text_container',
            'advanced',
            'instruction_text_container',
            '0|0|0|0',
            //margin default
            '0|0|0|0'
        );
        return $fields;
    }

    /**
     * Set the module instance.
     */
    public function set_module( $module ) {
        $this->module = $module;
    }

    /**
     * Get selector
     */
    public function get_selector( $key ) {
        $selectors = $this->get_selectors();
        return $selectors[$key]['selector'];
    }

    /**
     * List of selectors
     */
    public function get_selectors() {
        return [
            'instructions_container'     => [
                'selector' => "{$this->module->main_css_element} ol.instructions_container",
                'label'    => 'Instructions List Container',
            ],
            'instruction_group_name'     => [
                'selector' => "{$this->module->main_css_element} .instruction-group-name",
                'label'    => 'Instruction Group Name',
            ],
            'instruction_item'           => [
                'selector' => "{$this->module->main_css_element} .instruction-item",
                'label'    => 'Instruction Container',
            ],
            'instruction_step_count'     => [
                'selector' => "{$this->module->main_css_element} ol li::before",
                'label'    => 'Instruction Step Count',
            ],
            'instruction_text_container' => [
                'selector' => "{$this->module->main_css_element} .instruction-text",
                'label'    => 'Instruction Text Container',
            ],
            'instruction_item_title'     => [
                'selector' => "{$this->module->main_css_element} .instruction-title",
                'label'    => 'Instruction Title',
            ],
            'instruction_text'           => [
                'selector' => "{$this->module->main_css_element} .instruction-details",
                'label'    => 'Instruction Text',
            ],
            'instruction_media'          => [
                'selector' => "{$this->module->main_css_element} .instruction-media",
                'label'    => 'Instruction Media',
            ],
            'instruction_image'          => [
                'selector' => "{$this->module->main_css_element} .instruction-image",
                'label'    => 'Instruction Image',
            ],
            'instruction_video'          => [
                'selector' => "{$this->module->main_css_element} .instruction-video",
                'label'    => 'Instruction Video',
            ],
        ];
    }

    public function set_advanced_toggles( &$toggles ) {
        $selectors = $this->get_selectors();
        foreach ( $selectors as $slug => $selector ) {
            $toggles['advanced']['toggles'][$slug] = $selector['label'];
        }
    }

    public function get_css_fields() {
        $selectors = $this->get_selectors();
        foreach ( $selectors as $key => $selector ) {
            $selectors[$key]['selector'] = 'html body div#page-container ' . $selector['selector'];
        }
        return $selectors;
    }

    /**
     * Advanced font definition
     */
    public function get_advanced_font_definition( $key ) {
        return [
            'css' => [
                'main'      => $this->get_selector( $key ),
                'important' => 'all',
            ],
        ];
    }

    public function set_advanced_font_definition( &$config, $key ) {
        $config['fonts'][$key] = $this->get_advanced_font_definition( $key );
    }

    /**
     *
     */
    public function set_instruction_title_font( &$config ) {
        $def = $this->get_advanced_font_definition( 'instruction_item_title' );
        $def['font'] = [
            'default' => '|700||||||',
        ];
        $config['fonts']['instruction_item_title'] = $def;
    }

    public function set_instruction_step_count_font( &$config ) {
        $def = $this->get_advanced_font_definition( 'instruction_step_count' );
        $def['font_size']['default'] = '17px';
        $def['font'] = [
            'default' => '|700||||||',
        ];
        $config['fonts']['instruction_step_count'] = $def;
    }

}
