<?php

namespace WPT_Recipe_Divi_Modules\FoodRecipeIngredientModule;

use ET_Builder_Module;
use ET_Builder_Element;
/**
 * FoodRecipeTitle.
 */
class FoodRecipeIngredientModule extends ET_Builder_Module {
    public $main_css_element = 'section%%order_class%%';

    public $name = 'Recipe Ingredients';

    public $slug = 'et_pb_wpt_recipe_ingredient';

    public $vb_support = 'on';

    protected $container;

    protected $module_credits = [
        'module_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
        'author'     => 'WP Tools → Get 7 day FREE Trial',
        'author_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
    ];

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
        parent::__construct();
        $this->name = __( 'Recipe Ingredients', 'food-recipes' );
    }

    public function init() {
    }

    /**
     * Advanced fields.
     */
    public function get_advanced_fields_config() {
        return [
            'text'           => false,
            'borders'        => [
                'default'              => [
                    'css' => [
                        'main' => [
                            'border_styles' => "{$this->main_css_element}",
                            'border_radii'  => "{$this->main_css_element}",
                            'important'     => 'all',
                        ],
                    ],
                ],
                'ingredient_list'      => [
                    'css'         => [
                        'main' => [
                            'border_styles' => "{$this->main_css_element} .ingredient_list",
                            'border_radii'  => "{$this->main_css_element} .ingredient_list",
                            'important'     => 'all',
                        ],
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'ingredient_list',
                ],
                'ingredient_item'      => [
                    'css'         => [
                        'main' => [
                            'border_styles' => "{$this->main_css_element} .ingredient",
                            'border_radii'  => "{$this->main_css_element} .ingredient",
                            'important'     => 'all',
                        ],
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'ingredient_item',
                ],
                'ingredient_item_link' => [
                    'css'         => [
                        'main'      => [
                            'border_styles' => "{$this->main_css_element} .ingredient a",
                            'border_radii'  => "{$this->main_css_element} .ingredient a",
                        ],
                        'important' => 'all',
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'ingredient_item_link',
                ],
            ],
            'box_shadow'     => [
                'default' => [
                    'css' => [
                        'main'      => "{$this->main_css_element}",
                        'important' => 'all',
                    ],
                ],
            ],
            'filters'        => [
                'css' => [],
            ],
            'margin_padding' => [
                'css' => [
                    'main'      => 'section%%order_class%%',
                    'important' => 'all',
                ],
            ],
            'icon_settings'  => [
                'tab_slug'    => 'advanced',
                'toggle_slug' => 'ingredient_item',
                'css'         => [
                    'main' => '%%order_class%% .et_pb_main_blurb_image',
                ],
            ],
            'animation'      => false,
            'text_shadow'    => false,
            'max_width'      => false,
            'fonts'          => [
                'ingredient_category'  => [
                    'css'          => [
                        'main'      => "{$this->main_css_element} .ingredient_category",
                        'important' => 'all',
                    ],
                    'header_level' => [
                        'default' => 'h4',
                    ],
                ],
                'ingredient_item'      => [
                    'css' => [
                        'main'      => "{$this->main_css_element} .ingredient",
                        'important' => 'all',
                    ],
                ],
                'ingredient_item_link' => [
                    'css' => [
                        'main'      => "{$this->main_css_element} .ingredient a",
                        'important' => 'all',
                    ],
                ],
            ],
            'link_options'   => false,
        ];
    }

    /**
     * Custom css fields.
     */
    public function get_custom_css_fields_config() {
        return [
            'ingredient_category'  => [
                'label'    => esc_html__( 'Ingredient Category', 'food-recipes' ),
                'selector' => '%%order_class%%  .ingredient_category',
            ],
            'ingredient_item'      => [
                'label'    => esc_html__( 'Ingredient Item', 'food-recipes' ),
                'selector' => '%%order_class%%  .ingredient',
            ],
            'ingredient_item_link' => [
                'label'    => esc_html__( 'Ingredient Item Link', 'food-recipes' ),
                'selector' => '%%order_class%%  .ingredient a',
            ],
            'ingredient_item_icon' => [
                'label'    => esc_html__( 'Ingredient Item Icon', 'food-recipes' ),
                'selector' => '%%order_class%%  .ingredient .et-pb-icon',
            ],
        ];
    }

    /**
     * Divi module fields.
     *
     * @return [type] [description]
     */
    public function get_fields() {
        $fields = [];
        $fields['post_id'] = $this->container['divi_modules']->recipe_post_select_field();
        $fields['cols_desktop'] = [
            'label'          => esc_html__( 'Columns - Desktop', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 4,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'allowed_units'  => [''],
            'default_unit'   => '',
            'validate_unit'  => false,
            'default'        => '1',
        ];
        $fields['cols_tablet'] = [
            'label'          => esc_html__( 'Columns - Tablet', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 4,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'allowed_units'  => [''],
            'default_unit'   => '',
            'validate_unit'  => false,
            'default'        => '1',
        ];
        $fields['cols_mobile'] = [
            'label'          => esc_html__( 'Columns - Mobile', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 4,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'allowed_units'  => [''],
            'default_unit'   => '',
            'validate_unit'  => false,
            'default'        => '1',
        ];
        $fields['item_gap'] = [
            'label'          => esc_html__( 'Item Gap', 'food-recipes' ),
            'mobile_options' => true,
            'type'           => 'range',
            'range_settings' => [
                'min'  => 0,
                'max'  => 300,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'description'    => esc_html__( 'Column and row spacing being items', 'food-recipes' ),
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => '5px',
        ];
        $fields['show_icon'] = [
            'label'       => esc_html__( 'Show Icon', 'food-recipes' ),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__( 'Off', 'food-recipes' ),
                'on'  => esc_html__( 'On', 'food-recipes' ),
            ],
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'ingredient_item',
            'default'     => 'on',
        ];
        $fields['font_icon'] = [
            'label'           => esc_html__( 'Icon', 'food-recipes' ),
            'type'            => 'select_icon',
            'option_category' => 'basic_option',
            'class'           => ['et-pb-font-icon'],
            'tab_slug'        => 'advanced',
            'toggle_slug'     => 'ingredient_item',
            'description'     => esc_html__( 'Choose an icon to display before ingredient name.', 'food-recipes' ),
            'hover'           => 'tabs',
            'default'         => '%%36%%',
            'show_if'         => [
                'show_icon' => 'on',
            ],
        ];
        $fields['icon_margin_right'] = [
            'label'          => esc_html__( 'Icon Margin Right', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 200,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'ingredient_item',
            'description'    => esc_html__( '', 'food-recipes' ),
            'show_if'        => [
                'show_icon' => 'on',
            ],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => '2px',
        ];
        $fields['icon_color'] = [
            'label'       => esc_html__( 'Color', 'food-recipes' ),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'ingredient_item',
            'description' => esc_html__( '', 'food-recipes' ),
            'show_if'     => [
                'show_icon' => 'on',
            ],
            'default'     => '#666666',
        ];
        //ingredient_list
        $fields += $this->container['margin_padding']->get_margin_padding_field(
            'ingredient_list',
            'advanced',
            'ingredient_list',
            '0|0|0|0',
            //margin default
            '0|0|30px|0'
        );
        //ingredient_item
        $fields += $this->container['margin_padding']->get_margin_padding_field(
            'ingredient_item',
            'advanced',
            'ingredient_item',
            '0|0|5px|0',
            //margin default
            '0|0|5px|0'
        );
        $fields['admin_label'] = [
            'label'       => __( 'Admin Label', 'food-recipes' ),
            'type'        => 'text',
            'description' => 'This will change the label of the module in the builder for easy identification.',
        ];
        return $fields;
    }

    /**
     * Settings modal toggle
     *
     * @return [type] [description]
     */
    public function get_settings_modal_toggles() {
        $toggles['general']['toggles']['main_content'] = esc_html__( 'Recipe Ingredient', 'food-recipes' );
        $toggles['advanced'] = [
            'toggles' => [
                'ingredient_category'  => esc_html__( 'Ingredient Category', 'food-recipes' ),
                'ingredient_list'      => esc_html__( 'Ingredients List', 'food-recipes' ),
                'ingredient_item'      => esc_html__( 'Ingredients Item', 'food-recipes' ),
                'ingredient_item_link' => esc_html__( 'Ingredients Item Link', 'food-recipes' ),
            ],
        ];
        return $toggles;
    }

    /**
     * Render function
     *
     * @param  [type] $unprocessed_props [description]
     * @param  [type] $content           [description]
     * @param  [type] $render_slug       [description]
     * @return [type] [description]
     */
    public function render( $unprocessed_props, $content = null, $render_slug ) {
        $module_classes = $this->module_classname( $render_slug );
        $module_class = trim( ET_Builder_Element::add_module_order_class( '', $render_slug ) );
        $defaults = [
            'post_id'                        => 'recipe--1',
            'cols_desktop'                   => '1',
            'cols_tablet'                    => '1',
            'cols_mobile'                    => '1',
            'item_gap'                       => '5px',
            'ingredient_category_level'      => 'h4',
            'show_icon'                      => 'on',
            'font_icon'                      => '%%36%%',
            'icon_color'                     => '#666666',
            'ingredient_list_padding'        => '0|0|30px|0',
            'ingredient_list_padding_tablet' => '0|0|30px|0',
            'ingredient_list_padding_phone'  => '0|0|30px|0',
            'ingredient_list_margin'         => '0|0|0|0',
            'ingredient_list_margin_tablet'  => '0|0|0|0',
            'ingredient_list_margin_phone'   => '0|0|0|0',
            'ingredient_item_padding'        => '0|0|5px|0',
            'ingredient_item_padding_tablet' => '0|0|5px|0',
            'ingredient_item_padding_phone'  => '0|0|5px|0',
            'ingredient_item_margin'         => '0|0|5px|0',
            'ingredient_item_margin_tablet'  => '0|0|5px|0',
            'ingredient_item_margin_phone'   => '0|0|5px|0',
            'icon_margin_right'              => '2px',
        ];
        foreach ( $defaults as $key => $value ) {
            if ( isset( $this->props[$key] ) and empty( $this->props[$key] ) ) {
                $this->props[$key] = $value;
            }
        }
        $props = wp_parse_args( $this->props, $defaults );
        $recipe_post = $this->container['divi_modules']->get_post_from_props( $props );
        $ingredients = [];
        if ( $recipe_post && $recipe_post->post_type == 'wpt-food-recipe' ) {
            $recipe = $this->container['recipes']->get( $recipe_post->ID );
            $ingredients_meta = $recipe->get_ingredients();
            $ingredients = $recipe->get_formatted_ingredients( $ingredients_meta['raw'], true );
        } else {
            $ingredients = $this->container['dummy_recipe']->get_ingredients();
        }
        $main_selector = 'section.' . $module_class;
        et_pb_responsive_options()->generate_responsive_css(
            [
                'desktop' => sprintf( 'repeat(%s, 1fr);', $props['cols_desktop'] ),
                'tablet'  => sprintf( 'repeat(%s, 1fr);', $props['cols_tablet'] ),
                'phone'   => sprintf( 'repeat(%s, 1fr);', $props['cols_mobile'] ),
            ],
            "{$main_selector} .ingredient_list",
            'grid-template-columns',
            $render_slug,
            '',
            'grid',
            '!important'
        );
        // item gap
        $values = [
            'desktop' => $props['item_gap'],
            'tablet'  => ( isset( $props['item_gap_tablet'] ) && $props['item_gap_tablet'] ? $props['item_gap_tablet'] : 'inherit' ),
            'phone'   => ( isset( $props['item_gap_phone'] ) && $props['item_gap_phone'] ? $props['item_gap_phone'] : 'inherit' ),
        ];
        et_pb_responsive_options()->generate_responsive_css(
            $values,
            "{$main_selector} .ingredient_list",
            'column-gap',
            $render_slug,
            '',
            'grid',
            '!important'
        );
        et_pb_responsive_options()->generate_responsive_css(
            $values,
            "{$main_selector} .ingredient_list",
            'row-gap',
            $render_slug,
            '',
            'grid',
            '!important'
        );
        $icon = '';
        if ( $props['show_icon'] == 'on' ) {
            $icon = sprintf( '<span class="et-pb-icon">%1$s</span>', esc_attr( et_pb_process_font_icon( $props['font_icon'] ) ) );
            \ET_Builder_Element::set_style( $render_slug, [
                'selector'    => "{$main_selector} .ingredient .et-pb-icon",
                'declaration' => sprintf( 'color:%s !important; margin-right : %s;', $props['icon_color'], $props['icon_margin_right'] ),
            ] );
        }
        //ingredient_list
        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'ingredient_list',
            "{$main_selector} .ingredient_list",
            $render_slug
        );
        //ingredient_item
        $this->container['margin_padding']->responsive_margin_padding(
            $props,
            'ingredient_item',
            "{$main_selector} .ingredient",
            $render_slug
        );
        ob_start();
        require $this->container['plugin_dir'] . '/resources/views/divi/ingredient.php';
        return ob_get_clean();
    }

    protected function _render_module_wrapper( $output = '', $render_slug = '' ) {
        return $output;
    }

}
