<?php

namespace WPT_Recipe_Divi_Modules\FoodRecipeImageModule;

use ET_Builder_Element;
use ET_Builder_Module_Image;
/**
 * FoodRecipeTitle.
 */
class FoodRecipeImageModule extends ET_Builder_Module_Image {
    protected $container;

    protected $module_credits = [
        'module_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
        'author'     => 'WP Tools → Get 7 day FREE Trial',
        'author_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
    ];

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
        parent::__construct();
    }

    public function init() {
        parent::init();
        $this->name = __( 'Recipe Image', 'food-recipes' );
        $this->slug = 'et_pb_wpt_recipe_image';
        $this->vb_support = 'on';
    }

    /**
     * Divi module fields.
     *
     * @return [type] [description]
     */
    public function get_fields() {
        $fields = parent::get_fields();
        $fields['post_id'] = $this->container['divi_modules']->recipe_post_select_field();
        $fields['src']['type'] = 'hidden';
        return $fields;
    }

    /**
     * Settings modal toggle
     *
     * @return [type] [description]
     */
    public function get_settings_modal_toggles() {
        $toggles = parent::get_settings_modal_toggles();
        $toggles['general']['toggles']['main_content'] = esc_html__( 'Food Recipe', 'food-recipes' );
        return $toggles;
    }

    /**
     * Render function
     *
     * @param  [type] $unprocessed_props [description]
     * @param  [type] $content           [description]
     * @param  [type] $render_slug       [description]
     * @return [type] [description]
     */
    public function render( $unprocessed_props, $content = null, $render_slug ) {
        $module_classes = $this->module_classname( $render_slug );
        $module_class = trim( ET_Builder_Element::add_module_order_class( '', $render_slug ) );
        $defaults = wp_parse_args( $unprocessed_props, $this->container['divi_title_fields']->get_defaults() );
        foreach ( $defaults as $key => $value ) {
            if ( isset( $this->props[$key] ) and empty( $this->props[$key] ) ) {
                $this->props[$key] = $value;
            }
        }
        $props = wp_parse_args( $this->props, $defaults );
        $use_overlay = $this->props['use_overlay'];
        $url = $this->props['url'];
        $show_in_lightbox = $this->props['show_in_lightbox'];
        $is_overlay_applied = ( 'on' === $use_overlay && ('on' === $show_in_lightbox || 'off' === $show_in_lightbox && '' !== $url) ? 'on' : 'off' );
        if ( 'on' === $is_overlay_applied ) {
            \ET_Builder_Element::set_style( $render_slug, [
                'selector'    => "%%order_class%% .et_overlay:before",
                'declaration' => sprintf( 'color:%s !important;', $this->props['overlay_icon_color'] ),
            ] );
            \ET_Builder_Element::set_style( $render_slug, [
                'selector'    => "%%order_class%% .et_overlay",
                'declaration' => sprintf( 'background-color:%s !important;', $this->props['hover_overlay_color'] ),
            ] );
        }
        $recipe_post = $this->container['divi_modules']->get_post_from_props( $props );
        $src = '';
        if ( $recipe_post && $recipe_post->post_type == 'wpt-food-recipe' ) {
            $recipe = $this->container['recipes']->get( $recipe_post->ID );
            $src = $recipe->get_image_src();
        } else {
            $src = $this->container['dummy_recipe']->get_image_src();
        }
        $this->props['src'] = $src;
        $props['src'] = $src;
        $output = parent::render( $props, $content, $render_slug );
        return $output;
    }

    protected function _render_module_wrapper( $output = '', $render_slug = '' ) {
        return $output;
    }

}
