<?php

namespace WPT_Recipe_Divi_Modules\FoodRecipeEquipmentModule;

use ET_Builder_Module;
use ET_Builder_Element;
/**
 * FoodRecipeTitle.
 */
class FoodRecipeEquipmentModule extends ET_Builder_Module {
    public $main_css_element = 'section%%order_class%%';

    public $name = 'Recipe Equipment';

    public $slug = 'et_pb_wpt_recipe_equipment';

    public $vb_support = 'on';

    protected $container;

    protected $module_credits = [
        'module_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
        'author'     => 'WP Tools → Get 7 day FREE Trial',
        'author_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
    ];

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
        parent::__construct();
        $this->name = __( 'Recipe Equipment', 'food-recipes' );
    }

    public function init() {
    }

    /**
     * Advanced fields.
     */
    public function get_advanced_fields_config() {
        return [
            'borders'        => [
                'equipment_image'          => [
                    'css'         => [
                        'main'      => [
                            'border_styles' => "{$this->main_css_element} .equipment-image img",
                            'border_radii'  => "{$this->main_css_element} .equipment-image img",
                        ],
                        'important' => 'all',
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'equipment_image',
                ],
                'equipment_item_container' => [
                    'css'         => [
                        'main'      => [
                            'border_styles' => "{$this->main_css_element} .equipment-item",
                            'border_radii'  => "{$this->main_css_element} .equipment-item",
                        ],
                        'important' => 'all',
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'equipment_item_container',
                ],
            ],
            'text'           => false,
            'box_shadow'     => [
                'default' => [
                    'css'         => [
                        'main'      => "{$this->main_css_element} .equipment-image img",
                        'important' => 'all',
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'equipment_image',
                ],
            ],
            'filters'        => [
                'css' => [
                    'main' => '%%order_class%%',
                ],
            ],
            'animation'      => false,
            'text_shadow'    => false,
            'max_width'      => false,
            'fonts'          => [
                'equipment_name' => [
                    'css'        => [
                        'main'      => "{$this->main_css_element} .equipment-name, {$this->main_css_element} .equipment-name a",
                        'important' => 'all',
                    ],
                    'text_align' => [
                        'default' => 'center',
                    ],
                ],
            ],
            'margin_padding' => [
                'css' => [
                    'main'      => 'section%%order_class%%',
                    'important' => 'all',
                ],
            ],
            'link_options'   => false,
        ];
    }

    /**
     * Custom css fields.
     */
    public function get_custom_css_fields_config() {
        return [
            'name'  => [
                'label'    => esc_html__( 'Equipment Name', 'food-recipes' ),
                'selector' => '%%order_class%% .equipment-name, %%order_class%% .equipment-name a',
            ],
            'image' => [
                'label'    => esc_html__( 'Equipment Image', 'food-recipes' ),
                'selector' => '%%order_class%% .equipment-image img',
            ],
        ];
    }

    /**
     * Divi module fields.
     *
     * @return [type] [description]
     */
    public function get_fields() {
        $fields = [];
        $fields['post_id'] = $this->container['divi_modules']->recipe_post_select_field();
        $fields['show_image'] = [
            'label'       => esc_html__( 'Show Image', 'food-recipes' ),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__( 'Off', 'food-recipes' ),
                'on'  => esc_html__( 'On', 'food-recipes' ),
            ],
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__( '', 'food-recipes' ),
            'default'     => 'on',
        ];
        $fields['cols_desktop'] = [
            'label'          => esc_html__( 'Columns - Desktop', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 4,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'allowed_units'  => [''],
            'default_unit'   => '',
            'validate_unit'  => false,
            'default'        => '4',
        ];
        $fields['cols_tablet'] = [
            'label'          => esc_html__( 'Columns - Tablet', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 4,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'allowed_units'  => [''],
            'default_unit'   => '',
            'validate_unit'  => false,
            'default'        => '2',
        ];
        $fields['cols_mobile'] = [
            'label'          => esc_html__( 'Columns - Mobile', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 4,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'allowed_units'  => [''],
            'default_unit'   => '',
            'validate_unit'  => false,
            'default'        => '1',
        ];
        $fields['item_gap'] = [
            'label'          => esc_html__( 'Item Gap', 'food-recipes' ),
            'mobile_options' => true,
            'type'           => 'range',
            'range_settings' => [
                'min'  => 0,
                'max'  => 300,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'description'    => esc_html__( 'Column and row spacing being items', 'food-recipes' ),
            'show_if'        => [],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => '40px',
        ];
        $fields['show_icon'] = [
            'label'       => esc_html__( 'Show Icon', 'food-recipes' ),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__( 'Off', 'food-recipes' ),
                'on'  => esc_html__( 'On', 'food-recipes' ),
            ],
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'equipment_icon',
            'default'     => 'on',
        ];
        $fields['font_icon'] = [
            'label'           => esc_html__( 'Icon', 'food-recipes' ),
            'type'            => 'select_icon',
            'option_category' => 'basic_option',
            'class'           => ['et-pb-font-icon'],
            'tab_slug'        => 'advanced',
            'toggle_slug'     => 'equipment_icon',
            'description'     => esc_html__( 'Choose an icon to display before ingredient name.', 'food-recipes' ),
            'hover'           => 'tabs',
            'default'         => '%%36%%',
            'show_if'         => [
                'show_icon' => 'on',
            ],
        ];
        $fields['icon_margin_right'] = [
            'label'          => esc_html__( 'Icon Margin Right', 'food-recipes' ),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 200,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'equipment_icon',
            'description'    => esc_html__( '', 'food-recipes' ),
            'show_if'        => [
                'show_icon' => 'on',
            ],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => '2px',
        ];
        $fields['icon_color'] = [
            'label'       => esc_html__( 'Color', 'food-recipes' ),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'equipment_icon',
            'description' => esc_html__( '', 'food-recipes' ),
            'show_if'     => [
                'show_icon' => 'on',
            ],
            'default'     => '#666666',
        ];
        $fields['admin_label'] = [
            'label'       => __( 'Admin Label', 'food-recipes' ),
            'type'        => 'text',
            'description' => 'This will change the label of the module in the builder for easy identification.',
        ];
        return $fields;
    }

    /**
     * Settings modal toggle
     *
     * @return [type] [description]
     */
    public function get_settings_modal_toggles() {
        $toggles['general']['toggles']['main_content'] = esc_html__( 'Recipe Equipment', 'food-recipes' );
        $toggles['advanced'] = [
            'toggles' => [
                'equipment_image'          => esc_html__( 'Equipment Image', 'food-recipes' ),
                'equipment_name'           => esc_html__( 'Equipment Name', 'food-recipes' ),
                'equipment_item_container' => esc_html__( 'Equipment Item Container', 'food-recipes' ),
                'equipment_icon'           => esc_html__( 'Icon', 'food-recipes' ),
            ],
        ];
        return $toggles;
    }

    /**
     * Render function
     *
     * @param  [type] $unprocessed_props [description]
     * @param  [type] $content           [description]
     * @param  [type] $render_slug       [description]
     * @return [type] [description]
     */
    public function render( $unprocessed_props, $content = null, $render_slug ) {
        $module_classes = $this->module_classname( $render_slug );
        $module_class = trim( ET_Builder_Element::add_module_order_class( '', $render_slug ) );
        $defaults = [
            'post_id'           => 'recipe--1',
            'cols_desktop'      => '4',
            'cols_tablet'       => '2',
            'cols_mobile'       => '1',
            'show_image'        => 'on',
            'item_gap'          => '40px',
            'show_icon'         => 'on',
            'font_icon'         => '%%173%%',
            'icon_color'        => '#666666',
            'icon_margin_right' => '2px',
        ];
        foreach ( $defaults as $key => $value ) {
            if ( isset( $this->props[$key] ) and empty( $this->props[$key] ) ) {
                $this->props[$key] = $value;
            }
        }
        $props = wp_parse_args( $this->props, $defaults );
        $recipe_post = $this->container['divi_modules']->get_post_from_props( $props );
        $equipments = [];
        if ( $recipe_post && $recipe_post->post_type == 'wpt-food-recipe' ) {
            $recipe = $this->container['recipes']->get( $recipe_post->ID );
            $equipments = $recipe->get_equipments__premium_only();
        } else {
            $equipments = $this->container['dummy_recipe']->get_equipments__premium_only();
        }
        $main_selector = 'section.' . $module_class;
        et_pb_responsive_options()->generate_responsive_css(
            [
                'desktop' => sprintf( 'repeat(%s, 1fr);', $props['cols_desktop'] ),
                'tablet'  => sprintf( 'repeat(%s, 1fr);', $props['cols_tablet'] ),
                'phone'   => sprintf( 'repeat(%s, 1fr);', $props['cols_mobile'] ),
            ],
            "{$main_selector}",
            'grid-template-columns',
            $render_slug,
            '',
            'grid',
            '!important'
        );
        // item gap
        $values = [
            'desktop' => $props['item_gap'],
            'tablet'  => ( isset( $props['item_gap_tablet'] ) && $props['item_gap_tablet'] ? $props['item_gap_tablet'] : 'inherit' ),
            'phone'   => ( isset( $props['item_gap_phone'] ) && $props['item_gap_phone'] ? $props['item_gap_phone'] : 'inherit' ),
        ];
        et_pb_responsive_options()->generate_responsive_css(
            $values,
            "{$main_selector}",
            'column-gap',
            $render_slug,
            '',
            'grid',
            '!important'
        );
        et_pb_responsive_options()->generate_responsive_css(
            $values,
            "{$main_selector}",
            'row-gap',
            $render_slug,
            '',
            'grid',
            '!important'
        );
        $icon = '';
        if ( $props['show_icon'] == 'on' ) {
            $icon = sprintf( '<span class="et-pb-icon">%1$s</span>', esc_attr( et_pb_process_font_icon( $props['font_icon'] ) ) );
            \ET_Builder_Element::set_style( $render_slug, [
                'selector'    => "{$main_selector} .equipment-name .et-pb-icon",
                'declaration' => sprintf( 'color:%s !important; margin-right : %s;', $props['icon_color'], $props['icon_margin_right'] ),
            ] );
        }
        ob_start();
        require $this->container['plugin_dir'] . '/resources/views/divi/equipment__premium_only.php';
        return ob_get_clean();
    }

    protected function _render_module_wrapper( $output = '', $render_slug = '' ) {
        return $output;
    }

}
