<?php

namespace WPT_Recipe_Divi_Modules\FoodRecipeCourseModule;

use ET_Builder_Module;
use ET_Builder_Element;
/**
 * FoodRecipeTitle.
 */
class FoodRecipeCourseModule extends ET_Builder_Module {
    public $main_css_element = 'section%%order_class%%';

    public $name = 'Recipe Course';

    public $slug = 'et_pb_wpt_recipe_course';

    public $vb_support = 'on';

    protected $container;

    protected $module_credits = [
        'module_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
        'author'     => 'WP Tools → Get 7 day FREE Trial',
        'author_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
    ];

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
        parent::__construct();
        $this->name = __( 'Recipe Course', 'food-recipes' );
    }

    public function init() {
    }

    /**
     * Advanced fields.
     */
    public function get_advanced_fields_config() {
        return [
            'borders'        => [
                'default' => [
                    'css' => [
                        'main' => [
                            'border_styles' => "{$this->main_css_element}",
                            'border_radii'  => "{$this->main_css_element}",
                        ],
                    ],
                ],
            ],
            'text'           => false,
            'box_shadow'     => [
                'default' => [
                    'css' => [
                        'main'      => "{$this->main_css_element}",
                        'important' => 'all',
                    ],
                ],
            ],
            'filters'        => [
                'css' => [
                    'main' => '%%order_class%%',
                ],
            ],
            'animation'      => false,
            'text_shadow'    => false,
            'max_width'      => false,
            'fonts'          => [
                'title'     => [
                    'css'        => [
                        'main' => "{$this->main_css_element} .course-title",
                    ],
                    'text_align' => [
                        'default' => 'center',
                    ],
                    'font'       => [],
                ],
                'time_text' => [
                    'css'        => [
                        'main'      => "{$this->main_css_element} .course-value",
                        'important' => 'all',
                    ],
                    'font_size'  => [],
                    'text_align' => [
                        'default' => 'center',
                    ],
                ],
            ],
            'margin_padding' => [
                'css' => [
                    'main'      => 'section%%order_class%%',
                    'important' => 'all',
                ],
            ],
            'link_options'   => false,
        ];
    }

    public function get_selector( $key ) {
        $selectors = [
            'time'  => '%%order_class%% .course-value',
            'title' => '%%order_class%% .course-title',
        ];
    }

    /**
     * Custom css fields.
     */
    public function get_custom_css_fields_config() {
        return [];
    }

    /**
     * Divi module fields.
     *
     * @return [type] [description]
     */
    public function get_fields() {
        $fields = [];
        $fields['post_id'] = $this->container['divi_modules']->recipe_post_select_field();
        $fields['show_title'] = [
            'label'       => esc_html__( 'Show Title', 'food-recipes' ),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__( 'No', 'food-recipes' ),
                'on'  => esc_html__( 'Yes', 'food-recipes' ),
            ],
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__( 'Toggle on if you want to show the title', 'food-recipes' ),
            'default'     => 'on',
        ];
        $fields['title_text'] = [
            'label'       => esc_html__( 'Title Text', 'food-recipes' ),
            'type'        => 'text',
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__( 'Title name', 'food-recipes' ),
            'show_if'     => [
                'show_title' => 'on',
            ],
            'default'     => 'Course',
        ];
        $fields['layout'] = [
            'label'       => esc_html__( 'Layout', 'food-recipes' ),
            'type'        => 'select',
            'options'     => [
                'single' => 'Single Line',
                'multi'  => 'Multi Line',
            ],
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__( 'Select `Single Line` to show title and time one same line. Select `Multi Line` to show title and cuisine on separate lines.', 'food-recipes' ),
            'default'     => 'single',
        ];
        $fields['admin_label'] = [
            'label'       => __( 'Admin Label', 'food-recipes' ),
            'type'        => 'text',
            'description' => 'This will change the label of the module in the builder for easy identification.',
        ];
        return $fields;
    }

    /**
     * Settings modal toggle
     *
     * @return [type] [description]
     */
    public function get_settings_modal_toggles() {
        $toggles['general']['toggles']['main_content'] = esc_html__( 'Recipe Course', 'food-recipes' );
        $toggles['advanced'] = [
            'toggles' => [
                'title'     => esc_html__( 'Title', 'food-recipes' ),
                'time_text' => esc_html__( 'Course', 'food-recipes' ),
            ],
        ];
        return $toggles;
    }

    /**
     * Render function
     *
     * @param  [type] $unprocessed_props [description]
     * @param  [type] $content           [description]
     * @param  [type] $render_slug       [description]
     * @return [type] [description]
     */
    public function render( $unprocessed_props, $content = null, $render_slug ) {
        $module_classes = $this->module_classname( $render_slug );
        $module_class = trim( ET_Builder_Element::add_module_order_class( '', $render_slug ) );
        $defaults = [
            'post_id'    => 'recipe--1',
            'title_text' => __( 'Course', 'food-recipes' ),
            'show_title' => 'on',
            'layout'     => 'single',
        ];
        foreach ( $defaults as $key => $value ) {
            if ( isset( $this->props[$key] ) and empty( $this->props[$key] ) ) {
                $this->props[$key] = $value;
            }
        }
        $props = wp_parse_args( $this->props, $defaults );
        $recipe_post = $this->container['divi_modules']->get_post_from_props( $props );
        $course_text = '-';
        if ( $recipe_post && $recipe_post->post_type == 'wpt-food-recipe' ) {
            $recipe = $this->container['recipes']->get( $recipe_post->ID );
            $course = $recipe->get_categories();
            $course_text = $course['formatted'];
        } else {
            $course_text = $this->container['dummy_recipe']->get_course_text();
        }
        $main_selector = 'section.' . $module_class;
        ob_start();
        require $this->container['plugin_dir'] . '/resources/views/divi/course.php';
        return ob_get_clean();
    }

    protected function _render_module_wrapper( $output = '', $render_slug = '' ) {
        return $output;
    }

}
