<?php

namespace WPT_Recipe_Divi_Modules\FoodRecipeAuthorModule;

use ET_Builder_Module;
use ET_Builder_Element;
/**
 * FoodRecipeTitle.
 */
class FoodRecipeAuthorModule extends ET_Builder_Module {
    public $main_css_element = 'section%%order_class%%';

    public $name = 'Recipe Author';

    public $slug = 'et_pb_wpt_recipe_author';

    public $vb_support = 'on';

    protected $container;

    protected $module_credits = [
        'module_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
        'author'     => 'WP Tools → Get 7 day FREE Trial',
        'author_uri' => 'https://wptools.app/wordpress-plugin/food-recipe-plugin/?utm_source=divi-module&utm_medium=page&utm_campaign=recipe-plugin&utm_content=free',
    ];

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
        parent::__construct();
        $this->name = __( 'Recipe Author', 'food-recipes' );
    }

    public function init() {
        $this->container['divi_author_fields']->set_module( $this );
    }

    /**
     * Advanced fields.
     */
    public function get_advanced_fields_config() {
        $config = [
            'borders'        => [
                'default' => [
                    'css' => [
                        'main' => [
                            'border_styles' => "{$this->main_css_element}",
                            'border_radii'  => "{$this->main_css_element}",
                        ],
                    ],
                ],
                'image'   => [
                    'css'         => [
                        'main' => [
                            'border_styles' => $this->get_selector( 'author_image' ),
                            'border_radii'  => $this->get_selector( 'author_image' ),
                        ],
                    ],
                    'tab_slug'    => 'advanced',
                    'toggle_slug' => 'author_image',
                ],
            ],
            'text'           => false,
            'box_shadow'     => [
                'default' => [
                    'css' => [
                        'main'      => "{$this->main_css_element}",
                        'important' => 'all',
                    ],
                ],
            ],
            'filters'        => [
                'css' => [
                    'main' => 'section%%order_class%%',
                ],
            ],
            'animation'      => false,
            'text_shadow'    => false,
            'max_width'      => false,
            'fonts'          => [],
            'margin_padding' => [
                'css' => [
                    'main'      => 'section%%order_class%%',
                    'important' => 'all',
                ],
            ],
            'link_options'   => false,
        ];
        $this->container['divi_author_fields']->set_advanced_font_definition( $config, 'author_name' );
        $this->container['divi_author_fields']->set_advanced_font_definition( $config, 'author_name_link' );
        $this->container['divi_author_fields']->set_advanced_font_definition( $config, 'name_prefix' );
        return $config;
    }

    /**
     * Custom css fields.
     */
    public function get_custom_css_fields_config() {
        return $this->container['divi_author_fields']->get_css_fields();
    }

    /**
     * Divi module fields.
     *
     * @return [type] [description]
     */
    public function get_fields() {
        return $this->container['divi_author_fields']->get_fields();
    }

    public function get_default( $key ) {
        return $this->container['divi_author_fields']->get_default( $key );
    }

    public function get_selector( $key ) {
        return $this->container['divi_author_fields']->get_selector( $key );
    }

    /**
     * Settings modal toggle
     *
     * @return [type] [description]
     */
    public function get_settings_modal_toggles() {
        $toggles['general']['toggles']['main_content'] = esc_html__( 'Recipe Author', 'food-recipes' );
        $this->container['divi_author_fields']->set_advanced_toggles( $toggles );
        return $toggles;
    }

    /**
     * Render function
     *
     * @param  [type] $unprocessed_props [description]
     * @param  [type] $content           [description]
     * @param  [type] $render_slug       [description]
     * @return [type] [description]
     */
    public function render( $unprocessed_props, $content = null, $render_slug ) {
        $module_classes = $this->module_classname( $render_slug );
        $module_class = trim( ET_Builder_Element::add_module_order_class( '', $render_slug ) );
        $defaults = $this->container['divi_author_fields']->get_defaults();
        foreach ( $defaults as $key => $value ) {
            if ( isset( $this->props[$key] ) and empty( $this->props[$key] ) ) {
                $this->props[$key] = $value;
            }
        }
        $props = wp_parse_args( $this->props, $defaults );
        $recipe_post = $this->container['divi_modules']->get_post_from_props( $props );
        $author = [];
        if ( $recipe_post && $recipe_post->post_type == 'wpt-food-recipe' ) {
            $recipe = $this->container['recipes']->get( $recipe_post->ID );
            $author = $recipe->get_author();
        } else {
            $author = $this->container['dummy_recipe']->get_author();
        }
        $main_selector = 'section.' . $module_class;
        if ( $props['show_image'] == 'off' ) {
            \ET_Builder_Element::set_style( $render_slug, [
                'selector'    => $main_selector,
                'declaration' => 'grid-template-columns: 100fr;',
            ] );
        } else {
            \ET_Builder_Element::set_style( $render_slug, [
                'selector'    => $main_selector,
                'declaration' => sprintf( 'grid-template-columns: %s max-content !important; grid-column-gap: %s;', $props['image_size'], $props['spacing_right'] ),
            ] );
        }
        ob_start();
        require $this->container['plugin_dir'] . '/resources/views/divi/author.php';
        return ob_get_clean();
    }

    protected function _render_module_wrapper( $output = '', $render_slug = '' ) {
        return $output;
    }

}
