<?php
namespace WPT_Recipe_Divi_Modules\FoodRecipeAuthorModule;

/**
 * .
 */
class Fields
{
    protected $container;
    protected $module;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    /**
     * Set the module instance.
     */
    public function set_module($module)
    {
        $this->module = $module;
    }

    /**
     * Get selector
     */
    public function get_selector($key)
    {
        $selectors = $this->get_selectors();

        return $selectors[$key]['selector'];
    }

    /**
     * List of selectors
     */
    public function get_selectors()
    {
        return [
            'author_name'            => [
                'selector' => "{$this->module->main_css_element} .author-name",
                'label'    => __('Author Name', 'food-recipes'),
            ],
            'author_name_link'       => [
                'selector' => "{$this->module->main_css_element} .author-name a",
                'label'    => __('Author Name Link', 'food-recipes'),
            ],
            'name_prefix'            => [
                'selector' => "{$this->module->main_css_element} .name-prefix",
                'label'    => __('Prefix Text (Recipe By)', 'food-recipes'),
            ],
            'author_image_container' => [
                'selector' => "{$this->module->main_css_element} div.author-image-container",
                'label'    => __('Author Image Container', 'food-recipes'),
            ],
            'author_image'           => [
                'selector' => "{$this->module->main_css_element} div.author-image-container img",
                'label'    => __('Author Image', 'food-recipes'),
            ],
        ];
    }

    /**
     * Get default for given keys
     */
    public function get_default($key)
    {
        $defaults = $this->get_defaults();

        return isset($defaults[$key]) ? $defaults[$key] : '';
    }

    /**
     * Get defaults
     */
    public function get_defaults()
    {
        $defaults = [
            'post_id'       => 'recipe--1',
            'show_image'    => 'on',
            'image_size'    => '40px',
            'spacing_right' => '10px',
        ];

        return $defaults;
    }

    /**
     * Get module fields
     */
    public function get_fields()
    {
        $fields = [];

        $fields['post_id'] = $this->container['divi_modules']->recipe_post_select_field();

        $fields['admin_label'] = [
            'label'       => __('Admin Label', 'food-recipes'),
            'type'        => 'text',
            'description' => __('This will change the label of the module in the builder for easy identification.', 'food-recipes'),
        ];
        $fields = array_merge($fields, $this->get_author_image_fields());

        return $fields;
    }

    public function get_author_image_fields()
    {
        $fields = [];

        $fields['show_image'] = [
            'label'       => esc_html__('Show Image', 'food-recipes'),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__('Off', 'food-recipes'),
                'on'  => esc_html__('On', 'food-recipes'),
            ],
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'author_image',
            'description' => esc_html__('', 'food-recipes'),
            'show_if'     => [],
            'default'     => $this->get_default('show_image'),
        ];

        $fields['image_size'] = [
            'label'          => esc_html__('Image Size', 'food-recipes'),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 300,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'author_image',
            'description'    => esc_html__('', 'food-recipes'),
            'show_if'        => ['show_image' => 'on'],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => $this->get_default('image_size'),
        ];

        $fields['spacing_right'] = [
            'label'          => esc_html__('Right Spacing', 'food-recipes'),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 1,
                'max'  => 300,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'author_image',
            'description'    => esc_html__('', 'food-recipes'),
            'show_if'        => ['show_image' => 'on'],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => $this->get_default('spacing_right'),
        ];

        return $fields;
    }

    public function get_css_fields()
    {
        $selectors = $this->get_selectors();

        foreach ($selectors as $key => $selector) {
            $selectors[$key]['selector'] = "html body div#page-container " . $selector['selector'];
        }

        return $selectors;
    }

    public function set_advanced_toggles(&$toggles)
    {
        $selectors = $this->get_selectors();

        foreach ($selectors as $slug => $selector) {
            $toggles['advanced']['toggles'][$slug] = $selector['label'];
        }
    }

    /**
     * Advanced font definition
     */
    public function get_advanced_font_definition($key)
    {
        return [
            'css' => [
                'main'      => $this->get_selector($key),
                'important' => 'all',
            ],
        ];
    }

    public function set_advanced_font_definition(
        &$config,
         $key
    ) {
        $config['fonts'][$key] = $this->get_advanced_font_definition($key);
    }

}
