/**
 * External dependencies.
 */
import React from 'react';
import { Component } from '@wordpress/element';
import { SelectControl } from '@wordpress/components';



class Iso8601DurationField extends Component {
  constructor() {
    super( ...arguments );
    this.updateValue = this.updateValue.bind( this );
    this.getOptions = this.getOptions.bind( this );

}
	componentDidMount() {
		this.setState({
			years: this.props.value.years,
			months: this.props.value.months,
			days: this.props.value.days,
			hours: this.props.value.hours,
			minutes: this.props.value.minutes,
			seconds: this.props.value.seconds,
		})
	}

	getOptions(min, max) {
		let options  = [];

		for (var i = min; i <= max; i++) {
			let year = i.toString();

			options.push({
				"label" : year,
				"value" : year,
			})
		}

		return options;

	}

	updateValue(key, value) {
		let values = JSON.parse(JSON.stringify(this.state));
		values[key] = value;
		this.setState(values);

		const { id, onChange } = this.props;
		let iso8601 = `P${values.years}Y${values.months}M${values.days}DT${values.hours}H${values.minutes}M${values.seconds}S`

		onChange( id, {
			iso8601 : iso8601,
			years: values.years,
			months: values.months,
			days: values.days,
			hours: values.hours,
			minutes: values.minutes,
			seconds: values.seconds,
		} );

	}
	/**
	 * Renders the component.
	 *
	 * @return {Object}
	 */
	render() {
		const {
			name,
			value
		} = this.props;

		return (
			<div className='iso-8601-duration-container' style={{display: 'flex'}}>
				<input
					type="hidden"
					name={ `${ name }[iso8601]` }
					value={ value.iso8601 }
					readOnly
					/>
				<input
					type="hidden"
					name={ `${ name }[years]` }
					value={ value.years }
					readOnly
					/>
				<input
					type="hidden"
					name={ `${ name }[months]` }
					value={ value.months }
					readOnly
					/>
				<input
					type="hidden"
					name={ `${ name }[days]` }
					value={ value.days }
					readOnly
					/>
				<input
					type="hidden"
					name={ `${ name }[hours]` }
					value={ value.hours }
					readOnly
					/>
				<input
					type="hidden"
					name={ `${ name }[minutes]` }
					value={ value.minutes }
					readOnly
					/>
				<input
					type="hidden"
					name={ `${ name }[seconds]` }
					value={ value.seconds }
					readOnly
					/>

				<div style={{marginRight: 10}}>
					<SelectControl
					    label="Years"
					    defaultValue={ this.props.value.years }
					    onChange={ ( selected ) => { this.updateValue('years', selected) }  }
					    options={this.getOptions(0, 99)}
					/>
				</div>


				<div style={{marginRight: 10}}>
					<SelectControl
					    label="Months"
					    defaultValue={ this.props.value.months }
					    onChange={ ( selected ) => { this.updateValue('months', selected) }  }
					    options={this.getOptions(0, 12)}
					/>
				</div>

				<div style={{marginRight: 10}}>
					<SelectControl
					    label="Days"
					    defaultValue={ this.props.value.days }
					    onChange={ ( selected ) => { this.updateValue('days', selected) }  }
					    options={this.getOptions(0, 31)}
					/>
				</div>

				<div style={{marginRight: 10}}>
					<SelectControl
					    label="Hours"
					    defaultValue={ this.props.value.hours }
					    onChange={ ( selected ) => { this.updateValue('hours', selected) }  }
					    options={this.getOptions(0, 23)}
					/>
				</div>

				<div style={{marginRight: 10}}>
					<SelectControl
					    label="Minutes"
					    defaultValue={ this.props.value.minutes }
					    onChange={ ( selected ) => { this.updateValue('minutes', selected) }  }
					    options={this.getOptions(0, 59)}
					/>
				</div>



				<div style={{marginRight: 10}}>
					<SelectControl
					    label="Seconds"
					    defaultValue={ this.props.value.seconds }
					    onChange={ ( selected ) => { this.updateValue('seconds', selected) }  }
					    options={this.getOptions(0, 59)}
					/>
				</div>


			</div>
		);
	}
}

export default Iso8601DurationField;
