# Creating a new Carbon Field

Step-by-step guide on how to create a new Carbon Field.

## Introduction

The [Carbon Fields](https://github.com/htmlburger/carbon-fields) library has many built-in fields, but you may find it necessary to define a new type of field for your specific project needs.

The following tutorial will explain how to create a custom Carbon Field.

### Step 1: Download the template

To make it as easy as possible, we have prepared a Carbon Field template that contains a frame for the PHP Carbon Field class and a webpack build process.

You can download the template from here: https://github.com/htmlburger/carbon-field-template

Template Structure

- `/src` - field files folder
- `/languages` - folder for .po, .mo and .pot files
- `/core` - folder for all of your .php files
- `/field.php` - bootstrapping php code

### Step 2: Name your field

Replace the `Iso8601Duration` and `iso8601_duration` (case sensitive) placeholders in all files. Also rename the files that contain the placeholders.

**NB!** If your field name contains multiple words, for example Image Gallery, your class names should look like this:

* **PHP class:** `Image_Gallery_Field`
* **Field Component Registration:** `image_gallery` (refer to `registerFieldType`@`/src/index.js`)

### Step 3: Build assets

1. Execute `composer dump-autoload` to create the required `autoload.php` which needs to be included in your theme.
1. Execute `yarn install` in the root directory to install all build process requirements.
1. Execute `yarn build` to build the final minimized bundle

##### Optional

Execute `yarn start` to continuously build bundle during development. Note that you should add `define( 'SCRIPT_DEBUG', true );` to your `wp-config.php` file in order to load the files generated by the dev build process.

### Step 4: Customize

Here is a quick overview of some of the methods you can customize:

#### PHP

`to_json()`

You can use this method to modify the field properties that are passed to the React component which represents the field.

`field_type_activated`

Used for initialization processes that are called once per field type (e.g. setup localization files).

`admin_enqueue_scripts()`

Used to enqueue CSS/JavaScript files.

`admin_init()`

Called for each field instance when the field is initialized. (back-end)

`init()`

Called for each field instance when the field is initialized. (back-end, front-end)
