<?php

namespace WPT\Recipe\WP;

/**
 * Bootstrap.
 */
class Bootstrap {
    protected $container;

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
    }

    /**
     * Register activation hook
     */
    public function register_activation_hook() {
        flush_rewrite_rules( true );
    }

    /**
     * Load post types
     */
    public function load_post_types() {
        include_once $this->container['plugin_dir'] . '/post-types/wpt-food-recipe.php';
        include_once $this->container['plugin_dir'] . '/post-types/wpt-food-ingredients.php';
        include_once $this->container['plugin_dir'] . '/taxonomies/wpt-food-recipe-cat.php';
    }

    /**
     * Load carbon fields.
     */
    public function load_carbon_fields() {
        if ( !defined( 'Carbon_Fields\\DIR' ) ) {
            define( 'Carbon_Fields\\DIR', $this->container['plugin_dir'] . '/vendor/htmlburger/carbon-fields' );
        }
        require_once $this->container['plugin_dir'] . '/includes/lib/wptools-carbon-duration-field/field.php';
        \Carbon_Fields\Carbon_Fields::boot();
    }

    /**
     * Register carbon fields.
     */
    public function carbon_fields_register() {
        $this->container['recipe_post_meta_fields']->register_fields();
        $this->container['recipe_term_meta_fields']->register_fields();
        $this->container['recipe_settings']->register_fields();
    }

    public function admin_css() {
        echo "<style>\n        .cf-field.one_four {flex: 0.25 !important}\n        .cf-field.one_five {flex: 0.2 !important}\n        .cf-field.two_five {flex: 0.4 !important}\n        .cf-field.one_three {flex: calc(1/3) !important}\n            </style>";
    }

    /**
     * Post featured image
     */
    public function get_featured_image( $post_id ) {
        $attachment_id = get_post_thumbnail_id( $post_id );
        return $this->get_attachment_image( $attachment_id );
    }

    /**
     * Attachment image
     */
    public function get_attachment_image( $attachment_id ) {
        $featured_image = '';
        if ( $attachment_id ) {
            $featured_image = wp_get_attachment_image_url( $attachment_id, '' );
        }
        return $featured_image;
    }

    /**
     * On plugins loaded action
     */
    public function on_plugins_loaded() {
        load_plugin_textdomain( 'food-recipes', false, dirname( plugin_basename( $this->container['plugin_file'] ) ) . '/languages/' );
    }

}
