<?php
namespace WPT\Recipe\Recipe;

/**
 * View.
 */
class View
{
    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    /**
     * View for rendering a instruction step
     */
    public function instruction_step(
        $instruction,
        $recipe,
        $props,
        $iter,
        $group_name
    ) {
        $media_type = $instruction['media_type'];

        $id = sprintf(
            'recipe-step%s-%s',
            $group_name ? '-' . sanitize_title($group_name) : '',
            $iter
        );

        ob_start();
        require $this->container['plugin_dir'] . '/resources/views/divi/partials/instruction_step.php';
        return ob_get_clean();
    }

    public function instruction_image(
        $instruction,
        $recipe,
        $props
    ) {
        $image = do_shortcode(sprintf('[et_pb_image src="%s" show_in_lightbox="%s" use_overlay="%s" overlay_icon_color="%s" hover_overlay_color="%s" hover_icon="%s" module_class="instruction-image"][/et_pb_image]',
            $instruction['image'],
            $props['show_image_lightbox'],
            $props['use_image_overlay'],
            $props['image_overlay_icon_color'],
            $props['image_hover_overlay_color'],
            $props['image_hover_icon']
        ));
        $image = str_replace('et-waypoint', '', $image);
        $image = str_replace('et-animated', '', $image);
        $image = str_replace('et_had_animation', '', $image);
        return $image;
    }

    /**
     * View for rendering a video.
     */
    public function video(
        $video,
        $props
    ) {
        $image = '';
        $src   = '';
        if ($video['image_src']) {
            $image = sprintf('<amp-img src="%s" placeholder layout="fill" />', $video['image_src']);
        }

        $amp_html = '';

        switch ($video['type']) {
            case 'youtube':
                $amp_html = sprintf('<amp-youtube data-videoid="%s" width="16" height="9" layout="responsive">%s</amp-youtube>', $video['youtube_id'], $image);
                break;

            case 'vimeo':
                $amp_html = sprintf('<amp-vimeo data-videoid="%s" width="16" height="9" layout="responsive">%s</amp-vimeo>', $video['vimeo_id'], $image);
                break;

            case 'facebook':
                $amp_html = sprintf('<amp-facebook data-embed-as="video" data-href="%s" width="16" height="9" layout="responsive">%s</amp-facebook>', $video['facebook_id'], $image);
                break;

            case 'html5':
                $webm = '';
                $mp4  = '';

                if ($video['html5_video']) {
                    $mp4 = sprintf('<source src="%s"  type="video/mp4" />', $video['html5_video']);
                }

                if ($video['html5_video_webm']) {
                    $webm = sprintf('<source src="%s"  type="video/webm" />', $video['html5_video_webm']);
                }

                $amp_html = sprintf('<amp-video controls width="16" height="9" layout="responsive" poster="%s">%s%s<div fallback><p>This browser does not support the video element.</p></div></amp-video>',
                    $src,
                    $mp4,
                    $webm
                );
                break;

            default:
                # code...
                break;
        }

        return $amp_html;
    }

}
