<?php
namespace WPT\Recipe\Recipe;

use Carbon_Fields\Field;
use Carbon_Fields\Container;

/**
 * TermMetaFields.
 */
class TermMetaFields
{
    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    public function register_fields()
    {
        $container = Container::make('term_meta', __('Category Fields', 'food-recipes'))
            ->where('term_taxonomy', '=', 'wpt-food-recipe-cat')
            ->add_fields($this->get_fields());

        return $container;
    }

    public function get_fields()
    {
        $fields = [];

        $fields[] = Field::make('image', 'cat_image', __('Image', 'food-recipes'))
            ->set_help_text(__('Set an image that defines the category. Images across all categories should have same aspect ratio', 'food-recipes'));

        return $fields;
    }

}
