<?php
namespace WPT\Recipe\Recipe\Templates;

/**
 * Recipe template while printing
 */
class PrintTemplate
{
    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    /**
     * Add the wordpress actions.
     */
    public function add_hooks()
    {
        add_filter('single_template', [$this, 'single_template'], 9999999, 1);

    }

    /**
     * Redirect to print template if conditions meet.
     */
    public function single_template($template)
    {
        global $post;

        if (($post->post_type == 'wpt-food-recipe') && isset($_GET['print'])) {
            $recipe = new \WPT\Recipe\Recipe\Recipe($post->ID, $this->container);
            include $this->container['plugin_dir'] . '/resources/templates/recipe/print.php';
            exit;
        }

        return $template;

    }

}
