<?php
namespace WPT\Recipe\Recipe;

use Carbon_Fields\Field;
use Carbon_Fields\Container;

/**
 * Settings.
 */
class Settings
{
    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    public function register_fields()
    {
        $container = Container::make('theme_options', 'Settings')
            ->set_page_parent('edit.php?post_type=wpt-food-recipe')
            ->add_fields($this->get_fields());

        return $container;
    }

    public function get_fields()
    {
        $fields = [];

        $fields[] = Field::make('text', 'wpt_recipe_defaut_author_image', __('Default Author Image', 'food-recipes'))
            ->set_default_value('https://static.wptools.app/assets/placeholder/recipe-plugin/author-image.jpg')
            ->set_help_text(__('Set the default author image url. In case of missing author image, this image will be used.', 'food-recipes'));

        return $fields;
    }

}
