<?php
namespace WPT\Recipe\Recipe;

/**
 * Recipes.
 */
class Recipes
{
    protected $container;
    public $recipes;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
        $this->recipes   = [];
    }

    public function has($post_id)
    {
        return isset($this->recipes[$post_id]);
    }

    public function get($post_id)
    {
        if ($this->has($post_id)) {
            return $this->recipes[$post_id];
        } else {
            return $this->add($post_id);
        }
    }

    public function add($post_id)
    {
        $recipe                  = new Recipe($post_id, $this->container);
        $this->recipes[$post_id] = $recipe;
        return $recipe;
    }

    public function all()
    {
        return get_posts([
            'numberposts' => -1,
            'post_type'   => 'wpt-food-recipe',
            'post_status' => 'publish',
        ]);
    }

    public function all_as_options()
    {
        $all_posts = $this->all();
        $posts     = ['recipe--1' => __('-- Use Current Recipe Post --', 'food-recipes')];

        if ($all_posts) {
            foreach ($all_posts as $post_item) {
                $posts[$post_item->ID] = $post_item->post_title;
            }
        }

        return $posts;
    }

}
