<?php

namespace WPT\Recipe\Recipe;

use Carbon_Fields\Field;
use Carbon_Fields\Container;
/**
 * RecipePostMeta.
 */
class PostMetaFields {
    protected $container;

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
    }

    /**
     * Register Post Meta Fields.
     */
    public function register_fields() {
        $container = Container::make( 'post_meta', __( 'Recipe Information', 'food-recipes' ) )->set_context( 'advanced' )->where( 'post_type', '=', 'wpt-food-recipe' )->add_fields( $this->get_fields() );
        return $container;
    }

    /**
     * post meta fields
     */
    public function get_fields() {
        $fields = [];
        $fields[] = Field::make( 'html', 'wpt_recipe_media_section', __( 'Section Description', 'food-recipes' ) )->set_html( __( '<h4>Media Section</h4><i>Information regarding media related to the recipe</i>', 'food-recipes' ) );
        $fields[] = Field::make( 'rich_text', 'wpt_recipe_preamble', __( 'Preamble', 'food-recipes' ) )->set_help_text( __( 'Preamble for the recipe. Its not part of the recipe SEO. Can be used in layouts which have text before the actual recipe.', 'food-recipes' ) );
        $fields[] = Field::make( 'image', 'wpt_recipe_image', __( 'Image', 'food-recipes' ) )->set_help_text( __( 'Image of the completed dish. For best results, provide high-resolution image (minimum of 50K pixels when multiplying width and height) with the following aspect ratios: 16x9, 4x3, and 1x1.', 'food-recipes' ) );
        $fields[] = Field::make( 'html', 'wpt_recipe_general_section', '' )->set_html( __( '<h4>General Section</h4>', 'food-recipes' ) );
        $fields[] = Field::make( 'textarea', 'wpt_recipe_description', __( 'Description', 'food-recipes' ) )->set_help_text( __( 'A short summary describing the dish.', 'food-recipes' ) );
        $fields[] = Field::make( 'select', 'wpt_recipe_author', __( 'Author', 'food-recipes' ) )->set_options( [
            'none'        => __( 'None', 'food-recipes' ),
            'post_author' => __( 'Post Author', 'food-recipes' ),
            'custom'      => __( 'Custom', 'food-recipes' ),
        ] );
        $fields[] = Field::make( 'text', 'wpt_recipe_author_name', __( 'Author Name', 'food-recipes' ) )->set_help_text( __( 'Enter name of the author', 'food-recipes' ) )->set_conditional_logic( [[
            'field' => 'wpt_recipe_author',
            'value' => 'custom',
        ]] );
        $fields[] = Field::make( 'text', 'wpt_recipe_author_url', __( 'Author URL', 'food-recipes' ) )->set_help_text( __( 'URL representing the author', 'food-recipes' ) )->set_conditional_logic( [[
            'field' => 'wpt_recipe_author',
            'value' => 'custom',
        ]] );
        $fields[] = Field::make( 'text', 'wpt_recipe_author_img', __( 'Author Image', 'food-recipes' ) )->set_help_text( __( 'Author Image URL', 'food-recipes' ) )->set_conditional_logic( [[
            'field' => 'wpt_recipe_author',
            'value' => 'custom',
        ]] );
        $fields[] = Field::make( 'text', 'wpt_recipe_yield', __( 'Serving/Yield', 'food-recipes' ) )->set_attribute( 'type', 'number' )->set_attribute( 'min', '1' )->set_help_text( __( 'The quantity produced by the recipe. Specify the number of servings produced from this recipe with just a number', 'food-recipes' ) );
        $fields[] = Field::make( 'text', 'wpt_recipe_yield_unit', __( 'Serving/Yield Unit', 'food-recipes' ) )->set_attribute( 'placeholder', __( 'people/cookies', 'food-recipes' ) )->set_help_text( __( 'Unit of the serving. For example people, cups, cookies etc', 'food-recipes' ) );
        $fields[] = Field::make( 'text', 'wpt_recipe_cost', __( 'Estimated Cost', 'food-recipes' ) )->set_attribute( 'placeholder', __( '$9', 'food-recipes' ) )->set_help_text( __( 'Estimated cost of the materials/effort needed to create the recipe', 'food-recipes' ) );
        $fields[] = Field::make( 'html', 'wpt_recipe_categories_section', '' )->set_html( __( '<h4>Recipe Categories Section</h4>', 'food-recipes' ) );
        $fields[] = Field::make( 'set', 'wpt_recipe_categories', __( 'Categories', 'food-recipes' ) )->add_options( [
            'Breakfast'   => __( 'Breakfast', 'food-recipes' ),
            'Appetizer'   => __( 'Appetizer', 'food-recipes' ),
            'Soup'        => __( 'Soup', 'food-recipes' ),
            'Main Course' => __( 'Main Course', 'food-recipes' ),
            'Side Dish'   => __( 'Side Dish', 'food-recipes' ),
            'Salad'       => __( 'Salad', 'food-recipes' ),
            'Dessert'     => __( 'Dessert', 'food-recipes' ),
            'Snack'       => __( 'Snack', 'food-recipes' ),
            'Drinks'      => __( 'Drinks', 'food-recipes' ),
        ] )->set_help_text( __( 'The type of meal or course your recipe is about. For example: "dinner", "main course", or "dessert, snack".', 'food-recipes' ) );
        $fields[] = Field::make( 'text', 'wpt_recipe_categories_others', '' )->set_attribute( 'placeholder', __( 'For any other categories, enter a comma-separated list over here', 'food-recipes' ) )->set_help_text( '' );
        $fields[] = Field::make( 'set', 'wpt_recipe_cuisines', __( 'Cuisines', 'food-recipes' ) )->add_options( [
            'French'        => __( 'French', 'food-recipes' ),
            'Italian'       => __( 'Italian', 'food-recipes' ),
            'Mediterranean' => __( 'Mediterranean', 'food-recipes' ),
            'Indian'        => __( 'Indian', 'food-recipes' ),
            'Chinese'       => __( 'Chinese', 'food-recipes' ),
            'Japanese'      => __( 'Japanese', 'food-recipes' ),
            'American'      => __( 'American', 'food-recipes' ),
            'Mexican'       => __( 'Mexican', 'food-recipes' ),
        ] )->set_help_text( __( 'The region associated with your recipe. For example, "French", Mediterranean", or "American".', 'food-recipes' ) );
        $fields[] = Field::make( 'text', 'wpt_recipe_cuisines_others', '' )->set_attribute( 'placeholder', __( 'For any other cuisine(s), enter a comma-separated list over here', 'food-recipes' ) )->set_help_text( '' );
        $fields[] = Field::make( 'text', 'wpt_recipe_keywords', __( 'Keywords', 'food-recipes' ) )->set_attribute( 'placeholder', __( 'winter apple pie, nutmeg crust', 'food-recipes' ) )->set_help_text( __( 'Other terms for your recipe such as the season ("summer"), the holiday ("Halloween"), or other descriptors ("quick", "easy", "authentic"). Comma-separated values', 'food-recipes' ) );
        $fields[] = Field::make( 'html', 'wpt_recipe_ingredients_section', '' )->set_html( __( '<h4>Ingredients / Materials Section</h4>', 'food-recipes' ) );
        $this->set_ingredient_field( $fields );
        $fields[] = Field::make( 'html', 'wpt_recipe_instructions_section', '' )->set_html( __( '<h4>Instructions Section</h4>', 'food-recipes' ) );
        $this->set_instructions_fields( $fields );
        $fields[] = Field::make( 'html', 'wpt_recipe_time_section', '' )->set_html( __( '<h4>Time Section</h4>', 'food-recipes' ) );
        $fields[] = Field::make( 'iso8601duration', 'wpt_recipe_prep_time', __( 'Prep Time', 'food-recipes' ) )->set_help_text( __( 'The length of time it takes to prepare the dish', 'food-recipes' ) );
        $fields[] = Field::make( 'iso8601duration', 'wpt_recipe_cook_time', __( 'Cook Time', 'food-recipes' ) )->set_help_text( __( 'The time it takes to actually cook the dish', 'food-recipes' ) );
        $fields[] = Field::make( 'rich_text', 'wpt_recipe_notes', __( 'Notes', 'food-recipes' ) )->set_help_text( __( 'Additional notes.', 'food-recipes' ) );
        return $fields;
    }

    /**
     * Instructions field
     */
    public function set_instructions_fields( &$fields ) {
        $fields[] = Field::make( 'radio', 'wpt_recipe_instruction_type', __( 'Instruction Type', 'food-recipes' ) )->set_options( [
            'simple'  => __( 'Simple List (Recommended)', 'food-recipes' ),
            'grouped' => __( 'Grouped List', 'food-recipes' ),
        ] )->set_help_text( __( 'Select the type of instruction for the recipe. Set it to "Simple List" for a simple list of instructions. Select "Grouped List" to create a group of instructions (For example recipe For pizza containing group instructions for "Red Sauce", "Pizza Dough" and "Making Pizza"). ', 'food-recipes' ) );
        $simple_instruction_field = $this->get_instruction_steps_field( 'wp_recipe_simple_instructions' );
        $simple_instruction_field->set_conditional_logic( [[
            'field'   => 'wpt_recipe_instruction_type',
            'value'   => 'simple',
            'compare' => '=',
        ]] );
        $fields[] = $simple_instruction_field;
        $fields[] = Field::make( 'complex', 'wpt_recipe_grouped_instructions', '' )->set_help_text( __( 'Group of steps to make the dish.', 'food-recipes' ) )->setup_labels( [
            'plural_name'   => __( 'Instruction Groups', 'food-recipes' ),
            'singular_name' => __( 'Instruction Group', 'food-recipes' ),
        ] )->add_fields( [Field::make( 'text', 'name', __( 'Group Name', 'food-recipes' ) )->set_help_text( __( 'Name of the group section', 'food-recipes' ) ), $this->get_instruction_steps_field( 'steps' )] )->set_conditional_logic( [[
            'field'   => 'wpt_recipe_instruction_type',
            'value'   => 'grouped',
            'compare' => '=',
        ]] )->set_header_template( '<%- name %>' );
    }

    public function get_instruction_steps_field( $field_name ) {
        $media_options = [
            'none' => __( 'None', 'food-recipes' ),
        ];
        $fields = [];
        $fields[] = Field::make( 'text', 'name', __( 'Name', 'food-recipes' ) )->set_classes( 'one_four' )->set_help_text( __( 'Title of the step', 'food-recipes' ) );
        $fields[] = Field::make( 'textarea', 'instruction', __( 'Instruction Text', 'food-recipes' ) )->set_classes( 'one_four' )->set_help_text( __( 'Step text instruction.', 'food-recipes' ) );
        $fields[] = Field::make( 'select', 'media_type', __( 'Media Type', 'food-recipes' ) )->set_classes( 'one_four' )->set_help_text( __( 'Select Image or Video if you want to associate an image/video with this step. Else select none.', 'food-recipes' ) )->set_options( $media_options );
        $fields[] = Field::make( 'image', 'step_image', __( 'Image', 'food-recipes' ) )->set_classes( 'one_four' )->set_help_text( __( 'An image representing this step.', 'food-recipes' ) )->set_conditional_logic( [[
            'field'   => 'media_type',
            'value'   => 'image',
            'compare' => '=',
        ]] );
        return Field::make( 'complex', $field_name, __( 'Steps', 'food-recipes' ) )->set_help_text( __( 'Steps of instructions.', 'food-recipes' ) )->setup_labels( [
            'plural_name'   => __( 'Steps', 'food-recipes' ),
            'singular_name' => __( 'Step', 'food-recipes' ),
        ] )->add_fields( $fields )->set_header_template( '<%- name %>' );
    }

    public function set_ingredient_field( &$fields ) {
        $ingredient_field = Field::make( 'complex', 'ingredients', '' )->add_fields( [
            Field::make( 'text', 'quantity', __( 'Quantity', 'food-recipes' ) )->set_classes( 'one_five' )->set_help_text( __( 'The quantity of the ingredient.', 'food-recipes' ) ),
            Field::make( 'association', 'ingredient', __( 'Name', 'food-recipes' ) )->set_classes( 'two_five' )->set_types( [[
                'type'      => 'post',
                'post_type' => 'wpt-food-ingredients',
            ]] )->set_min( 1 )->set_max( 1 )->set_help_text( __( 'Select the ingredient.', 'food-recipes' ) ),
            Field::make( 'text', 'unit', __( 'Quantity Unit', 'food-recipes' ) )->set_classes( 'one_five' )->set_help_text( __( 'Add the unit for the quantity', 'food-recipes' ) ),
            Field::make( 'text', 'notes', 'Notes' )->set_classes( 'one_five' )->set_help_text( __( 'Any notes related to the ingredient.', 'food-recipes' ) )
        ] )->setup_labels( [
            'plural_name'   => __( 'Ingredients', 'food-recipes' ),
            'singular_name' => __( 'Ingredient', 'food-recipes' ),
        ] )->set_help_text( __( 'Add the ingredient information related to the recipe', 'food-recipes' ) );
        $fields[] = Field::make( 'complex', 'wpt_recipe_ingredients', '' )->set_help_text( __( 'Create an ingredient group and add ingredients to that group. For example create a "Pizza Toppings" group and add the pizza toppings like mushrooms, onions, tomatoes etc.', 'food-recipes' ) )->add_fields( [Field::make( 'text', 'group_name', __( 'Group Name', 'food-recipes' ) )->set_help_text( __( 'Add the group name for the ingredient. For example Pizza Dough, Pizza Topping etc', 'food-recipes' ) ), $ingredient_field] )->setup_labels( [
            'plural_name'   => __( 'Ingredient Groups', 'food-recipes' ),
            'singular_name' => __( 'Ingredient Group', 'food-recipes' ),
        ] )->set_header_template( '
                <%- group_name %>
                ' );
    }

}
