<?php

namespace WPT\Recipe\Recipe;

/**
 * DummyRecipe.
 */
class DummyRecipe {
    protected $container;

    /**
     * Constructor.
     */
    public function __construct( $container ) {
        $this->container = $container;
    }

    public function get_title() {
        return __( 'Oil Free Vegan Pancakes', 'food-recipes' );
    }

    public function get_description() {
        return __( 'These kid friendly pancakes are a delicious healthy breakfast option for adults and kids alike.', 'food-recipes' );
    }

    public function get_author() {
        return [
            'type'  => 'custom',
            'name'  => 'Gordan Ramsay',
            'image' => 'https://static.wptools.app/assets/placeholder/recipe-plugin/author-image.jpg',
            'url'   => 'https://wptools.app/',
        ];
    }

    public function get_image_src() {
        return $this->container['plugin_url'] . '/images/recipe/pancake-finalised.jpg';
    }

    public function get_prep_time() {
        return __( '15 mins', 'food-recipes' );
    }

    public function get_cook_time() {
        return __( '45 mins', 'food-recipes' );
    }

    public function get_total_time() {
        return __( '1 hr', 'food-recipes' );
    }

    public function get_servings_text() {
        return __( '4', 'food-recipes' );
    }

    public function get_cuisine_text() {
        return __( 'American', 'food-recipes' );
    }

    public function get_course_text() {
        return __( 'Breakfast', 'food-recipes' );
    }

    public function get_ingredients() {
        return [
            __( 'Pancakes', 'food-recipes' ) => [
                __( '1 1/2 cups <a href="https://www.amazon.com/Hoosier-Hill-Farm-American-Powder/dp/B0099XI58S/" target="_blank">Dairy Free Milk</a>', 'food-recipes' ),
                __( '1 tbsp Flax Seeds', 'food-recipes' ),
                __( '1/2 cup Wholemeal Plain Flour', 'food-recipes' ),
                __( '1/2 cup Rolled Oats', 'food-recipes' ),
                __( '1/2 cup Raw Cashews', 'food-recipes' )
            ],
            __( 'Toppings', 'food-recipes' ) => [__( '1 tbsp Vanilla Extract', 'food-recipes' ), __( '1/2 cup Dairy Free Milk', 'food-recipes' )],
        ];
    }

    public function get_notes() {
        return 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sapien lacus, volutpat at felis et, sodales dapibus arcu. Aliquam eget mauris tellus. Curabitur sed eros magna. Aliquam cursus finibus mauris, et varius magna hendrerit sit amet. Aliquam erat volutpat. Aliquam euismod rutrum nunc sed pharetra. Quisque accumsan laoreet nisi quis auctor. Etiam elementum ipsum ac nulla sagittis, vel vehicula elit varius. Nullam sed luctus felis. Ut lacus ligula, efficitur pellentesque lacus vitae, posuere posuere massa. Donec feugiat, odio nec consequat rhoncus, augue odio consequat nunc, et rhoncus nunc massa gravida libero. Praesent consectetur metus tortor, nec molestie massa porta eu. Nunc nisl arcu, fringilla molestie erat vel, ultrices volutpat sem. Etiam hendrerit purus vel nisi maximus posuere. Nullam maximus nibh eu purus cursus, ac tincidunt sapien sagittis. Nunc tempor tellus id mollis euismod.';
    }

    public function get_instructions() {
        return [
            'raw' => [
                0 => [
                    '_type'       => '_',
                    'name'        => '',
                    'instruction' => __( 'Place all ingredients but the extra milk in the blender with the liquid first. Blend on low speed until combined.', 'food-recipes' ),
                    'media_type'  => 'none',
                    'video'       => [],
                    'step_image'  => '',
                ],
                1 => [
                    '_type'       => '_',
                    'name'        => '',
                    'instruction' => __( 'Heat a non stick frying pan on medium heat. Depending on your frying pan type, you may need to add a small amount of oil to the pan to prevent the pancakes sticking. ', 'food-recipes' ),
                    'media_type'  => 'none',
                    'video'       => [],
                    'step_image'  => '',
                ],
                2 => [
                    '_type'       => '_',
                    'name'        => '',
                    'instruction' => __( 'Pour batter onto pan for the first pancake. Cook until the edges of the pancake start to cook and small bubbles appear.', 'food-recipes' ),
                    'media_type'  => 'image',
                    'video'       => [],
                    'step_image'  => '458',
                    'image'       => $this->container['plugin_url'] . '/images/recipe/pancake-1024x660-1.jpg',
                ],
                3 => [
                    '_type'       => '_',
                    'name'        => '',
                    'instruction' => __( 'Flip pancake and cook for an additional minute until lightly browned on each side.', 'food-recipes' ),
                    'media_type'  => 'image',
                    'video'       => [],
                    'step_image'  => '459',
                    'image'       => $this->container['plugin_url'] . '/images/recipe/rodrigo-pereira-pKAcOQ1c2yI-unsplash.jpg',
                ],
                4 => [
                    '_type'       => '_',
                    'name'        => '',
                    'instruction' => __( 'Repeat with remaining batter. You may need to add extra liquid to the batter if it gets too thick. Mix this on low speed in the blender.', 'food-recipes' ),
                    'media_type'  => 'none',
                    'video'       => [],
                    'step_image'  => '',
                ],
                5 => [
                    '_type'       => '_',
                    'name'        => '',
                    'instruction' => __( 'Pancakes can be served hot, or wrapped individually and frozen.', 'food-recipes' ),
                    'media_type'  => 'none',
                    'video'       => [],
                    'step_image'  => '',
                ],
            ],
        ];
    }

}
