<?php

namespace WPT\Recipe;

use WPTools\Pimple\Container;
/**
 * Container
 */
class Loader extends Container {
    /**
     *
     * @var mixed
     */
    public static $instance;

    public function __construct() {
        parent::__construct();
        $this['bootstrap'] = function ( $container ) {
            return new WP\Bootstrap($container);
        };
        $this['recipe_post_meta_fields'] = function ( $container ) {
            return new Recipe\PostMetaFields($container);
        };
        $this['recipe_term_meta_fields'] = function ( $container ) {
            return new Recipe\TermMetaFields($container);
        };
        $this['recipe_settings'] = function ( $container ) {
            return new Recipe\Settings($container);
        };
        $this['dummy_recipe'] = function ( $container ) {
            return new Recipe\DummyRecipe($container);
        };
        $this['recipes'] = function ( $container ) {
            return new Recipe\Recipes($container);
        };
        $this['recipe_view'] = function ( $container ) {
            return new Recipe\View($container);
        };
        $this['ultimate_carousel'] = function ( $container ) {
            return new Integrations\UltimateCarousel($container);
        };
        $this['recipe_template_print'] = function ( $container ) {
            return new Recipe\Templates\PrintTemplate($container);
        };
        $this->register_divi_objects();
    }

    public function register_divi_objects() {
        $this['divi_modules'] = function ( $container ) {
            return new Divi\Modules($container);
        };
        $this['margin_padding'] = function ( $container ) {
            return new Divi\MarginPadding($container);
        };
        $this['divi_title_fields'] = function ( $container ) {
            return new \WPT_Recipe_Divi_Modules\FoodRecipeTitleModule\Fields($container);
        };
        $this['divi_instruction_fields'] = function ( $container ) {
            return new \WPT_Recipe_Divi_Modules\FoodRecipeInstructionsModule\Fields($container);
        };
        $this['divi_description_fields'] = function ( $container ) {
            return new \WPT_Recipe_Divi_Modules\FoodRecipeDescriptionModule\Fields($container);
        };
        $this['divi_author_fields'] = function ( $container ) {
            return new \WPT_Recipe_Divi_Modules\FoodRecipeAuthorModule\Fields($container);
        };
        $this['divi_author_image_fields'] = function ( $container ) {
            return new \WPT_Recipe_Divi_Modules\FoodRecipeAuthorImageModule\Fields($container);
        };
        $this['divi_notes_fields'] = function ( $container ) {
            return new \WPT_Recipe_Divi_Modules\FoodRecipeDescriptionModule\Fields($container);
        };
    }

    /**
     * Get container instance.
     */
    public static function getInstance() {
        if ( !self::$instance ) {
            self::$instance = new Loader();
        }
        return self::$instance;
    }

    /**
     * Plugin run
     */
    public function run() {
        $this['bootstrap']->load_post_types();
        register_activation_hook( $this['plugin_file'], [$this['bootstrap'], 'register_activation_hook'] );
        add_action( 'after_setup_theme', [$this['bootstrap'], 'load_carbon_fields'] );
        add_action( 'carbon_fields_register_fields', [$this['bootstrap'], 'carbon_fields_register'] );
        add_action( 'admin_head', [$this['bootstrap'], 'admin_css'] );
        add_action( 'et_builder_ready', [$this['divi_modules'], 'et_builder_ready'], 1 );
        add_action( 'divi_extensions_init', [$this['divi_modules'], 'divi_extensions_init'] );
        add_action( 'wp_enqueue_scripts', [$this['divi_modules'], 'visual_builder_enqueue_scripts'] );
        // ultimate carousel integrations
        add_filter(
            'uc_post_type_item_content',
            [$this['ultimate_carousel'], 'recipe_content'],
            10,
            2
        );
        add_filter(
            'uc_post_type_item_image_url',
            [$this['ultimate_carousel'], 'recipe_image_url'],
            10,
            2
        );
        add_filter(
            'uc_term_item_image_url',
            [$this['ultimate_carousel'], 'category_image_url'],
            10,
            2
        );
        add_filter(
            'use_block_editor_for_post_type',
            function ( $current_status, $post_type ) {
                $post_types = ['wpt-food-recipe', 'wpt-food-ingredients', 'wpt-food-equipments'];
                if ( in_array( $post_type, $post_types ) ) {
                    return true;
                }
                return $current_status;
            },
            999999,
            2
        );
        $this['recipe_template_print']->add_hooks();
        add_action( 'plugins_loaded', [$this['bootstrap'], 'on_plugins_loaded'] );
    }

}
