<?php
namespace WPT\Recipe\Integrations;

/**
 * UltimateCarousel.
 */
class UltimateCarousel
{
    protected $container;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    /**
     * Filter integration for recipe content
     */
    public function recipe_content(
        $recipe_content,
        $recipe_post
    ) {
        if ($recipe_post->post_type == 'wpt-food-recipe') {
            return carbon_get_post_meta($recipe_post->ID, 'wpt_recipe_description');
        }

        return $recipe_content;
    }

    /**
     * Filter integration for recipe image url
     */
    public function recipe_image_url(
        $recipe_image_url,
        $recipe_post
    ) {

        if ($recipe_post->post_type == 'wpt-food-recipe') {
            $image_id = carbon_get_post_meta($recipe_post->ID, 'wpt_recipe_image');

            if ($image_id) {
                $attachment = wp_get_attachment_image_src($image_id, 'full');

                if ($attachment && isset($attachment[0])) {
                    return $attachment[0];
                }

            }

        }

        return $recipe_image_url;
    }

    /**
     * Filter for category image url
     */
    public function category_image_url(
        $image_url,
        $term
    ) {

        if ($term->taxonomy == 'wpt-food-recipe-cat') {
            $image_id = carbon_get_term_meta($term->term_id, 'cat_image');

            if ($image_id) {
                $attachment = wp_get_attachment_image_src($image_id, 'full');

                if ($attachment && isset($attachment[0])) {
                    return $attachment[0];
                }
            }

        }

        return $image_url;
    }

}
